/*  MBMAIL.H - 10/09/88  */

#define mb_version 9

extern char orgbbs[7], orgdate[7], orgmsg[6], orgtime[5]; 

extern char *mbfile, *mbbfile, *msgdir;
extern int mfl, mflb;

extern char  *ufwd, *bfwd;
extern short ufwdm, ufwdn, bfwdm, bfwdn;
extern short tstaleb, tstalen, tstaleu;
extern char  wpcall[ln_call];

/*  The list of calls to translate.  */

typedef struct XBBS_S
{
  char from[ln_call];
  char to[ln_call];
  struct XBBS_S *next;
} XBBS;

extern XBBS *xbbs;

/*  The list of calls to hold messages for.  */

typedef struct HOLD_S
{
  char call[ln_call];
  struct HOLD_S *next;
} HOLD;

extern HOLD *hold;

/*  Prompts associated with message commands.  */

#define num_mm 13
extern  char *mm[num_mm];

/*
 *  Message header record.
 */

#define m_read   0x01  /* Message has been read by recipient    */
#define m_fwd    0x02  /* Message has been forwarded            */
#define m_kill   0x04  /* Message marked for killing            */
#define m_busy   0x08  /* Message busy                          */

#define m_stale  0x20  /* Message unread and older than allowed */
#define m_hold   0x40  /* Do not forward this message           */
#define m_bull   0x80  /* This is a bulletin                    */

#define mhtitl 80      /* Length of title.                      */
#define mmhsunu 12     /* Unused                                */
#define mmesn 16       /* Number of calls in DIS list           */

typedef struct msg_hdr_s
{
  byte ext;           /* Header extension flag, or zero                  */
  word rn;            /* Record number of this record                    */
  word read;          /* # times the message has been read               */
  word number;        /* Message number                                  */
  word size;          /* Size in bytes                                   */
  char type;          /* Message type                                    */
  byte stat;          /* Message status, see bit definitions above       */
  char to  [ln_call]; /* Destination call                                */
  char from[ln_call]; /* Originator call                                 */
  char bbs [ln_call]; /* Destination BBS, or distribution list           */
  char date[ln_date]; /* Entry date                                      */
  char time[ln_time]; /* Entry time                                      */
  char bid[ln_bid];   /* Bulletin ID, if this is a bulletin              */
  char title[mhtitl]; /* Title of message                                */

  char call[mmesn][ln_call]; /* Calls to send to                         */
  byte flag[mmesn];          /* TRUE if need to send, FALSE if sent      */
  byte count;                /* number of calls in list                  */

  char unu[mmhsunu];
} MSG_HDR;


/*
 *  Mail file header record.
 */

#define mfhsunu 231

typedef struct mail_hdr_s
{
  word next;          /* Next record to allocate         */
  word first;         /* First message header record     */
  word last;          /* Last message header record      */
  word next_msg;      /* Next message number             */
  word unt_msg;       /* next_msg at last untangle       */
  byte version;       /* File format version number      */
  word free;          /* Spare word for future use       */
  word count;         /* Number of messages              */
  char date[ln_date]; /* Date of last untangle           */
  char time[ln_time]; /* Time of last untangle           */
  char unu[mfhsunu];
} MAIL_HDR;

extern MAIL_HDR *mfhs;
extern MSG_HDR  *tmmhs;
