*
*     VT100 function key definitions for extended keyboard.
*     Needs to have "recognize extended keypad" turned ON.
*
*     Cursor keys are those in separate cursor keypad.
*
*     PF1 = main keypad /
*     PF2 = extra keypad Page Up
*     PF3 = extra keypad Page Dn
*     PF4 = main keypad *
*
*     The reason for defining the PF-keys "out of order" is because
*     access to PF1 + other main keypad keys is easier that way.
*     PF1 is the "gold" key for editors like EDT, and it's less
*     of an awkward stretch to put it on the main keypad.
*
*     The rest of the numeric keypad acts just like VT100 keypad,
*     except that the '+' is like the '-' on the VT100 keypad.
*
*     Symbolically, here are the correspondences, with PC name on
*     top and VT100 name on bottom.
*
*      +---------+--------+--------+
*      | Insert  |  Home  | Page Up|
*      |         |        | (PF2)  |
*      +---------+--------+--------+
*      | Delete  |  End   | Page Dn|
*      |         |        | (PF3)  |
*      +---------+--------+--------+
*
*
*                +--------+
*                |   Up   |
*                |  (Up)  |
*      +---------+--------+--------+
*      |  Left   |  Down  | Right  |
*      | (Left)  | (Down) | (Right)|
*      +---------+--------+--------+
*
*      +---------+--------+--------+--------+
*      | Num Lock|  /     |   *    |   -    |
*      |         |  (PF1) | (PF4)  |  (-)   |
*      +---------+--------+--------+--------+
*      |    7    |   8    |   9    |        |
*      |   (7)   |  (8)   |  (9)   |   +    |
*      +---------+--------+--------+        +
*      |    4    |   5    |   6    |  (,)   |
*      |   (4)   |  (5)   |  (6)   |        |
*      +---------+--------+--------+--------+
*      |    1    |   2    |   3    |        |
*      |   (1)   |  (2)   |  (3)   | Enter  |
*      +---------+--------+--------+        +
*      |    0             |   .    |(Enter) |
*      |   (0)            |  (.)   |        |
*      +---------+--------+--------+--------+
*
*     <CTRL>PgUp and <CTRL>PgDn on the numeric keypad initiate
*     Kermit sends and gets, respectively, both in binary mode.
*
XPU=^[OQ
XPD=^[OR
K/=^[OP
K*=^[OS
K7=^[Ow
K8=^[Ox
K9=^[Oy
K-=^[Om
K4=^[Ot
K5=^[Ou
K6=^[Ov
K+=^[Ol
K1=^[Oq
K2=^[Or
K3=^[Os
KE=^[OM
K0=^[Op
K.=^[On
XU=^[[A
XL=^[[D
XR=^[[C
XD=^[[B
CK9=@S@/db/
CK3=@R@/db/
CBS=^H
BS=
