/*	READS IN THE PRINTCAP FILE AND SETS VARIABLES IN PCROFF */

#include <stdio.h>
#include <b:printcap.h>

#define	ESC	'\033'
#define	DQUOTE	'\042'
#define	BSLASH	'\134'

#define	INIT	1
#define	CKNAME	2

int	lineno = 1;
int	o_dev;
int	c;		/* LAST CHARACTER READ */
char	workword[80], printer[4];
FILE	*Pcapfile;

/*
 *	READ THE "PRINTCAP" FILE, AND SET UP PARAMETERS
 */
printcap ()
{
	int j;
	if (NULL ==(Pcapfile = fopen("PRINTCAP","r"))) {
		if (printer[0]=='\0') {
		    fprintf(stderr,"PCroff: no default in PRINTCAP file\n");
		    fprintf(stderr,"   Using -t style printer control\n");
		    o_dev=2;
		    return (0);
		}
		fprintf(stderr,"PCroff: cannot open PRINTCAP file\n");
		exit(1);
	}
	if (printer[0]=='\0') 	/* NEED DEFAULT PRINTER */
		if (!get_default()) return;
	for (j=0;j<3;j++)  printer[j] = tolower(printer[j]);	/* CONVERT
				   PRINTER NAME TO LOWER CASE FOR SEARCH */
	fprintf(stderr,"PCroff: using printer spec for  %s \n",printer);
	while (!nextprint()) {}	/* CONTINUE READING PRINTER SPECS
				   UNTIL FOUND OR NO MORE */
}

/*
 *	IF THE NEXT PRINTER SPEC IS A "DEFAULT" STATEMENT,
 *	PUT THE NAME IN "PRINTER". OTHERWISE SET UP TO USE -t PRINTER
 */
int
get_default ()
{
	int i;
	getword(workword);
	if (strcmp (workword,"default")) {
		fprintf(stderr,"PCroff: no default in PRINTCAP file\n");
		fprintf(stderr,"   Using -t style printer control\n");
		o_dev=2;
		return (0);
	}
	getuntil('=');
	getword(workword);
	strncpy(printer,workword,3);
	if (skipspace()) errout("unexpected end of PRINTCAP file.");
	if (getc(Pcapfile) != '.') errout("default spec missing period.");
}

/*
 *	READ THE NEXT PRINTER SPEC.  IF A DEFAULT STATEMENT, CHUCK IT.
 *	IF IT'S FOR THE SPECIFIED PRINTER, EXECUTE IT AND RETURN 1.
 *	OTHERWISE CHUCK IT AND RETURN 0;
 */
int
nextprint()
{
	/*	THIS WORKS ON A STATE-MACHINE BASIS.  SEE THE #DEFINES
	 *	FOR THE STATE DEFINITIONS.
	 */
	int state,retflag;
	char pname[3];		/* CURRENT PRINTER NAME */
	retflag=0;
	state=INIT;
	if (skipspace()) errout("can't find spec for correct printer.");

	for (;;) {	/* MAIN LOOP OF STATE MACHINE */
		if(skipspace()) errout("unexpected end of PRINTCAP file.");
		switch (state) {
		case INIT:
			getword(workword);
			if (!strcmp (workword,"default")) {
				getuntil('=');
				getword (workword);
				getuntil('.');
				return(0);
			}
			if (!strncmp (workword,printer,3))	/* MATCH */
				retflag=1;
			state=CKNAME;
			break;
		case CKNAME:
			switch (c=getc(Pcapfile)) {
			case '.':	/* END OF THIS SPEC */
				return (retflag);
				break;
			case '|':	/* ANOTHER NAME */
				state=INIT;
				break;
			case ',':
			case ':':
			case ';':	/* DO A PARAMETER */
				getparm(retflag);
				break;
			default:
				errout("illegal separator in PRINTCAP file");
			}
			break;
		}
	}
	return retflag;
}

/*
 *	GET THE NEXT WORD, IF ANY, AND CONVERT TO LOWER CASE
 */
getword (word)
char *word;
{
	if (skipspace()) errout("premature end of PRINTCAP file");
	for (;;) {
		c = getc(Pcapfile);
		if (c==EOF) errout("premature end of PRINTCAP file");
		if (!isalnum(c)) break;
		/* SUCK ALPHANUMERICS INTO *word, CONVERTING TO LOWER */
		*word++ = tolower (c);
	}
	ungetc(c,Pcapfile);
	*word = '\0';
}

/*
 *	READ IN THE NEXT PARAMETER SPECIFICATION, AND EXECUTE IT
 *	IF FLAG NOT ZERO.
 */
getparm(flag)
int flag;
{
	struct fontstring parmval;
	getword (workword);
	getuntil('=');
	getseq(&parmval);
	if (!flag) return;
	if (!strcmp (workword,"us")) copyfont(&parmval,&s_ul);
	if (!strcmp (workword,"ue")) copyfont(&parmval,&e_ul);
	if (!strcmp (workword,"bs")) copyfont(&parmval,&s_bo);
	if (!strcmp (workword,"be")) copyfont(&parmval,&e_bo);
	if (!strcmp (workword,"is")) copyfont(&parmval,&s_it);
	if (!strcmp (workword,"ie")) copyfont(&parmval,&e_it);
}

/*
 *	COPY A FONTSTRING SPECIFICATION FROM ONE STRUCT TO ANOTHER
 */
copyfont (from,to)
struct fontstring *from,*to;
{
	int i;
	to->len=from->len;
	for (i=0; i<from->len; i++)
		to->seq[i] = from->seq[i];
}

/*
 *	READ FROM PRINTCAP A SEQUENCE SURROUNDED BY DOUBLE QUOTES
 */
getseq (cseq)
struct fontstring *cseq;
{
	int octnum, i;
	char *ss;
	ss = cseq->seq;
	cseq->len=0;
	if (skipspace()) errout("unexpected end of PRINTCAP file");
	if ((c=getc(Pcapfile))!=DQUOTE) errout("double quote expected");
	for (;;) {
		c = getc(Pcapfile);
		if (c==EOF) errout("premature end of PRINTCAP file");
		if (c==DQUOTE) break;	/* FOUND END OF WORD */
		if (c==BSLASH) {	/* READ OCTAL CHARACTER */
			octnum=0;
			for (i=0; i<3; i++) {
				c=getc(Pcapfile);
				if (c>='0' && c<='7')
					octnum = 8*octnum + c - '0';
				else
				  errout("error in reading octal number");
			}
			c = octnum;
		}
		*ss++ = c;	/* STORE THE CHARACTER IN CSEQ */
		cseq->len++;
	}
}

/*
 *	FIND NEXT NON-BLANK IN PRINTCAP FILE, BUT DON'T READ.
 *	IF EOF, RETURN 1, OTHERWISE RETURN 0.
 */
int
skipspace()
{
	for (;;) {
		switch (c=getc(Pcapfile)) {
		case EOF:
		case 26:	/* decimal for ^Z */
			return (1);
			break;
		case ' ':
		case '\t':
		case 13:	/* decimal for CR */
			break;
		case '\n':
		case 10:	/* decimal for LF */
			lineno++;
			break;
		default:
			ungetc(c,Pcapfile);
			return (0);
		}
	}
}

/*
 *	FIND NEXT OCCURRENCE OF CC IN PRINTCAP FILE.
 */
getuntil(cc)
char cc;
{
	while (cc != (c=getc(Pcapfile))) {
		if (c=='\n')  lineno++;
		if (c==EOF)  errout("unexpected end of PRINTCAP file");
	}
}

/*
 *	PRINT AN ERROR MESSAGE AND EXIT TO DOS
 */
errout(msg)
char *msg;
{
	fprintf(stderr,"PCroff: %s\n",msg);
	fprintf(stderr,"        Line %d in PRINTCAP file.\n",lineno);
	exit(1);
}
