TITLE  'Draw Dot EGA - VIDEO SYSTEMS p.145'
NAME   DRAWDOT
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      set pixel                                              |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call DRAWDOT(0,7,320,175)                              |
;    stack:     +06 = y-coordinate                                      |
;                08 = x-coordinate                                      |
;                10 = pixel value                                       |
;                12 = replacement type                                  |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 4
ARGaddtype      EQU [bp+12]
ARGpixelvalue   EQU [bp+10]
ARGx            EQU [bp+08]
ARGy            EQU [bp+06]

include EXTRNDAT.INC

EXTRN PixelAddr:far

dgroup          group _BSS,_DATA

DrawDot_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:DrawDot_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawDot
DrawDot         PROC    FAR

                push    bp
                mov     bp,sp
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     di,[bx]
                mov     bx,ARGpixelvalue
                mov     si,[bx]
                mov     bx,ARGy
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGx
                mov     bx,[bx]
                mov     x0,bx           ;update step point
                mov     cx,bpl


                ;establish addressing

                call    PixelAddr       ;es:bx -> x,y in video buffer
                                        ;ah = bit mask
                                        ;cl = number bits to shift left

                ;set graphics controller bit mask reg

                shl     ah,cl           ;ah = bit mask in proper position
                mov     dx,03CEh        ;graphics controller port address
                mov     al,8            ;al=bit mask reg number
                out     dx,ax

                ;set graphics controller mode reg

                mov     ax,0205h        ;al = mode reg number
                                        ;ah = write mode 2 (bits 0,1)
                                        ;     read mode 0 (bit 3)
                out     dx,ax

                ;set data rotate\function select reg

                mov     ax,di
                xchg    ah,al           ;ah = replace type
                mov     al,3            ;al = data rotate\function select reg
                out     dx,ax

                ;set the pixel value

                mov     al,es:[bx]      ;latch one byte from each pixel plane
                mov     ax,si           ;al = pixel value
                mov     es:[bx],al      ;update all bit planes

                ;restore Graphics Controller and Sequencer to default states

                mov     ax,0FF08h       ;default Bit Mask value
                out     dx,ax

                mov     ax,0005         ;default Mode value
                out     dx,ax

                mov     ax,0003         ;default Data Rotate/Function Select
                out     dx,ax

                pop     di
                pop     si
                mov     sp,bp
                pop     bp
                RET     PARMS*2

DrawDot         ENDP
DrawDot_TEXT    ENDS
                END

