TITLE  'Set Screen Buffer Size EGA - VIDEO SYSTEMS p.393'
NAME   SCRNBUFF
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Set the screen buffer for EGA/VGA (grapics or text)    |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call SETSCNBUFF(640,350)                               |
;    stack:     +06 = y1  vertical size in pixels                       |
;                08 = x1  horizontal size in pixels                     |
;  returns:      none                                                   |
;     NOTE:      bpl is automatically updated                           |
;------------------------------------------------------------------------

PARMS           = 2
ARGx            EQU [bp+8]
ARGy            EQU [bp+6]
CRT_MODE        EQU 49h
CRT_COLS        EQU 4Ah
CRT_LEN         EQU 4Ch
ADDR_6845       EQU 63h
L_ROWS          EQU 84h
L_POINTS        EQU 85h
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

ScreenBuff_TEXT SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:ScreenBuff_TEXT,ds:dgroup,ss:dgroup

                PUBLIC SetScnBuff
SetScnBuff      PROC    FAR

                push    bp
                mov     bp, sp
                push    si
                push    di
                mov     ax,40h
                mov     es,ax

                mov     bx,ARGy
                mov     ax,[bx]
                mov     y1,ax
                dec     ax
                mov     MaxY,ax         ;max Y
                mov     bx,ARGx
                mov     ax,[bx]
                mov     x1,ax
                dec     ax
                mov     MaxX,ax         ;max X

; determine width of displayed character matrix (8 or 9)

                mov     bx,8
                cmp     byte ptr es:[CRT_MODE],7
                jne     L01
                inc     bx

; update video bios data area and bpl

L01:            mov     ax,x1
                div     bl
                mov     es:[CRT_COLS],al
                xor     ah,ah
                mov     bpl,ax
                mov     bh,al
                mov     ax,y1
                div     byte ptr es:[L_POINTS]
                dec     al
                mov     es:[L_ROWS],al

                inc     al
                mul     bh
                mov     es:[CRT_LEN],ax

; update CRTC offset reg                ;this has a permanent effect
                                        ;therefore the mouse EGA register
                mov     ah,bh           ;interface library must be informed
                shr     ah,1            ;-chh 23 Jan 91
                mov     al,13h
                mov     dx,es:[ADDR_6845]
                out     dx,ax

                pop     di
                pop     si
                pop     bp
                ret     PARMS * 2

SetScnBuff      ENDP
ScreenBuff_TEXT ENDS
                END

