TITLE  'Set/Get video mode'
NAME   SETMODE
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      set a video mode                                       |
;                check if EGA present in system                         |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call SETMODE(&H10)                                     |
;                VMODE = GETMODE()                                      |
;                EGA = EGAVIDEO()                                       |
;                VGA = VGAVIDEO()                                       |
;                Culur = COLORVIDEO()                                   |
;    stack:     +06 = video mode                                        |
;  returns:      none                                                   |
;                EGAVIDEO returns -1 if EGA active                      |
;                VGAVIDEO returns -1 if VGA active                      |
;                COLORVIDEO returns -1 if color display                 |
;-----------------------------------------------------------------------|

PARMS           = 1
ARGmode         EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

SetMode_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:SetMode_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  SetMode
SetMode         PROC    FAR

                push    bp
                mov     bp,sp
                mov     bx,ARGmode
                mov     ax,[bx]
                sub     ah,ah
                int 10h
                pop     bp
                RET     PARMS*2
SetMode         ENDP

                PUBLIC  GetMode
GetMode         PROC    FAR

                mov     ah,0Fh
                int 10h
                sub     ah,ah   ;return video mode in ax
                ret
GetMode         ENDP

                PUBLIC EGAvideo
EGAvideo        PROC FAR

                mov     bl,10h
                mov     ah,12h
                int 10h
                sub     ax,ax
                cmp     bl,10h
                je      NoEGA
                mov     es,ax           ;es-> 0 segment
                mov     bx,es:[0487h]   ;get EGA info byte
                test    bx,8            ;EGA active?
                jnz     NoEGA           ;no
                mov     ax,-1
NoEGA:          ret
EGAvideo        ENDP

                PUBLIC VGAvideo
VGAvideo        PROC FAR

                mov     ax,1A00h        ;video display combo call
                int 10h
                cmp     bl,6
                jbe     VGAcheck1
                cmp     bl,9
                jae     VGAcheck1
                mov     ax,-1
                ret
VGAcheck1:      cmp     al,01Ah
                je      VGAcheck2
                sub     ax,ax           ;no VGA
VGAxit:         ret
VGAcheck2:      sub     ax,ax           ;segment 0 and return value if no VGA
                mov     es,ax
                test    es:[0489h],byte ptr 1    ;VGA active bit
                jz      VGAcheck2xit    ;not active VGA
                mov     ax,-1           ;BIOS data says VGA is active
VGAcheck2xit:   ret

VGAvideo        ENDP

                PUBLIC COLORvideo
COLORvideo      PROC FAR

                sub     ax,ax
                mov     es,ax
                mov     bx,es:[0463h]   ;CRTC port address
                cmp     bl,0B4h         ;mono?
                je      NoColor
                mov     ax,-1
NoColor:        ret
COLORvideo      ENDP

SetMode_TEXT    ENDS
                END

