unit rnrart;

{

rnrart.pas - rnr article-reading code

}

{$I rnr-def.pas}

interface

{
uses dos,crt,rnrglob,genericf,rnrfunc,rnrio,rnrproc,rnrkill,
  rnrmous,rnrfile,rnrcrea
}

uses rnrglob,genericf,rnrfunc,rnrio,rnrproc

{$ifdef charset}
,rnrchar
{$endif};

const
  yestoscreen=true;
  notoscreen=false;

  yesfullheaders=true;
  nofullheaders=false;

var
  artfn: string;
  artf: text;
  arteof: boolean;
  startofline: boolean;
  firstblankline: integer;
  showallheaders: boolean;
  donebrowse: boolean;
  rot13ing: boolean;
  asearchstring: boolean;
  uppersearchstring: string;

procedure getartl(var s: string; maxlen: integer; toscreen: boolean);
procedure artreset;
procedure artclose;

function isheaderline: boolean;  {valid only once getartl has returned it}

procedure showartl(s: string);

procedure saveart;
procedure writeart;

implementation

var
  artlinebuf: string;
  artwaslongline: boolean;
  artlineno: integer;
  artuheader: string;
  artopen: boolean;

procedure getartl;

var
  gotaline: boolean;
  lenused: integer;
  spaceat: integer;

begin
  inc(artlineno);
  startofline := false;

{ first, check if there was something left over from last getartl() call}

  if artlinebuf<>'' then
    begin
      s := artlinebuf;

      lenused := length(s);

{ look for line-feed }

      if (pos(#10,s)<lenused) and (pos(#10,s)<>0) then
        begin
          lenused := pos(#10,s);
        end;

{ try to break at a word boundary }

      if artlineno>=firstblankline then
        if lenused>maxlen then
          begin
            spaceat := maxlen;
            while spaceat>0 do
              begin
                if s[spaceat]=' ' then
                  begin
                    lenused := spaceat;  {keep space on this line}
                    spaceat := 0;  {end the loop}
                  end;
                dec(spaceat);
              end;
          end;

      if lenused>maxlen then
        lenused := maxlen;

      s := copy(artlinebuf,1,lenused);

      if maxlen=255 then
        artlinebuf := ''
      else
        artlinebuf := copy(artlinebuf,length(s)+1,255);

{ looks redundant with case below just like this, but isn't.  really.}

      if artlinebuf='' then
        arteof := eof(artf);

    end
  else if eof(artf) then
    begin
      arteof := true;
      s := '(internal error)'
    end
  else
    begin
      gotaline := false;
      while not gotaline and not arteof do
        begin

          startofline := not artwaslongline;
          artwaslongline := false;

          read(artf,s);

          if eoln(artf) then
            readln(artf)  {discard end of line}
          else
            artwaslongline := true;

          if s='' then
            if firstblankline>artlineno then
              firstblankline := artlineno;

          gotaline := true;

{$ifdef problemswithlf}
{}{}{}{}{} writeln('gotaline=true, s=',copy(s,1,10),'..., len=',length(s));
{$endif}

{ don't use isheaderline here.  if last header is hidden, first pass }
{ will set firstblankline to a small number, which will then cause }
{ artlineno=firstblankline before the first blank line is actually seen }

{$ifdef problemswithlf}
{}{}{}{}{} if artlineno>firstblankline then writeln('uhoh lineno');
{}{}{}{}{} if not startofline then writeln('uhoh startofline');
{}{}{}{}{} if s='' then writeln('uhoh empty');
{}{}{}{}{} if s<>'' then if (s[1]=' ') or (s[1]=tab) then writeln('uhoh ws');

{ it's `startofline' not being set -- weirdness.  gotta move to a buffer }

{$endif}

          if (artlineno<=firstblankline) then
            if startofline then
              if (s<>'') then
                if (s[1]<>' ') and (s[1]<>tab) then
                  artuheader := upper(getfirstw(s));

{$ifdef problemswithlf}
{}{}{}{}{} writeln('artuheader=>',artuheader,'<');
{$endif}

          if (artlineno<=firstblankline) and not showallheaders and
           toscreen and (s<>'') then
            if hideheaders<>'' then
              begin
                if isheaderinlist(artuheader,hideheaders) then
                  gotaline := false;
              end
            else if showheaders<>'' then
              if pos(':'+artuheader,showheaders)=0 then
                gotaline := false;

{$ifdef problemswithlf}
{}{}{}{}{} if not gotaline then
{}{}{}{}{} begin
{}{}{}{}{} writeln('now gotaline=false!');
{}{}{}{}{} if hideheaders<>'' then if isheaderinlist(artuheader,hideheaders)
{}{}{}{}{} then writeln('because of hideheaders');
{}{}{}{}{} if showheaders<>'' then if pos(':'+artuheader,showheaders)=0
{}{}{}{}{} then writeln('because of showheaders');
{}{}{}{}{} end;
{$endif}

{will trim() break _anything_?  like, while reading in headers?  mail? etc.}

{using trim() is _not_ evil on headers - is it ever a problem?  what about}
{expanding tabs?  except for Makefiles and map entries...}

{trim() messes up signatures, which are added after getartl is used}

{trim() messes up old-style uuencoded postings!  taken out!}

{taken out trim() and expand() when not showing on screen (ie saving to disk) }

{}{}{} {unfortunately, this doesn't work when replying to long lines that}
{}{}{} {begin with a tab - the line overflows in the editor.  needs work}

          if gotaline then
            begin
              if toscreen then
                s := trim(expand(s));

                lenused := length(s);

{ look for linefeeds }
                if (pos(#10,s)<lenused) and (pos(#10,s)<>0) then
                  begin
                    lenused := pos(#10,s);
                  end;

{ try to break at a word boundary }

                if artlineno>=firstblankline then
                  if lenused>maxlen then
                    begin
                      spaceat := maxlen;
                      while spaceat>0 do
                        begin
                          if s[spaceat]=' ' then
                            begin
                              lenused := spaceat;  {keep space on this line}
                              spaceat := 0;  {end the loop}
                            end;
                          dec(spaceat);
                        end;
                    end;

                if lenused>maxlen then
                  lenused := maxlen;

{time-saver, probably, to skip over the copy/copy when possible}
              if length(s)>lenused then
                begin
                  artlinebuf := copy(s,lenused+1,255);
                  s := copy(s,1,lenused);
                end;
            end;

{ in case of malformed articles - prevent infinite loop }

          if artlinebuf='' then
            arteof := eof(artf);

        end;

      if not gotaline then
        s := '(malformed article)';

    end;

  if toscreen then
    s := nonastychar(s);

  if s<>'' then
    if s[length(s)]=#10 then
      s[length(s)] := ' ';
end;

procedure artresetattempt;

{ don't bother with filemode here - tpascal doesn't use it on text files }

begin

{
sometimes reset() takes a _long_ time, e.g., over a LAN with 4000 files
in one directory
}

  if dotsonreset then
    begin
      xgotoxy(1,1);
      xwrites('...');
    end;

{
could use safereset here, but don't, since we don't want to do a
new assign each time
}

{$I-}
  reset(artf);
{$I+}

  if dotsonreset then
    begin
      xgotoxy(1,1);
      xwrites('   ');
      xgotoxy(1,1);
    end;

  if ioresult=0 then
    begin
      arteof := eof(artf);
      artlinebuf := '';
      artwaslongline := false;
      artlineno := 0;
      artuheader := '';
      artopen := true;
    end;
end;

procedure artreset;

var
  givenup: boolean;
  yn: char;

begin
  givenup := false;
  artopen := false;

  while not artopen and not givenup do
    begin
      artresetattempt;
      if not artopen then
        begin
          yn := onekeydef('unable to open '+right(artfn,40)+
           ' -- try again?  <y>/<n>','yn','y');
          if yn='n' then
            givenup := true;
        end;
    end;

  if not artopen then
    begin
      donebrowse := true;
      arteof := true;
    end;
end;

procedure artclose;

begin
  if artopen then
    close(artf);
  artopen := false;
end;

function isheaderline;  {valid only once getartl has returned it}

begin
  isheaderline := artlineno<firstblankline;
end;

procedure showartl;

var
  changeds: string;
  i: integer;

begin
  changeds := s;
  if hideformfeeds then
    for i := 1 to length(changeds) do
      if changeds[i]=^L then
        changeds[i] := ' ';

  if isheaderline then
    begin
      if isheaderinlist(artuheader,highlightheaders) then
        begin
          if startofline then
            xwritess(chopfirstw(changeds),' ');
          xhighvideo;
          xwritelns(screenline(changeds));
          xlowvideo;
        end
      else
        xwritelns(screenline(changeds));
    end
  else if rot13ing then
    xwritelns(rot13(screenline(changeds)))
  else
    begin
{$ifdef charset}
      if (uselocalcharset) then
        linetolocal(changeds);
{$endif}
      if not asearchstring then
        xwritelns(screenline(changeds))
      else if pos(uppersearchstring,upper(changeds))=0 then
        xwritelns(screenline(changeds))
      else

{}{} {highlight just the word?}

        begin xhighvideo;xwritelns(screenline(changeds));xlowvideo;end;
    end;
end;

procedure savewriteart(fullheaders: boolean);

var
  outfilen: string;
  outfile: text;
  outfileisopen: boolean;
  illegal: boolean;
  doit: boolean;
  appending: boolean;
  s: string;
  appendoverwriteforgetit: char;

{$ifdef charset}
  yn: char;
  foundblank: boolean;
  saveusinglocal: boolean;
{$endif}

{for non-trusted users, make sure no : or \ in unslash(filename)}
{and try to make sure it's not a device driver (con, aux, lpt1, etc.)}
{then force it in the user's home directory}

begin
  xclreolxy(1,lpp);
  xwrites('file name (blank to abort): ');
  outfilen := lastfilen;
  xreadlns(outfilen,cols-30,yespreserve);

  outfilen := ltrim(trim(outfilen));

  if outfilen<>'' then
    lastfilen := outfilen;

  if tildehome then
    if copy(outfilen,1,2)='~/' then
      outfilen := home+copy(outfilen,2,255);

  outfilen := unslash(outfilen);

  doit := (outfilen<>'');
  illegal := illegalfn(outfilen);

  if doit and not trusted then
    begin
      illegal := illegal or suspiciousfn(outfilen);
    end;

  if doit and illegal then
    begin
      warn('unable to use that filename');
    end;

  if doit and not illegal then
    begin
      if not trusted then
        outfilen := home+'\'+outfilen;

      appendoverwriteforgetit := 'o';

      if fexists(outfilen) then
        begin
          xclreolxy(1,lpp);
          appendoverwriteforgetit :=
           onekeydef('<O>verwrite <a>ppend <f>orget it','Oaf','f');
        end;

      if appendoverwriteforgetit<>'f' then
        begin

{$ifdef charset}
          saveusinglocal := false;
          if uselocalcharset then
            begin
              yn := onekey('Use local charset <y>/<n>','yn');
              saveusinglocal := (yn = 'y');
            end;
{$endif}

          xclreolxy(1,lpp);

          appending := (appendoverwriteforgetit='a');

          if appending then
            xwritesss('appending to ',outfilen,' ...')
          else
            xwritesss('writing to ',outfilen,' ...');

          assign(outfile,outfilen);

          outfileisopen := false;

          if appending then
            begin
{$I-}
              append(outfile);
{$I+}
              if ioresult<>0 then
                begin
                  warn('could not append to '+outfilen);
                end
              else
                begin
                  outfileisopen := true;
                  writeln(outfile);
                  writeln(outfile,outputseparator);
                  writeln(outfile);
                end;
            end
          else
            begin
{$I-}
              rewrite(outfile);
{$I+}
              if ioresult<>0 then
                begin
                  warn('could not write to '+outfilen);
                end
              else
                begin
                  outfileisopen := true;
                end;
            end;

    {need to check fullheaders here!}

          artreset;

{$ifdef charset}
          foundblank:= false;
{$endif}

          if outfileisopen then
            begin
              while not arteof do
                begin
                  getartl(s,255,false);
{$ifdef charset}
                  if foundblank and saveusinglocal then
                    linetolocal(s)
                  else
                    if s='' then
                      foundblank := true;
{$endif}
                  writeln(outfile,s);
                end;
              close(outfile);
            end;

          xclreolxy(1,lpp);
          xwrites('done.');
        end;
    end;
end;

procedure writeart;

begin
  savewriteart(nofullheaders);
end;

procedure saveart;

begin
  savewriteart(yesfullheaders);
end;

end.
