unit rnrcrea;  {formerly from rnrselb}

{$I rnr-def.pas}


interface

uses crt,rnrglob,genericf,rnrfunc,rnrproc,rnrio,rnrfile,
 rnrmous,rnrart

{$ifdef charset}
,rnrchar
{$endif}
 
;

procedure delivermail(mailfn: string);
procedure sendnewsasmail(infn: string; addr: string);
procedure injnews(newartfn: string; newsgroups, originalnewsgroups: string);

procedure createpostorcancel(iscancel: boolean;
 newsgroups, originalnewsgroups, followupto, subject,
 references, author, originalauthor: string);
procedure createcancel(newsgroups, subject, references,
 originalauthor: string);
procedure createpost(newsgroups, originalnewsgroups, followupto, subject,
 references, author, originalauthor: string);

procedure editanddeliver(subject,inreplyto,replyaddr,replyname,ccaddr,
 originalfrom,author: string; defaultreply: boolean);
procedure editandinjnews(newsgroups, originalnewsgroups, author: string);

procedure post;
procedure mail;

implementation

procedure delivermail;

var
  toaddr: string;
  ccaddr: string;
  mailf: text;
  maillffn: string;
  maillff: text;
  cclffn: string;
  cclff: text;
  rereadblankfound: boolean;
  s: string;
  outmailfn: string;
  outmailf: text;
  ccoutmailfn: string;
  ccoutmailf: text;
  basesite: string;
  ccbasesite: string;
  lineno: integer;
  doserr: integer;
  seqstr: string;
  ccseqstr: string;
  builtin: boolean;
  addrlist: string;
  outgoingmaildir: string;
  outgoingmailfn: string;

begin
  toaddr := getheaderline(mailfn,'to:');
  ccaddr := getheaderline(mailfn,'cc:');

  toaddr := getfromaddr(toaddr);
  if ccaddr<>'' then
    ccaddr := getfromaddr(ccaddr);

{now toaddr and ccaddr have no comments}

  builtin := mailcmdline='(builtin)';
  addrlist := toaddr;
  if ccaddr<>'' then
    addrlist := addrlist+' '+ccaddr;

  if builtin then
    begin
      seqstr := integertozstring(newseqnumber,4);
      maillffn := smarthostdir+'\'+seqstr+'.dat';

      if ccaddr='' then
        begin
          cclffn := '';
        end
      else
        begin
          ccseqstr := integertozstring(newseqnumber,4);
          cclffn := smarthostdir+'\'+ccseqstr+'.dat';
        end;

      { here copy mailf to maillff, cclff - strip carriage returns }

      assign(maillff,maillffn);
      rewrite(maillff);

      if ccaddr<>'' then
        begin
          assign(cclff,cclffn);
          rewrite(cclff);
        end;
    end
  else
    begin
      maillffn := temporarydir+'\'+userid+'.nl';
      assign(maillff,maillffn);
      rewrite(maillff);
    end;

  basesite := copy(basesitename(toaddr),1,8);
  outmailfn := outboxdir+'\'+basesite;

  if ccaddr<>'' then
    begin
      ccbasesite := copy(basesitename(ccaddr),1,8);
      ccoutmailfn := outboxdir+'\'+ccbasesite;
    end;

{getuniqfext makes sure it's not a device}

{}{}{}{} {getuniqfile doesn't quite!}

  if outform='flat' then
    outmailfn := getuniqfext(outmailfn)
  else
    begin
      mkhier(outmailfn);
      outmailfn := getuniqfile(outmailfn);
    end;

  assign(outmailf,outmailfn);
  rewrite(outmailf);

{ must create outmailf _before_ ccoutmailfn is chosen, in case of }
{ a conflict!  (e.g., mailing foo@baz.com and bar@baz.com}

  if ccaddr<>'' then
    begin
      if outform='flat' then
        ccoutmailfn := getuniqfext(ccoutmailfn)
      else
        begin
          mkhier(ccoutmailfn);
          ccoutmailfn := getuniqfile(ccoutmailfn);
        end;

      assign(ccoutmailf,ccoutmailfn);
      rewrite(ccoutmailf);
    end;

{$ifdef charset}

{ Must do this _before_ opening mailfile with reset(), or it will fail }
{ for the poor users who have share loaded                             }

  if uselocalcharset then
    setsendencoding(
     getheaderline(mailfn,'content-type:'),
     getheaderline(mailfn,'content-transfer-encoding:'));
{$endif}
  
  assign(mailf,mailfn);
  reset(mailf);

  rereadblankfound := false;
  lineno := 1;
  while not eof(mailf) do
    begin
      readln(mailf,s);

      if s='' then
        rereadblankfound := true;

{$ifdef charset}
      if uselocalcharset then
        if rereadblankfound then
          localtoline(s);
{$endif}

      write(maillff,s,#10);
      if (ccaddr<>'') and builtin then
        write(cclff,s,#10);

{$ifdef waffleonly}
      if lineno=1 then
        begin
          writeln(outmailf,
           copy(s,1,length(s)-length(' remote from '+uucpname)));
          if ccaddr<>'' then
            writeln(ccoutmailf,
             copy(s,1,length(s)-length(' remote from '+uucpname)));
        end
      else { if lineno>3 then }  {lineno>3 wrong with --no-mail-from etc.}
{$endif}

        begin
          if not trusted then
            if not rereadblankfound then
              if makesame(s,'From: ',mailfrom) then
                ;
          writeln(outmailf,s);
          if ccaddr<>'' then
            writeln(ccoutmailf,s);
        end;
      inc(lineno);
    end;
  close(mailf);

  close(maillff);
  if (ccaddr<>'') and builtin then
    close(cclff);

  close(outmailf);
  if ccaddr<>'' then
    close(ccoutmailf);

  if builtin then
    begin

{once .DAT is written, create .XQT}

      maillffn := smarthostdir+'\'+seqstr+'.xqt';
      assign(maillff,maillffn);
      rewrite(maillff);
      write(maillff,'U ',userid,' ',uucpname,#10);
      write(maillff,'Z',#10);
      write(maillff,'F D.',uucpname,seqstr,#10);
      write(maillff,'I D.',uucpname,seqstr,#10);
      write(maillff,'C rmail ',toaddr,#10);
      close(maillff);

      if ccaddr<>'' then
        begin
          cclffn := smarthostdir+'\'+ccseqstr+'.xqt';
          assign(cclff,cclffn);
          rewrite(cclff);
          write(cclff,'U ',userid,' ',uucpname,#10);
          write(cclff,'Z',#10);
          write(cclff,'F D.',uucpname,ccseqstr,#10);
          write(cclff,'I D.',uucpname,ccseqstr,#10);
          write(cclff,'C rmail ',ccaddr,#10);
          close(cclff);
        end;

{once .DAT and .XQT are written, create .CMD}

      maillffn := smarthostdir+'\'+seqstr+'.cmd';
      assign(maillff,maillffn);
      rewrite(maillff);
      writeln(maillff,'S ',seqstr,'.DAT D.',uucpname,seqstr,' ',
       userid,' - ',seqstr,'.DAT 0600');
      writeln(maillff,'S ',seqstr,'.XQT X.',uucpname,seqstr,' ',
       userid,' - ',seqstr,'.XQT 0600');
      close(maillff);

      if ccaddr<>'' then
        begin
          maillffn := smarthostdir+'\'+ccseqstr+'.cmd';
          assign(maillff,maillffn);
          rewrite(maillff);
          writeln(maillff,'S ',ccseqstr,'.DAT D.',uucpname,ccseqstr,' ',
           userid,' - ',ccseqstr,'.DAT 0600');
          writeln(maillff,'S ',ccseqstr,'.XQT X.',uucpname,ccseqstr,' ',
           userid,' - ',ccseqstr,'.XQT 0600');
          close(maillff);
        end;
    end

  else

    begin

      if rmailsingle then
        begin

    if pos('%f',mailcmdline)=0 then
      execviacomspec(extwafexpand(mailcmdline,toaddr,'')+' < '+maillffn)
    else
      execviacomspec(extwafexpand(mailcmdline,toaddr,maillffn));

        end
      else
        begin

    if pos('%f',mailcmdline)=0 then
      execviacomspec(extwafexpand(mailcmdline,addrlist,'')+' < '+maillffn)
    else
      execviacomspec(extwafexpand(mailcmdline,addrlist,maillffn));

        end;

      doserr := doserrorno;
      if doserr<>0 then
        warnerr(mailcmdline,doserr);

      if (ccaddr<>'') and rmailsingle then
        begin
          if pos('%f',mailcmdline)=0 then
            execviacomspec(extwafexpand(mailcmdline,ccaddr,'')+' < '+maillffn)
          else
            execviacomspec(extwafexpand(mailcmdline,ccaddr,maillffn));

          doserr := doserrorno;
          if doserr<>0 then
            warnerr(mailcmdline,doserr);

        end;
    end;

  if outgoingmail<>'' then
    begin
      outgoingmaildir := getgroupdir(outgoingmail);
      if outgoingmaildir='' then
        warn('could not find a directory for '+outgoingmail)
      else
        begin
          mkhier(outgoingmaildir);
          outgoingmailfn := getuniqfile(outgoingmaildir);
          xclreolxy(1,lpp);
          xwritesss('Saving a copy in ',outgoingmailfn,'...');
          copyfile(mailfn,outgoingmailfn);
        end;
    end;

  {caller will refresh}

end;

procedure sendnewsasmail;

var
  inf: text;
  tempfn: string;
  tempf: text;
  s: string;
  toseen: boolean;
  blankseen: boolean;
  ccaddrfound: string;
  isccline: boolean;
  toaddr: string;
  ccaddr: string;

begin
  warn('mailing to '+copy(addr,1,50));

  toaddr := '';
  ccaddr := '';

  xwrites('mailing...');

  assign(inf,infn);
  reset(inf);

  tempfn := temporarydir+'\'+userid+'.n2m';
  assign(tempf,tempfn);
  rewrite(tempf);

  if not nomailfrom then
    writeln(tempf,'From ',userid,'  ',copy(cdow,1,3),', ',dayofmonth,' ',
     copy(monthname,1,3),' ',year,' ',time,' ',timezone,' ',
     'remote from ',uucpname);

  if not isheaderinlist('Received:',nomailheaders) then
    begin
      writeln(tempf,'Received: by ',fqdn,' ('+newsreadername+')');
      writeln(tempf,'       via ',newsreadername,'; ',copy(cdow,1,3),', ',
       dayofmonth,' ',copy(monthname,1,3),' ',year,' ',time,' ',timezone);
    end;

{ supress CC:s until very end -- if there was a To: then give up the CC: }
{ unchanged; otherwise change the CC: to a To: so there's one for uupc }

  toseen := false;
  blankseen := false;
  ccaddrfound := '';

  while not eof(inf) do
    begin
      readln(inf,s);
      isccline := false;

      if not blankseen then  {must write it before the blank line!}
        begin
          if lower(copy(ltrim(s),1,3))='to:' then
            begin
              toseen := true;
              s := ltrim(copy(ltrim(s),4,255));
              if (s='poster') or (s='sender') then
                s := addr;
              toaddr := expandmail(s);
              s := 'To: '+toaddr;
            end;
          if lower(copy(ltrim(s),1,3))='cc:' then
            begin
              ccaddrfound := ltrim(copy(ltrim(s),4,255));
              isccline := true;
            end;

          if s='' then
            blankseen := true;

          if blankseen then  {blankseen must have _just_ become true}
            if toseen then  {was a To: -- print out the CC: we suppressed}
              begin
                if ccaddrfound<>'' then
                  begin
                    if (ccaddrfound='poster') or (ccaddrfound='sender') then
                      ccaddrfound := addr;
                    ccaddrfound := expandmail(ccaddrfound);
                    ccaddr := ccaddrfound;
                    writeln(tempf,'CC: ',ccaddr);
                  end;
              end
            else
              begin
                if ccaddrfound='' then
                  ccaddrfound := addr;
                if (ccaddrfound='poster') or (ccaddrfound='sender') then
                  ccaddrfound := addr;
                ccaddrfound := expandmail(ccaddrfound);
                toaddr := ccaddrfound;
                writeln(tempf,'To: ',toaddr);
                toseen := true;
              end;
        end;

      if not isccline then
        writeln(tempf,s);
    end;

  close(inf);
  close(tempf);

  delivermail(tempfn);

end;

{}{} {should be a three-part process!}

procedure injnews;
  
var
  goingtomail: boolean;
  newartf: text;
  newartlffn: string;
  newartlff: text;
  foundblank: boolean;
  s: string;
  newnewsgroups: string;
  mungedgroups: string;
  firstnewsgroup: string;
  firstcommapos: integer;
  newfrom: string;
  newapproved: string;
  outgoinggroup: string;
  outgoingdir: string;
  outgoingfn: string;
  outgoingf: text;
  fromfound: boolean;
  doserr: integer;
  moderatoraddr: string;
  onlylf: boolean;
  i: integer;

begin
  goingtomail := false;

  safereset(newartf,newartfn);

{$ifdef charset}
  if uselocalcharset then
    setsendencoding(
     getheaderline(newartfn,'content-type:'),
     getheaderline(newartfn,'content-transfer-encoding:'));
{$endif}  

  newnewsgroups := getheaderline(newartfn,'newsgroups:');

  newfrom := getheaderline(newartfn,'from:');
  newapproved := getheaderline(newartfn,'approved:');

{copy to outgoing directory if asked -- just pick the first one found}
     
  outgoingfn := '';
  outgoinggroup := '';

{first:  try to find an outgoing group for any group it was posted to}

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := newnewsgroups+',done';

  while (outgoinggroup='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      outgoinggroup := groupsattr(firstnewsgroup,'/spy=');
    end;

{second:  try to find an outgoing group for any group before editing}

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := newsgroups+',done';

  while (outgoinggroup='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      outgoinggroup := groupsattr(firstnewsgroup,'/spy=');
    end;

{finally:  try to find an outgoing group for any group before Followup-To: }

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := originalnewsgroups+',done';

  while (outgoinggroup='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      outgoinggroup := groupsattr(firstnewsgroup,'/spy=');
    end;

  if outgoinggroup='' then
    outgoinggroup := outgoingnews;

  if outgoinggroup='' then
    begin
      if not quiet then
        warn('(there is no outgoing group copy for this post)');
    end
  else
    begin
      outgoingdir := getgroupdir(outgoinggroup);
      if outgoingdir='' then
        begin
          warn('no dir found for outgoing group '+outgoinggroup+' !');
        end
      else
        begin
          outgoingfn := getuniqfile(outgoingdir);
        end;
    end;

{check if any group on the list is moderated}

{the `done' isn't necessary, even a space would do, and probably}
{even ending the string at the `,' would do, but why take chances}
{with the string routines?}

  mungedgroups := newnewsgroups+',done';
  moderatoraddr := '';

  while (moderatoraddr='') and (numoccur(',',mungedgroups)>0) do
    begin
      firstcommapos := pos(',',mungedgroups);
      firstnewsgroup := copy(mungedgroups,1,firstcommapos-1);
      mungedgroups := copy(mungedgroups,firstcommapos+1,255);
      if ismoderated(firstnewsgroup) then
        begin
          moderatoraddr := groupsattr(firstnewsgroup,'/mod=');
          if moderatoraddr='' then
            begin
              moderatoraddr := firstnewsgroup;
              for i := 1 to length(moderatoraddr) do
                if moderatoraddr[i]='.' then
                   moderatoraddr[i] := '-';
              moderatoraddr := moderatoraddr+'@'+backbone;
            end;
        end;
    end;

{ allow only trusted users to issue Control: messages, post to alt.hackers, }
{ be group moderators, etc. }

  if trusted then
    if newapproved<>'' then
      moderatoraddr := '';

  goingtomail := (moderatoraddr<>'');

{use LF for posts, CRLF for mail}

  onlylf := not goingtomail;

  newartlffn := temporarydir+'\'+userid+'.nl';
  assign(newartlff,newartlffn);
  rewrite(newartlff);

  if outgoingfn<>'' then
    begin
      mkhier(outgoingdir);

      assign(outgoingf,outgoingfn);
{$I-}
      rewrite(outgoingf);
{$I+}

      if ioresult<>0 then
        begin
          warn('could not write to outgoing file '+outgoingfn);
          outgoingfn := '';
        end;
    end;

  foundblank := false;
  reset(newartf);
  while not eof(newartf) do
    begin
      readln(newartf,s);

{$ifdef charset}
      if (uselocalcharset) then
        if foundblank then
          localtoline(s);
{$endif}

      if not foundblank then
        if copy(s,1,6)='From: ' then
          fromfound := true;

      if s='' then
        begin
          if not foundblank then  {this must be the first blank}
            begin
              if not fromfound then
                begin
                  if onlylf then
                    write(newartlff,'From: ',newsfrom,#10)
                  else
                    writeln(newartlff,'From: ',newsfrom);
                  if outgoingfn<>'' then
                    writeln(outgoingf,'From: ',newsfrom);
                  fromfound := true;
                end;
            end;
          foundblank := true;
        end;

      if onlylf then
        write(newartlff,s,#10)
      else
        writeln(newartlff,s);

      if outgoingfn<>'' then
        writeln(outgoingf,s);
    end;
  close(newartf);
  close(newartlff);
  if outgoingfn<>'' then
    close(outgoingf);

  if goingtomail then
    begin
      sendnewsasmail(newartlffn,moderatoraddr);
    end
  else
    begin

{}{} {should use rnews in bin directory only?}

      mousehide;

      if pos('%f',newscmdline)=0 then
        execviacomspec(wafexpand(newscmdline)+' < '+newartlffn)
      else
        execviacomspec(extwafexpand(newscmdline,'',newartlffn));

      doserr := doserrorno;

      mouseshow;

{}{} {waffle's rnews sometimes displays random error message on low memory}

      delay(1000);

      if doserr<>0 then
        warnerr(newscmdline,doserr);

    end;
end;

procedure createpostorcancel;

{ if author<>'', opens then closes artf }

var
  newartfn: string;
  newartf: text;
  refline: string;
  wref: string;
  nextref: string;
  ref1,ref2: string;
  foundblank: boolean;
  sigfn: string;
  sigf: text;
  s: string;
  sendeditvspellquit: char;
  doserr: integer;
  ccaddr: string;

begin

{ don't propogate errors in the Newsgroups: line if you can help it }

  newsgroups := unspace(newsgroups);
  followupto := unspace(followupto);

  newartfn := temporarydir+'\'+userid+'.fol';
  assign(newartf,newartfn);
  rewrite(newartf);

{this done since waf164 didn't handle newsname like waf165 does}

  if not isheaderinlist('Path:',nonewsheaders) then
    writeln(newartf,'Path: ',newsname,'!',pathuserid);

  writeln(newartf,'Newsgroups: ',newsgroups);
  if (originalnewsgroups<>'') and (originalnewsgroups<>newsgroups) then
    writeln(newartf,'X-Original-Newsgroups: ',originalnewsgroups);
  if followupto<>'' then
    writeln(newartf,'Followup-To: ',followupto);
  if originalauthor<>'' then
    writeln(newartf,'X-Original-Article-From: ',originalauthor);

  if iscancel then
    begin
      if newsfrom=originalauthor then
        begin
          writeln(newartf,'From: ',newsfrom);
          writeln(newartf,'Sender: ',newsfrom);
        end
      else
        begin
          writeln(newartf,'From: ',originalauthor);
          writeln(newartf,'Sender: ',newsfrom);
        end;
    end
  else
    begin
      writeln(newartf,'From: ',newsfrom);
    end;

  if replyto<>'' then
    writeln(newartf,'Reply-To: ',replyto);

  writeln(newartf,'Subject: ',subject);

  if not isheaderinlist('Message-ID:',nonewsheaders) then
    writeln(newartf,'Message-ID: ',newmessageid);

  writeln(newartf,'Date: ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone);

  if references<>'' then
    begin

{$ifdef rnewscontbroken}
      writeln(newartf,'References: ',references);
{$else}

{ wref is the space-terminated string of references that are yet to be }
{ written out - it starts with two spaces if need be (other than line one) }

      wref := 'References: ';
      while references<>'' do
        begin
          references := ltrim(references);
          nextref := chopfirstw(references);
          if length(wref+nextref)>70 then
            begin
              writeln(newartf,wref);
              wref := '  '+nextref+' ';
            end
          else
            wref := wref+nextref+' ';
        end;
      if wref<>'' then
        writeln(newartf,trim(wref));
{$endif}

    end;

  if organ<>'' then
    writeln(newartf,'Organization: ',organ);

{$ifdef charset}
  if uselocalcharset then
    begin
      writeln(newartf,'MIME-Version: 1.0');
      writeln(newartf,'Content-Type: text/plain; charset=',mailingsetname);
      writeln(newartf,'Content-Transfer-Encoding: ',mailxfername);
    end;
{$endif}

  if iscancel then
    writeln(newartf,'Control: ','cancel ',references);

  if not isheaderinlist('X-Newsreader:',nonewsheaders) then
    writeln(newartf,'X-Newsreader: ',newsreadername,' ',newsreaderversion);

  writeln(newartf);

  if iscancel then
    writeln(newartf,'cancelled within ',newsreadername)
  else if author='' then
    writeln(newartf,'(begin your PUBLIC post at this line, but no sooner)')
  else
    begin
      writeln(newartf,author,' writes:');
      writeln(newartf);

      foundblank := false;

      artreset;
      while not arteof and not foundblank do
        begin
          getartl(s,255,notoscreen);
          if s='' then
            foundblank := true;
        end;

      while not arteof do
        begin

{don't use just cols here, to be polite}

          getartl(s,min(cols,80)-3,notoscreen);

{$ifdef charset}
          if uselocalcharset then
             linetolocal(s);
{$endif}

          if copy(s,1,1)='>' then
            writeln(newartf,'>',expand(s))
          else
            writeln(newartf,'> ',expand(s))

        end;
      artclose;
    end;

  sigfn := unslash(getconfig('signature'));
  if sigfn='' then
    sigfn := 'sig';
  if numoccur('\',sigfn)=0 then
    sigfn := home+'\'+sigfn;

  safereset(sigf,sigfn);
  if fileresult=0 then
    begin
      readln(sigf,s);
      if s<>'-- ' then
        writeln(newartf,'-- ');
      reset(sigf);
      while not eof(sigf) do
        begin
          readln(sigf,s);
          writeln(newartf,s);
        end;
      close(sigf);
    end;
  close(newartf);
end;

procedure createcancel;

begin
  createpostorcancel(true,newsgroups,'','',subject,
   references,'',originalauthor);
end;

procedure createpost;

begin
  createpostorcancel(false,newsgroups,originalnewsgroups,followupto,
   subject,references,author,originalauthor);
end;

procedure editandinjnews;
  
var
  newartfn: string;
  sendeditvspellquit: char;
  doserr: integer;
  ccaddr: string;

begin

{ don't propogate errors in the Newsgroups: line if you can help it }

  newsgroups := unspace(newsgroups);

  newartfn := temporarydir+'\'+userid+'.fol';

  sendeditvspellquit := 'e';
  while (sendeditvspellquit<>'s') and (sendeditvspellquit<>'q') do
    begin
      if not trusted then
        if sendeditvspellquit='E' then
          sendeditvspellquit := 'e';
      if sendeditvspellquit='v' then
        begin
          mousehide;
          execp(vspeller,vspelleroptions+' '+newartfn);
          mouseshow;
          doserr := doserrorno;
          if doserr<>0 then
            warnerr(vspeller,doserr);
          if editaftervspell then
            sendeditvspellquit := 'e';
        end;
      if sendeditvspellquit='e' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+newartfn);
          mouseshow;
          doserr := doserrorno;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;
      if sendeditvspellquit='E' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+newartfn+' '+artfn);
          mouseshow;
          doserr := doserrorno;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;

      xclreolxy(1,lpp-1);
      if author='' then
        sendeditvspellquit :=
         onekey('Public: <s>end <e>dit <v>spell <q>uit','sevq')
      else
        sendeditvspellquit :=
         onekey('Public: <s>end <e>dit <E>dit-both <v>spell <q>uit','seEvq');

      if sendeditvspellquit='s' then
        xwrites('sending...')
      else if sendeditvspellquit='e' then
        xwrites('editing...')
      else if sendeditvspellquit='E' then
        xwrites('editing both...')
      else if sendeditvspellquit='v' then
        xwrites('vspelling...')
      else if sendeditvspellquit='q' then
        xwrites('quit');

    end;

  if sendeditvspellquit='s' then
    begin

{}{} {check headers}
     {invalid format of Newsgroups: line (spaces, etc.)}
     {warn if any groups in Newsgroups: not in forum set}
     {delete any duplicates from Newsgroups: line}
     {check From:}
     {check for moderated groups}
     {check for /solo groups}
     {a Lines: header might be polite.  maybe not}
     {would be nice to check for content-free messages sent by mistake}

      headerinmem:= '';  { In case user edited headers ... }

      injnews(newartfn,newsgroups,originalnewsgroups);
      ccaddr := getheaderline(newartfn,'cc:');

      if ccaddr<>'' then
        begin
          if (ccaddr='poster') or (ccaddr='sender') then
            ccaddr := author;

          sendnewsasmail(newartfn,ccaddr);
        end;

    end;

{leave refresh and artf re-opening to the caller}

end;

procedure post;

var
  nsubject: string;
  ngroups: string;
  postforgetit: char;

begin
  ngroups := internalcmdlineparams;

  if ngroups<>'' then
    if getgroupdir(ngroups)='' then
      if joinedtogroup(ngroups) then
        ;

  if ngroups='' then
    ngroups := currgroup;

  if not (trusted and maypost) then
    warn('you do not have access to post this way')
  else
    begin
      if ismoderated(ngroups) then
        warn(ngroups+' group is moderated');

      postforgetit := 'p';
      if ismailgroup(ngroups) then
        begin
          ngroups := 'misc.misc';
          postforgetit :=
           onekeydef('this is a mail group - <p>ost <f>orget it','pf','f');
        end;

      if postforgetit='p' then
        begin
          xclreolxy(1,lpp);
          xwrites('Subject: ');
          xreadlns(nsubject,max(cols-10,70),nopreserve);
          xclreolxy(1,lpp);
          xwrites('Newsgroups: ');
          xreadlns(ngroups,max(cols-15,70),yespreserve);

          if ngroups='' then
            ngroups := 'misc.misc';

          if getgroupdir(ngroups)='' then
            if joinedtogroup(ngroups) then
              ;

          createpost(ngroups,'','',nsubject,'','','');
          editandinjnews(ngroups,'','');
        end;
    end;

{ caller must refresh }

end;

procedure editanddeliver;

{ expects artf to be closed;  will open and close if author<>'' }

var
  groupormail: string;
  mailfn: string;
  mailf: text;
  mailcheckedfn: string;
  mailcheckedf: text;
  rereadblankfound: boolean;
  fromfound: boolean;
  sigfn: string;
  sigf: text;
  foundblank: boolean;
  s: string;
  sendeditvspellquit: char;
  outmailfn: string;
  outmailf: text;
  basesite: string;
  lineno: integer;
  doserr: integer;

begin
  if ismailgroup(currgroup) then
    groupormail := 'mail'
  else
    groupormail := currgroup;

  mailfn := temporarydir+'\'+userid+'.mai';
  assign(mailf,mailfn);
  rewrite(mailf);

  if not nomailfrom then
    writeln(mailf,'From ',userid,'  ',copy(cdow,1,3),', ',dayofmonth,' ',
     copy(monthname,1,3),' ',year,' ',time,' ',timezone,' ',
     'remote from ',uucpname);

  if not isheaderinlist('Received:',nomailheaders) then
    begin
      writeln(mailf,'Received: by ',fqdn,' ('+newsreadername+')');
      writeln(mailf,'       via ',newsreadername,'; ',copy(cdow,1,3),', ',
       dayofmonth,' ',copy(monthname,1,3),' ',year,' ',time,' ',timezone);
    end;

{ don't bother with this line anymore -- makes future expansion easier }

{
  writeln(mailf,'       for ',replyaddr);
}

  write(mailf,'To: ',replyaddr);
  if replyname='' then
    writeln(mailf)
  else
    writeln(mailf,' (',replyname,')');

  if ccaddr<>'' then
    writeln(mailf,'CC: ',ccaddr);

  if originalfrom<>'' then
    writeln(mailf,'X-Original-Article-From: ',originalfrom);

  writeln(mailf,'Subject: ',subject);
  writeln(mailf,'From: ',mailfrom);

  if replyto<>'' then
    writeln(mailf,'Reply-To: ',replyto);

  if not isheaderinlist('Message-ID:',nomailheaders) then
    writeln(mailf,'Message-ID: ',newmessageid);

  writeln(mailf,'Date: ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone);

{$ifdef charset}
  if uselocalcharset then
    begin
      writeln(mailf,'MIME-Version: 1.0');
      writeln(mailf,'Content-Type: text/plain; charset=',postingsetname);
      writeln(mailf,'Content-Transfer-Encoding: 8bit');
    end;
{$endif}

  if inreplyto<>'' then
    writeln(mailf,'In-Reply-To: ',inreplyto);

  if organ<>'' then
    writeln(mailf,'Organization: ',organ);

  if not isheaderinlist('X-Newsreader:',nomailheaders) then
    writeln(mailf,'X-Newsreader: ',newsreadername,' ',newsreaderversion);

  writeln(mailf);

  if author='' then
    writeln(mailf,'(begin your PRIVATE mail at this line, but no sooner)')
  else
    begin
      if defaultreply and (ccaddr='') then
        writeln(mailf,'In ',groupormail,' you write:')
      else
        if length(groupormail)+length(author)<60 then
          writeln(mailf,'In ',groupormail,', ',author,' writes:')
        else
          writeln(mailf,'In ',groupormail,', ',
           copy(author,1,max(60-length(groupormail),20)),'... writes:');
      writeln(mailf);

      foundblank := false;

      artreset;
      while not arteof and not foundblank do
        begin
          getartl(s,255,notoscreen);
          if s='' then
            foundblank := true;
        end;

      while not arteof do
        begin

{don't use just cols here, to be polite}

          getartl(s,min(cols,80)-3,notoscreen);

{$ifdef charset}
          if (uselocalcharset) then
            linetolocal(s);
{$endif}

          if copy(s,1,1)='>' then
            writeln(mailf,'>',expand(s))
          else
            writeln(mailf,'> ',expand(s))
        end;
      artclose;
    end;

  sigfn := unslash(getconfig('signature'));
  if sigfn='' then
    sigfn := 'mailsig';
  if numoccur('\',sigfn)=0 then
    sigfn := home+'\'+sigfn;

  safereset(sigf,sigfn);
  if fileresult<>0 then
    begin
      sigfn := home+'\'+'sig';
      safereset(sigf,sigfn);
    end;
  if fileresult=0 then
    begin
      readln(sigf,s);
      if s<>'-- ' then
        writeln(mailf,'-- ');
      reset(sigf);
      while not eof(sigf) do
        begin
          readln(sigf,s);
          writeln(mailf,expand(s));
        end;
      close(sigf);
    end;
  close(mailf);

  sendeditvspellquit := 'e';
  while (sendeditvspellquit<>'s') and (sendeditvspellquit<>'q') do
    begin
      if not trusted then
        if sendeditvspellquit='E' then
          sendeditvspellquit := 'e';
      if sendeditvspellquit='v' then
        begin
          mousehide;
          execp(vspeller,vspelleroptions+' '+mailfn);
          mouseshow;
          doserr := doserrorno;
          if doserr<>0 then
            warnerr(vspeller,doserr);
          if editaftervspell then
            sendeditvspellquit := 'e';
        end;
      if sendeditvspellquit='e' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+mailfn);
          mouseshow;
          doserr := doserrorno;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;
      if sendeditvspellquit='E' then
        begin
          mousehide;
          execp(editor,editoroptions+' '+mailfn+' '+artfn);
          mouseshow;
          doserr := doserrorno;
          if doserr<>0 then
            warnerr(editor,doserr);
        end;

      xclreolxy(1,lpp-1);
      sendeditvspellquit :=
       onekey('Private: <s>end <e>dit <E>dit-both <v>spell <q>uit','seEvq');

      if sendeditvspellquit='s' then
        xwrites('sending...')
      else if sendeditvspellquit='e' then
        xwrites('editing...')
      else if sendeditvspellquit='E' then
        xwrites('editing both...')
      else if sendeditvspellquit='v' then
        xwrites('vspelling...')
      else if sendeditvspellquit='q' then
        xwrites('quit');

    end;

  if sendeditvspellquit='s' then
    begin

      mailcheckedfn := temporarydir+'\'+userid+'.chk';

      { here copy mailf to mailcheckedf }

      assign(mailcheckedf,mailcheckedfn);
      rewrite(mailcheckedf);

      assign(mailf,mailfn);
      reset(mailf);

{check for changed From: lines on non-trusted users and replace}

{must make sure a From: line is actually found!}

      rereadblankfound := false;
      fromfound := false;
      while not eof(mailf) do
        begin
          readln(mailf,s);
          if not trusted then
            begin
              if s='' then
                begin
                  rereadblankfound := true;
                  if not fromfound then
                    begin
                      fromfound := true;
                      writeln(mailcheckedf,'From: ',mailfrom);
                    end;
                end
              else if not rereadblankfound then
                begin
                  if getfirstw(s)='From:' then
                    fromfound := true;
                  if makesame(s,'From: ',mailfrom) then
                    begin
                      warn3
                       (
                       'From: line was changed back to '+mailfrom,
                       '(the default).  the -t flag is required to change the',
                       'From: line.  adding a Reply-To: is probably better.'
                       );
{
                      xclreolxy(1,1);
                      xclreolxy(1,2);
                      xclreolxy(1,3);
                      xclreolxy(1,4);
                      xclreolxy(1,5);
                      xclreolxy(1,6);
                      xclreolxy(1,7);
                      writexy(1,1,'From: line was changed from');
                      writexy(1,2,s+' to');
                      writexy(1,3,mailfrom);
                      writexy(1,4,'and has been changed back.  if you need');
                      writexy(1,5,'to change From:, run as a trusted user.');
                      writexy(1,6,'adding a Reply-To: is probably better');
}
                    end;
                end;
            end;
          writeln(mailcheckedf,s);
        end;
      close(mailf);
      close(mailcheckedf);

      delivermail(mailcheckedfn);

    end;

{leave refresh and re-opening of artf to caller}

end;

procedure mail;

var
  replyaddr: string;
  newsubj: string;
  ccaddr: string;

begin
  replyaddr := internalcmdlineparams;

  xclreolxy(1,lpp);
  xwrites('To: ');
  xreadlns(replyaddr,max(cols-5,75),yespreserve);
  replyaddr := expandmail(replyaddr);

  xclreolxy(1,lpp);
  xwrites('CC: ');
  xreadlns(ccaddr,max(cols-5,75),nopreserve);
  ccaddr := expandmail(ccaddr);

  xclreolxy(1,lpp);
  xwrites('Subject: ');
  xreadlns(newsubj,max(cols-10,70),nopreserve);

  if replyaddr<>'' then
    editanddeliver(newsubj,'',replyaddr,'',ccaddr,'','',false);

{ caller must refresh }

end;

end.
