unit rnrinit;

{

rnrinit.pas - rnr initialization

}

{$I rnr-def.pas}

interface

uses dos,crt,genericf,rnrglob,rnrio,rnrfile,rnrfunc,rnrproc,rnrkill

{$ifdef timeout}
,rnrtime
{$endif}

{$ifdef charset}
,rnrchar
{$endif}

{$ifdef mouse}
,mouse
{$endif}

;

const
  issuspicious=true;
  notsuspicious=false;

procedure initialize;

implementation

procedure usage;

begin
  xwritelnsss('usage: ',newsreadername,' [options]');
  xwritelns('  -u --user %A');
  xwritelns('  -n --newsgroup c.b.w (jumps directly to that newsgroup)');
  xwritelns('  -p --port 0 (uses that fossil port - 0=COM1, 1=COM2)');
  xwritelns('  -f --fullname Full_Name (underscores will become spaces)');
  xwritelns('  -e --editor d:/path/editor[.exe] (uses this editor)');
  xwritelns('  -o --editor-options !_w:\user\%A (editor non-filename options)');
  xwritelns('  -s --forum-set-list local_usenet (uses these forum sets only)');
  xwritelns('  -t --trusted (allows dialin users to edit articles)');
  xwritelns('  -i --interface (specify waffle or uupc file layout)');
  xwritelns('  -v --interface-version %V (specifies interface version)');
  xwritelns('  -m --minutes %O (specifies minutes online time, or -1)');
  xwritelns('  -d --shadow 1 (shadows all COMx output to console)');
  xwritelns('  -r --rcfile w:/waffle/lib/rnr.opt (reads in options)');
  xwriteln;
  xwritelns('see documentation for other configuration options');
  xwriteln;
  xwritelns('russell@alpha3.ersys.edmonton.ab.ca ('+releasedate+')');
  xwritelns('Adapted for UUPC by storner@osiris.ping.dk (941204)');
  shutdown(1);
end;

{$ifdef mouse}

procedure handler     { Mouse event handler called by device driver }
   (flags, cs, ip, ax, bx, cx, dx, si, di, ds, es, bp: word);
interrupt;

begin
  mousevent.event     := ax;
  mousevent.btnstatus := bx;
  mousevent.horiz     := cx;
  mousevent.vert      := dx;
  inline (        { Exit processing for far return to device driver }
       $8B/$E5/            { MOV  SP, BP }
       $5D/                { POP  BP }
       $07/                { POP  ES }
       $1F/                { POP  DS }
       $5F/                { POP  DI }
       $5E/                { POP  SI }
       $5A/                { POP  DX }
       $59/                { POP  CX }
       $5B/                { POP  BX }
       $58/                { POP  AX }
       $CB );              { RETF    }
end;

{$endif}

procedure defaultlppcols;

begin
  if console then
    begin
      if detectvideo then
        begin
          lpp := mem[$40:$84]+1;
          cols := mem[$40:$4a];
        end
      else
        begin
          lpp := 25;
          cols := 80
        end;
    end
  else
    begin
      lpp := 24;
      cols := 80;
    end;
end;

procedure fixuplppcols;

begin
  lpp := max(minlpp,min(lpp,maxlpp));
  cols := max(mincols,min(cols,maxcols));

{26 letters+10 digits for toggles}

  sellpp := min(lpp-selheaderlines-4,36);
end;

procedure backupjoin;

var
  s: string;
  tempf: text;
  createjoined: boolean;

begin
  xwritelns('Backing up join file...');

  createjoined := (numjoined=0);

  assign(tempf,home+'\join.bak');
  rewrite(tempf);

  reset(joinf);
  while not eof(joinf) do
    begin
      readln(joinf,s);
      writeln(tempf,s);
      if createjoined and (numjoined<maxjoined) then
        begin
          inc(numjoined);
          joinedgroups[numjoined] := getfirstw(s);
        end;
    end;

  close(tempf);
  reset(joinf);
end;

procedure initialize;

var
  currparmi: integer;
  currparm: string;
  nextparm: string;
  optf: text;
  opttag: string;
  optval: string;
  gotogroup: boolean;
  ch: char;

  tempcolors: string;


procedure initopts;

begin
  userid := '';
  currgroup := '';
  forumsetl := '';
  iface := '';
  xiface := ifaceunknown;
  ifaceversion := '';
  uupcusr := '';
  uupcsys := '';
  timezone := '';

{set up things for clean shutdowns}

  haskillfile := false;
  hasantikillfile := false;
  killfileinmem := false;
  antikillfileinmem := false;
  joinfn := '';
  if console then
    oldtextattr := textattr;

  checkdeletionsgroup := '';

{$ifdef tiny}
  console := false;
  port := 0;
  trusted := false;
  minutestorun := 60;
{$else}
  console := true;
  port := -1;
  trusted := true;
  minutestorun := maxint;
{$endif}

  fullname := '';
  editor := '';
  editoroptions := '';
  vspeller := '';
  vspelleroptions := '';
  shadow := 0;
  optfn := '';

  subjectscaseinsensitive := false;
  subjectlength := 50;
  squashspaces := false;
  equatetruncated := 0;
  makespacelikex := false;
  hideheaders := '';
  showheaders := '';
  highlightheaders := upper(':Subject:From:Date:');
  nomailfrom := false;
  nomailheaders := '';
  nonewsheaders := '';
  wanderingnumbers := false;
  antikillreferences := false;
  showsubjectkills := false;
  showfromkills := false;
  showsubjectantikills := false;
  showfromantikills := false;
  autoantikill := false;
  warnautoantikill := false;
  editaftervspell := false;
  caseinsensitivekill := false;
  caseinsensitiveantikill := false;
  substringsubjectkill := false;
  substringfromkill := false;
  substringsubjectantikill := false;
  substringfromantikill := false;
  quiet := false;
  ignoreenvironment := false;
  confirmnext := false;
  confirmquit := false;
  missingsubjectisok := false;
  tildehome := false;
  antikillthisnewsreader := false;
  clearscreenbetweengroups := false;
  detectvideo := false;
  antikillevenkilled := false;
  mailprefix := '';
  ignoremouse := false;
  usebiosforscreen := false;
  hideformfeeds := false;
  pathuserid := '';
  customstatic := '';
  haltonunknowngroups := false;
  mousecharsheader := '< > ^ $ * - + Q N @ ~ Z G ''';
  justdots := false;
  nofilemode := false;
  quitmessage := 'Closing files...';
  outputseparator := '---cut-here---';
  newscmdline := '';
  mailcmdline := '';
  mailagent := false;
  outgoingmail := '';
  outgoingnews := 'monitor';
  highlightsearchhits := false;
  colors := '';

{$ifdef charset}
  uselocalcharset := false;
{$endif}

  rmailsingle := false;

  idleminutes := 5;

  swap := '';

  articlefilenamepattern := '*';
  overviewbasename := 'overview';

  fromwidth := 0;
  sizewidth := 0;

  entergroupcommand := '';

  dotsonreset := false;

  viewcommand := 'viewart';
  extractcommand := 'munpack';

  if (dosversion and $ff)<3 then
    nofilemode := true;

end;

function handleoption(tag, maybedash: string; suspicious: boolean): boolean;

var
  value: string;
  usedarg: boolean;
  mayuserestrictedopts: boolean;

procedure handlemap(cmdline: string);

var
  where: string;
  oldkey,newkey: char;
  newcmdline: string;

function whatch: char;

var
  result: char;
  donescan: boolean;

begin
  result := chr(0);

  if newcmdline<>'' then
    begin
      if (newcmdline[1]='\') and (length(newcmdline)>1) then
        begin
          result := newcmdline[2];
          newcmdline := chop(newcmdline,2);  {get rid of it and the backslash}
        end
      else if (newcmdline[1]='=') and (length(newcmdline)>1) then
        begin
          newcmdline := chop(newcmdline,1);  {get rid of the equals}
          donescan := false;
          while not donescan do
            begin
              if length(newcmdline)=0 then
                donescan := true     {no more to see}
              else if (newcmdline[1]<'0') or (newcmdline[1]>'9') then
                donescan := true     {no more digits, anyway}
              else
                begin
                  result := chr(10*ord(result)+ord(newcmdline[1])-ord('0'));
                  newcmdline := chop(newcmdline,1);   {get rid of digit}
                end;
            end;
        end
      else
        begin
          result := newcmdline[1];
          newcmdline := chop(newcmdline,1);
        end;
    end;
  whatch := result;
end;

begin
  newcmdline := cmdline;
  newkey := chr(0);
  oldkey := chr(0);
  where := chopfirstw(newcmdline);
  newcmdline := ltrim(newcmdline);
  oldkey := whatch;
  newcmdline := ltrim(newcmdline);
  newkey := whatch;

  if (oldkey<>chr(0)) and (newkey<>chr(0)) then
    begin
      if where='browse' then
        begin
          browsemap[oldkey] := newkey;
        end
      else if where='select' then
        begin
          selmap[oldkey] := newkey;
        end
      else if where='both' then
        begin
          browsemap[oldkey] := newkey;
          selmap[oldkey] := newkey;
        end
      else if where='main' then
        begin
          mainmap[oldkey] := newkey;
        end
      else
        begin
          warn('weird use of map - ignored '+cmdline);
        end;
    end
  else
    begin
      warn('weird use of map - ignored '+cmdline);
    end;
end;

begin

  if maybedash='-' then
    value := ''
  else
    value := maybedash;

  usedarg := false;

{re-comment that part to force trusted users to put their options}
{in the command-line or system rc only, not the user rc}

  mayuserestrictedopts := {uncomment} trusted or {uncomment} (not suspicious);

  if tag='--map' then
    begin
      handlemap(value);
      usedarg := true;
    end
  else if (tag='-u') or (tag='--user') then
    begin
      if mayuserestrictedopts then
        userid := value;
      usedarg := true;
    end
  else if (tag='-n') or (tag='--newsgroup') then
    begin
      currgroup := value;
      if currgroup<>'' then
        alreadyingroup := true;
      usedarg := true;
    end
  else if (tag='-g') or (tag='--goto') then
    begin
      gotogroup := true;
      if copy(value,1,1)<>'-' then
        begin
          currgroup := value;
          usedarg := true;
        end;
    end
  else if (tag='-p') or (tag='--port') then
    begin
      if mayuserestrictedopts then
        port := atoi(value);
      console := false;
      trusted := false;
      usedarg := true;
    end
  else if (tag='-l') or (tag='--lines') then
    begin
      lpp := atoi(value);
      usedarg := true;
    end
  else if (tag='-c') or (tag='--columns') then
    begin
      cols := atoi(value);
      usedarg := true;
    end
  else if (tag='-f') or (tag='--fullname') then
    begin
      if mayuserestrictedopts then
        fullname := trim(ununderscore(value));
      usedarg := true;
    end
  else if (tag='-e') or (tag='--editor') then
    begin
      if mayuserestrictedopts then
        editor := value;
      usedarg := true;
    end
  else if (tag='-o') or (tag='--editor-options') then
    begin
      if mayuserestrictedopts then
        editoroptions := ununderscore(value);
      usedarg := true;
    end
  else if (tag='-s') or (tag='--forum-set-list') then
    begin
      if mayuserestrictedopts then
        forumsetl := uncomma(ununderscore(value));
      usedarg := true;
    end
  else if (tag='-t') or (tag='--trusted') then
    begin
      if mayuserestrictedopts then
        trusted := true;
    end
  else if tag='--waffle-version' then
    begin
      xwritelns(
       'warning: obsolete option --waffle-version - use --interface-version');
      if mayuserestrictedopts then
        ifaceversion := value;
      usedarg := true;
    end
  else if (tag='-v') or (tag='--interface-version') then
    begin
      if mayuserestrictedopts then
        ifaceversion := value;
      usedarg := true;
    end
  else if (tag='-m') or (tag='--minutes') then
    begin
      if mayuserestrictedopts then
        minutestorun := atoi(value);
      usedarg := true;
    end
  else if (tag='-d') or (tag='--shadow') then
    begin
      if mayuserestrictedopts then
        shadow := atoi(value);
      usedarg := true;
    end
  else if (tag='-r') or (tag='--rcfile') then
    begin
      if mayuserestrictedopts then
        optfn := unslash(value);
      usedarg := true;
    end
  else if (tag='-i') or (tag='--interface') then
    begin
      if mayuserestrictedopts then
        iface := value;
      usedarg := true;
    end
  else if tag='--console' then
    begin
      xwritelns('warning: obsolete option --console');
      if mayuserestrictedopts then
        begin
          console := true;
          port := -1;
          trusted := true;
          minutestorun := maxint;
        end;
    end
  else if tag='--vspeller' then
    begin
      if mayuserestrictedopts then
        vspeller := unslash(value);
      usedarg := true;
    end
  else if tag='--vspeller-options' then
    begin
      if mayuserestrictedopts then
        vspelleroptions := ununderscore(value);
      usedarg := true;
    end
  else if tag='--subjects-case-insensitive' then
    begin
      subjectscaseinsensitive := true;
    end
  else if tag='--subject-length' then
    begin
      subjectlength := atoi(value);
      if subjectlength<5 then
        begin
          xwritelns('using subject-length of 5');
          subjectlength := 5;
        end;
      if subjectlength>maxsubjectlen then
        begin
          xwrites('using subject-length of ');
          xwritei(maxsubjectlen);
          xwriteln;
          subjectlength := maxsubjectlen;
        end;
      usedarg := true;
    end
  else if tag='--squash-spaces' then
    begin
      squashspaces := true;
    end
  else if tag='--equate-truncated' then
    begin
      equatetruncated := atoi(value);
      if equatetruncated<5 then
        begin
          xwritelns('using equate-truncated of 5');
          equatetruncated := 5;
        end;
      usedarg := true;
    end
  else if tag='--make-space-like-x' then
    begin
      makespacelikex := true;
    end
  else if tag='--make-return-like-asterisk' then
    begin
      xwritelns('warning: obsolete option --make-return-like-asterisk');
      xwritelns('warning: use --select =13 * instead');
      handlemap('select =13 *');
    end
  else if tag='--hide-these-headers' then
    begin
      hideheaders := upper(value);
      usedarg := true;
    end
  else if tag='--show-only-these-headers' then
    begin
      showheaders := upper(value);
      usedarg := true;
    end
  else if tag='--highlight-these-headers' then
    begin
      highlightheaders := upper(value);
      usedarg := true;
    end
  else if tag='--no-mail-from' then
    begin
      if mayuserestrictedopts then
        nomailfrom := true;
    end
  else if tag='--no-mail-headers' then
    begin
      if mayuserestrictedopts then
        nomailheaders := upper(value);
      usedarg := true;
    end
  else if tag='--no-news-headers' then
    begin
      if mayuserestrictedopts then
        nonewsheaders := upper(value);
      usedarg := true;
    end
  else if tag='--wandering-numbers' then
    begin
      wanderingnumbers := true;
    end
  else if tag='--antikill-references' then
    begin
      antikillreferences := true;
    end
  else if tag='--show-subject-kills' then
    begin
      showsubjectkills := true;
    end
  else if tag='--show-from-kills' then
    begin
      showfromkills := true;
    end
  else if tag='--show-subject-antikills' then
    begin
      showsubjectantikills := true;
    end
  else if tag='--show-from-antikills' then
    begin
      showfromantikills := true;
    end
  else if tag='--auto-antikill' then
    begin
      autoantikill := true;
    end
  else if tag='--warn-auto-antikill' then
    begin
      warnautoantikill := true;
    end
  else if tag='--edit-after-vspell' then
    begin
      editaftervspell := true;
    end
  else if tag='--case-insensitive-kill' then
    begin
      caseinsensitivekill := true;
    end
  else if tag='--case-insensitive-antikill' then
    begin
      caseinsensitiveantikill := true;
    end
  else if tag='--substring-subject-kill' then
    begin
      substringsubjectkill := true;
    end
  else if tag='--substring-from-kill' then
    begin
      substringfromkill := true;
    end
  else if tag='--substring-subject-antikill' then
    begin
      substringsubjectantikill := true;
    end
  else if tag='--substring-from-antikill' then
    begin
      substringfromantikill := true;
    end
  else if tag='--quiet' then
    begin
      quiet := true;
    end
  else if tag='--ignore-environment' then
    begin
      if mayuserestrictedopts then
        ignoreenvironment := true;
    end
  else if tag='--confirm-next' then
    begin
      confirmnext := true;
    end
  else if tag='--confirm-quit' then
    begin
      confirmquit := true;
    end
  else if tag='--missing-subject-is-ok' then
    begin
      missingsubjectisok := true;
    end
  else if tag='--tilde-home' then
    begin
      if mayuserestrictedopts then
        tildehome := true;
    end
  else if tag='--antikill-this-newsreader' then
    begin
      antikillthisnewsreader := true;
    end
  else if tag='--clear-screen-between-groups' then
    begin
      clearscreenbetweengroups := true;
    end
  else if tag='--detect-video' then
    begin
      if mayuserestrictedopts then
        begin
          if console then
            begin
              detectvideo := true;
              defaultlppcols;
            end;
        end;
    end
  else if tag='--antikill-even-killed' then
    begin
      antikillevenkilled := true;
    end
  else if tag='--mail-prefix' then
    begin
      if mayuserestrictedopts then
        mailprefix := value;
      usedarg := true;
    end
  else if tag='--ignore-mouse' then
    begin
      if mayuserestrictedopts then
        ignoremouse := true;
    end
  else if tag='--use-bios-for-screen' then
    begin
      if mayuserestrictedopts then
        usebiosforscreen := true;
    end
  else if tag='--hide-form-feeds' then
    begin
      hideformfeeds := true;
    end
  else if tag='--path-userid' then
    begin
      if mayuserestrictedopts then
        pathuserid := value;
      usedarg := true;
    end
  else if tag='--custom-static' then
    begin
      if mayuserestrictedopts then
        customstatic := value;
      usedarg := true;
    end
  else if tag='--halt-on-unknown-groups' then
    begin
      haltonunknowngroups := true;
    end
  else if tag='--mouse-chars-header' then
    begin
      mousecharsheader := value;
      usedarg := true;
    end
  else if tag='--just-dots' then
    begin
      justdots := true;
    end
  else if tag='--no-filemode' then
    begin
      if mayuserestrictedopts then
        nofilemode := true;
    end
  else if tag='--quit-message' then
    begin
      quitmessage := ununderscore(value);
      usedarg := true;
    end
  else if tag='--output-separator' then
    begin
      outputseparator := value;
      usedarg := true;
    end
  else if tag='--news-cmd-line' then
    begin
      if mayuserestrictedopts then
        newscmdline := value;
      usedarg := true;
    end
  else if tag='--mail-cmd-line' then
    begin
      if mayuserestrictedopts then
        mailcmdline := value;
      usedarg := true;
    end
  else if tag='--mail-agent' then
    begin
      mailagent := true;
    end
  else if tag='--outgoing-mail' then
    begin
      if mayuserestrictedopts then
        outgoingmail := value;
      usedarg := true;
    end
  else if tag='--outgoing-news' then
    begin
      if mayuserestrictedopts then
        outgoingnews := value;
      usedarg := true;
    end
  else if tag='--highlight-search-hits' then
    begin
      highlightsearchhits := true;
    end
  else if (tag='--colors') or (tag='--colours') then
    begin
      colors := uncomma(ununderscore(value));
      usedarg := true;
    end

{$ifdef charset}
  else if tag='--local-charset' then
    begin
      if mayuserestrictedopts then
        begin
          uselocalcharset := true;
          loadcharsets(value);
        end;
      usedarg := true;
    end
{$endif}

  else if tag='--rmail-single' then
    begin
      if mayuserestrictedopts then
        rmailsingle := true;
    end
  else if tag='--idle' then
    begin
      if mayuserestrictedopts then
        idleminutes := atoi(value);
      usedarg := true;
    end
  else if tag='--swap' then
    begin
      if mayuserestrictedopts then
        swap := value;
      usedarg := true;
    end
  else if tag='--article-filename-pattern' then
    begin
      if mayuserestrictedopts then
        articlefilenamepattern := value;
      usedarg := true;
    end
  else if tag='--overview-base-name' then
    begin
      if mayuserestrictedopts then
        overviewbasename := value;
      usedarg := true;
    end
  else if tag='--from-width' then
    begin
      fromwidth := atoi(value);
      usedarg := true;
    end
  else if tag='--size-width' then
    begin
      sizewidth := atoi(value);
      usedarg := true;
    end
  else if tag='--enter-group-command' then
    begin
      if mayuserestrictedopts then
        entergroupcommand := value;
      usedarg := true;
    end
  else if tag='--dots-on-reset' then
    begin
      dotsonreset := true;
    end
  else if tag='--view-command' then
    begin
      if mayuserestrictedopts then
        viewcommand := value;
      usedarg := true;
    end
  else if tag='--extract-command' then
    begin
      if mayuserestrictedopts then
        extractcommand := value;
      usedarg := true;
    end
  else
    begin


{$ifdef ignoreoldoptions}

{ compatibility switch with earlier releases - now obsolete }

{try to make sure any error messages are going to be visible!}

      console := true;
      xwritesss(newsreadername,' ',newsreaderversion);
      xwritelnss(': unknown option: ',tag);
      usage;  {usage shuts down}

{$else}

      userid := tag;
      xwritelns('warning: obsolete usage of userid on the command line');
      xwritelns('use -u/--user instead');

{$endif}

    end;

  handleoption := usedarg;

end;

begin
  randomize;
  new(filenamesp);
  new(fromsp);
  new(datesp);
  new(killsubjsp);
  new(killfromsp);
  new(killtextp);
  new(antikillsubjsp);
  new(antikillfromsp);
  new(antikilltextp);
  new(hmessageidsp);
  new(hreferencesp[1]);
  new(hreferencesp[2]);
  new(hreferencesp[3]);
  new(hreferencesp[4]);

  initopts;

  alreadyingroup := false;
  startingart := impossibleart;
  readpagesback := 0;
  readunfiltered := false;
  searchinheaders := false;
  searchinbody := false;
  searchtext := '';

  gotogroup := false;

  lastfilen := '';
  lastfolder := '';

  defaultlppcols;

  for ch := chr(0) to chr(255) do
    begin
      browsemap[ch] := ch;
      selmap[ch] := ch;
      mainmap[ch] := ch;
    end;

{first do command-line options, which may use restricted options}

{$ifdef debug}
  xwritelns('parameters:');
  for currparmi := 1 to paramcount do
    xwritelns(paramstr(currparmi));
{$endif}

  currparmi := 1;
  while currparmi<=paramcount do
    begin
      currparm := paramstr(currparmi);
      if currparmi<paramcount then
        nextparm := paramstr(currparmi+1)
      else
        nextparm := '';

      if handleoption(currparm,nextparm,notsuspicious) then
        inc(currparmi);

      inc(currparmi);

    end;

{then do rcfile options, which may also use restricted options}

  if optfn<>'' then
    begin

{waste of time - tpascal doesn't use filemode on text files!}

      oldfilemode := filemode;
      if not nofilemode then
        filemode := $40;   {read only, deny none}

      safereset(optf,optfn);
      if fileresult<>0 then
        begin
          console := true;
          xwritelnss('could not open option file ',optfn);
          shutdown(1);
        end;
      optfn := '';
      while not eof(optf) do
        begin
          readln(optf,optval);
          opttag := chopfirstw(optval);
          if length(opttag)>0 then
            if opttag[1]<>'#' then
              begin
                if opttag[1]<>'-' then
                  opttag := '--'+opttag;
                if handleoption(opttag,optval,notsuspicious) then
                  ;
              end;
        end;
      close(optf);

      filemode := oldfilemode;

      if optfn<>'' then
        xwritelns('cannot use -r/--rcfile inside an rcfile, sorry');
    end;

  if usebiosforscreen then
    directvideo := false;

{try to make sure any error messages are going to be visible!}

  if not console and (port<>0) and (port<>1) and (port<>2) and (port<>3) then
    begin
      console := true;
      xwritelns('error: -p/--port specified without valid port number');
      xwritelns('  valid numbers are 0 (COM1) and 1 (COM2)   (2=COM3 and');
      xwritelns('  3=COM4 allowed, your fossil may not support them)');
      shutdown(1);
    end;

  xwritelnsss(newsreadername,' ',newsreaderversion);

  wafenv := unslash(getenv('WAFFLE'));
  uupcusr := unslash(getenv('UUPCUSRRC'));
  uupcsys := unslash(getenv('UUPCSYSRC'));

  if (iface='') and (wafenv<>'') then
    begin
      iface := 'waffle';
      notquietlns('(assuming waffle interface)');
    end;

  if (iface='') and (uupcusr<>'') then
    begin
      iface := 'uupc';
      notquietlns('(assuming uupc interface)');
    end;

  if iface='waffle' then
    xiface := ifacewaffle
  else if iface='uupc' then
    xiface := ifaceuupc
  else if iface='uufree' then
    xiface := ifaceuufree
  else
    begin
      xwritelnss('unknown interface: ',iface);
      xwritelns('currently known:  waffle, uupc, uufree');
      shutdown(1);
    end;

  if (userid='') and not ignoreenvironment then
    userid := lower(getenv('NET_NAME'));
  if (userid='') and not ignoreenvironment then
    userid := lower(getenv('USER'));

  if userid='' then
    userid := getconfig('mailbox');

  if userid='' then
    usage;

  xwritelnss('user: ',userid);

  if pathuserid='' then
    pathuserid := userid;

  if (xiface=ifacewaffle) and (wafenv='') then
    begin
{$ifdef waffleenvcanbemissing}
      xwritelns('no WAFFLE environment variable - using `./static''.');
      wafenv := './static';
{$else}
      xwritelns('must set WAFFLE environment variable');
      shutdown(1);
{$endif}
    end;

  if (xiface=ifaceuupc) and (uupcsys='') then
    begin
      xwritelns('must set UUPCSYSRC environment variable');
      shutdown(1);
    end;

  if (xiface=ifaceuufree) and (wafenv='') then
    begin
{$ifdef waffleenvcanbemissing}
      xwritelns('no WAFFLE environment variable - using `./static''.');
      wafenv := './static';
{$else}
      xwritelns('must set WAFFLE environment variable');
      shutdown(1);
{$endif}
    end;

  if (ifaceversion='') and not ignoreenvironment then
    ifaceversion := getenv('INTERFACEVERSION');

  if (ifaceversion='') and (xiface=ifacewaffle) and not ignoreenvironment then
    ifaceversion := getenv('WAFFLEVERSION');

{
need to define configdir before using it to check if waf165's index
file is there for 1.65 auto-detection
}

  configdir := getconfig('configdir');
  if (configdir='') and (xiface=ifacewaffle) then
    configdir := copy(wafenv,1,rposc(wafenv,'\')-1);
  if (configdir='') and (xiface=ifaceuufree) then
    configdir := copy(wafenv,1,rposc(wafenv,'\')-1);
  configdir := unslash(configdir);

  if ifaceversion='' then
    ifaceversion := getconfig('version');

  if (ifaceversion='') and (xiface=ifacewaffle) then
    if fexists(configdir+'\admin\'+'index') then
      ifaceversion := '1.65'
    else
      ifaceversion := '1.64';

  if (ifaceversion='') and (xiface=ifaceuufree) then
    ifaceversion := 'unix';

  if xiface=ifacewaffle then
    if (length(ifaceversion)<>4) or (copy(ifaceversion,2,1)<>'.') or
     (numoccur('.',ifaceversion)<>1) then
      begin
        xwritelns('WAFFLEVERSION environment variable, or static file');
        xwritelns('version: setting, or -v/--interface-version argument');
        xwritelns('in wrong format -- should be similar to `1.64''');
        xwritelns('(without the quotes)');
        xwritelnsss('it is currently set to: `',ifaceversion,'''');
        shutdown(1);
      end;

  if not quiet then
    begin
      xwritess('interface: ',iface);
      xwritelnss(', version ',ifaceversion);
    end;

  temporarydir := getconfig('tempdir');

  if not ignoreenvironment then
    begin
      temporarydir := default(getenv('TMP'),temporarydir);
      temporarydir := default(getenv('TEMP'),temporarydir);
    end;
  temporarydir := default('.',temporarydir);
  temporarydir := unslash(temporarydir);

  spooldir := unslash(default(configdir+'/spool',getconfig('spooldir')));
  userdir := unslash(default(configdir+'/user',getconfig('userdir')));
  outboxdir := unslash(default(spooldir+'/outbox',getconfig('outboxdir')));
  outform := default('flat',lower(getconfig('outform')));

  if (outform<>'flat') and (outform<>'hierarchy') then
    begin
      xwritelnsss('unsupported outbox format: ',outform,', using flat');
      outform := 'flat';
    end;

{
  if outform<>'flat' then
    xwritelns('outform: '+outform+' not supported yet, sorry');
}

  if (fullname='') and (xiface=ifacewaffle) then
    fullname := trim(getpwinfo(5,3,5));

  if (fullname='') and (xiface=ifaceuupc) then
    fullname := getconfig('fullname');

  if (fullname='') and not ignoreenvironment then
    fullname := trim(ununderscore(getenv('FULLNAME')));

  if fullname='' then
    begin
      xwritelnsss('user ',userid,' has no name in the password file');
      xwritelns('  that can be found, and environment variable FULLNAME');
      xwritelns('  not set, and option -f/--fullname not used');
      shutdown(1);
    end;

{finally do user's rc file options, which may NOT use restricted options}

{done as early as possible to allow user to use --quiet usefully}

  if xiface=ifacewaffle then
    home := userdir+'\'+userid;

  if xiface=ifaceuupc then
    home := unslash(unbackslash(getconfig('home')));

  if xiface=ifaceuufree then
    home := userdir+'\'+userid;

  if home='' then
    begin
      xwritelns('unknown home directory');
      shutdown(1);
    end;
  
{waste of time - tpascal doesn't use filemode on text files!}

  oldfilemode := filemode;
  if not nofilemode then
    filemode := $40;   {read only, deny none}

  optfn := home+'\'+newsreadername+'.rc';

  safereset(optf,optfn);
  if fileresult=0 then
    begin
      while not eof(optf) do
        begin
          readln(optf,optval);
          opttag := chopfirstw(optval);
          if length(opttag)>0 then
            if (opttag[1]<>'#') and (opttag[1]<>';') then
              begin
                if opttag[1]<>'-' then
                  opttag := '--'+opttag;

{very important that this is marked as `suspicious' value (third arg)!}

                if handleoption(opttag,optval,issuspicious) then
                  ;
              end;
        end;
      close(optf);
    end
  else
    xwritelnsss('(could not open option file ',optfn,')');

  filemode := oldfilemode;

{finally done reading options}

  notquietlnss('full name: ',fullname);

{}{} {needs to get editor entry from password and extern/_editors files}

  if (editor='') and not ignoreenvironment then
    editor := getenv('VISUAL');
  if (editor='') and not ignoreenvironment then
    editor := getenv('EDITOR');
  if editor='' then
    editor := 'vi';

  notquietlnss('editor: ',editor);

  if (vspeller='') and not ignoreenvironment then
    vspeller := getenv('VSPELL');
  if (vspeller='') and not ignoreenvironment then
    vspeller := getenv('SPELL');
  if vspeller='' then
    vspeller := 'vspell';

  notquietlnss('vspeller: ',vspeller);

  if not quiet and (minutestorun>=0) then
    if minutestorun>24*60 then
      xwritelnsi('days left this session: ',minutestorun div 60 div 24)
    else if minutestorun>60 then
      xwritelnsi('hours left this session: ',minutestorun div 60)
    else
      xwritelnsi('minutes left this session: ',minutestorun);

  if (swap<>'') and (swap<>'no') and (swap<>'ems') then
    begin
      xwritelns('unknown --swap parameter');
      xwritelns('  --swap no   => no swapping');
      xwritelns('  --swap ems  => swap to EMS');
      shutdown(1);
    end;

{}{should depend on cols}
  if (fromwidth<5) or (fromwidth>80) then
    fromwidth := 20;

  if (sizewidth<1) or (sizewidth>4) then
    sizewidth := 4;

  uucpname := getconfig('uucpname');
  fqdn := getconfig('fqdn');
  organ := getconfig('organ');
  netmail := getconfig('netmail');
  netnews := getconfig('netnews');
  replyto := getconfig('replyto');
  newsname := default(uucpname,getconfig('newsname'));

  smarthost := getconfig('smarthost');
  if (smarthost='') and (xiface=ifaceuupc) then
    smarthost := uupcgetconfig('newsserv');

  if (uucpname='') or (smarthost='') then
    begin
      xwritelns('invalid uucpname or smarthost static variable');
      xwritelns('  neither of these may be empty');
      xwritelns('  current values:');
      xwritelnss('  uucpname:  ',uucpname);
      xwritelnss('  smarthost: ',smarthost);
      shutdown(1);
    end;

  smarthostdir := smarthost;
  if pos('!',smarthostdir)<>0 then
    smarthostdir := copy(smarthost,1,pos('!',smarthostdir)-1);
  smarthostdir := spooldir+'\'+smarthostdir;

  maybemkhier(home);
  maybemkhier(outboxdir);
  maybemkhier(temporarydir);
  maybemkhier(smarthostdir);

  backbone := getconfig('backbone');
  if backbone='' then
    begin
{use waffle's default}
      xwritelns('no backbone static variable -- using berkeley');
      backbone := 'ucbvax.berkeley.edu';
    end;

  if mailprefix='' then
    mailprefix := uucpname+'.mail';

{make life easier later - redefine mailprefix to include userid}

  mailprefix := mailprefix+'.'+userid;

  notquietlnss('mail groups begin with ',mailprefix);

  if netmail='' then
    netmail := '%A@%n (%W)';
  if netnews='' then
    netnews := netmail;

  mailfrom := wafexpand(netmail);
  newsfrom := wafexpand(netnews);
  if replyto<>'' then
    replyto := wafexpand(replyto);

  if
      hasno('.',fqdn)
   or
      (numoccur('@',mailfrom)>1)
   or
      (numoccur('@',newsfrom)<>1)
   or
      (numoccur('@',replyto)>1)
   or
      (pos('@.',mailfrom)<>0)
   or
      (pos('@.',newsfrom)<>0)
   or
      (pos('@.',replyto)<>0)
   or
      (
        hasno('@',mailfrom) and hasno('!',mailfrom)
      )
   or
      (
        (replyto<>'') and hasno('@',replyto) and hasno('!',replyto)
      )
   or
      (
        hasany('(',newsfrom) and
          (
               (numoccur('(',newsfrom)<>1)
            or (numoccur(')',newsfrom)<>1)
            or (numoccur('<',newsfrom)<>0)
            or (numoccur('>',newsfrom)<>0)
          )
      )

   then

    begin
      xwritelns('invalid node: or netmail:/netnews:/replyto: static entry');
      xwritelns('  the node (fqdn) entry needs at least one "."');
      xwritelns('  the netmail entry needs one "@" and/or at least one "!"');
      xwritelns('  the netnews entry needs one "@"');
      xwritelns('  the netnews entry cannot have any of ()<> inside the ()');
      xwritelns('  any replyto entry needs one "@" and/or at least one "!"');
      xwritelns('  @. is never legal in a mail address');
      xwriteln;
      xwritelns('current settings:');
      xwritelnss('  node:     ',fqdn);
      xwritelnss('  newsfrom: ',newsfrom);
      xwritelnss('  mailfrom: ',mailfrom);
      xwritelnss('  replyto:  ',replyto);
      shutdown(1);
    end;

  notquietlnss('mail from: ',mailfrom);

  if mailfrom<>newsfrom then
    notquietlnss('news from: ',newsfrom);

  if replyto<>'' then
    if not quiet then
      begin
        if replyto=mailfrom then
          xwritelnss('reply-to: ','(same as mail)')
        else if replyto=newsfrom then
          xwritelnss('reply-to: ','(same as news)')
        else
          xwritelnss('reply-to: ',replyto);
      end;

  maymail := trusted;
  maypost := trusted;

  if pos('@no.such.domain',mailfrom)<>0 then
    begin
      maymail := false;
      xwritelns('unconfigured -- you may not mail');
    end;

  if pos('@no.such.domain',newsfrom)<>0 then
    begin
      maypost := false;
      xwritelns('unconfigured -- you may not post');
    end;

  if forumsetl='' then
    forumsetl := getconfig('forums');

  forumsetl := ltrim(trim(forumsetl));

  if (forumsetl='') and (xiface=ifaceuupc) then
    forumsetl := 'active';

  if forumsetl='' then
    begin
      xwritelns('empty forum set list');
      shutdown(1);
    end;

  notquietlnss('forum set list: ',forumsetl);

  if not ignoreenvironment then
    timezone := getenv('TZ');

  if timezone='' then
    timezone := getconfig('timezone');
  if timezone='' then
    timezone := '-0700';
  if pos(' ',timezone)>1 then
    timezone := copy(timezone,1,pos(' ',timezone)-1)
  else if (timezone[1]<>'+') and (timezone[1]<>'-') then
    timezone := copy(timezone,1,3);
{ handles TZ=GMT0BST and TZ=+1100 and TZ=BST-1 cases }

  notquietlnss('timezone: ',timezone);

  comspec := getenv('COMSPEC');
  if comspec='' then
    if indir('c:\.','command.com') then
      comspec := 'c:\command.com'
    else
      comspec := 'command.com';

  if newscmdline='(standard)' then
    newscmdline := getsyscmd('news');

  if newscmdline='' then
    newscmdline := 'rnews';

  notquietlnss('newscmdline: ',newscmdline);

  if mailcmdline='(standard)' then
    mailcmdline := getsyscmd('mail');

  if mailcmdline='' then
    mailcmdline := '(builtin)';

  notquietlnss('mailcmdline: ',mailcmdline);


  if newscmdline='(builtin)' then
    begin
      xwritelns('error:  there is no builtin newscmdline');
      shutdown(1);
    end;



{once joinfn is assigned to a nonempty string, it's open}

  joinfn := home+'\join';
  safereset(joinf,joinfn);
  if fileresult<>0 then
    begin
      xwritelnsss('join file ',joinfn,' not found.');
      joinfn := '';
      shutdown(1);
    end;

  numjoined := 0;
  backupjoin;

  readinkill(yesbackupkill);
  readinantikill(yesbackupkill);

  if currgroup<>'' then
    if not joinedtogroup(currgroup) then
      begin
        xwritelnsss('not joined to ',currgroup,
         ' - starting at top of join file');
        currgroup := '';
        alreadyingroup := false;
      end;

{$ifdef timeout}

  minstart := mitoday;
  minlastinput := mitoday;

{$endif}

  fixuplppcols;

  if not quiet then
    begin
      xwritelnsi('lines per page: ',lpp);
      xwritelnsi('sel lines per page: ',sellpp);
      xwritelnsi('columns: ',cols);
      if usebiosforscreen then
        xwritelns('(using bios for screen writes)');
      if hideformfeeds then
        xwritelns('(hiding form feeds)');
    end;

{$ifdef mouse}

  hasmouse := false;

{$endif}

  if console then
    begin
      oldtextattr := textattr;
      lowcolor := 7;
      highcolor := 15;

      if colors='' then
        colors := getconfig('colors');

      if colors='' then
        colors := getconfig('colours');

      if colors<>'' then
        begin
          tempcolors := colors;
          lowcolor := atoi(chopfirstw(tempcolors));
          highcolor := atoi(getfirstw(tempcolors));
        end;

      if (lowcolor mod 16)=(highcolor mod 16) then
        if (lowcolor mod 16)=7 then
          highcolor := 15
        else
          lowcolor := 7;

      xlowvideo;

{$ifdef mouse}

      if not ignoremouse then
        begin
          mreset(themouse);
          hasmouse := themouse.exists;
        end;

      if hasmouse then
        begin
          minsttask($14,seg(handler),ofs(handler));
          mousevent.event := 0;
          mshow;
        end;

{$endif}

    end;

  if outgoingmail<>'' then
    begin
      unfoldergroup(outgoingmail);
      if not ismailgroup(outgoingmail) then
        outgoingmail := '='+outgoingmail;
      unfoldergroup(outgoingmail);
      xwritelnss('copies of outgoing mail will be put in ',outgoingmail);
    end;

  if gotogroup then
    begin

{ make sure last line had no valuable information }
      xgotoxy(1,lpp);
      xwriteln;

      pickagroup(currgroup);
      if currgroup<>'' then
        alreadyingroup := true;
    end;
end;

end.
