unit rnrmain;

{

rnrmain.pas - rnr main (to keep from recompiling huge rnr.pas)

}

{$I rnr-def.pas}

interface

uses dos,crt,genericf,rnrfunc,rnrglob,rnrselb,rnrio,
  rnrproc,rnrkill,rnrfile

{$ifdef timeout}

,rnrtime

{$endif}

{$ifdef charset}

,rnrchar

{$endif}

{$ifdef mouse}

,mouse   {see rnrmous.pas}

{$endif}

;


procedure sethash(var h: hashedt; s: string);
procedure swapi(var i,j: integer);
procedure swapart(a,b: integer);
procedure sortitall;
procedure readinarts;
procedure groupinit;
procedure findhighest;

implementation

procedure sethash;

var
  i: integer;
  atat: integer;
{$ifdef oldhash}
  ls,rs: integer;
{$endif}
  leng: integer;
  l: integer;
  startaft: integer;

begin
{$ifdef oldhash}
  for i := 1 to 6 do
    h[i] := 0;

  atat := pos('@',s);
  if atat=0 then
    begin
{leave malformed ones alone}
    end
  else
    begin
{assume all message-ids are at least 6 chars long - a@b.cd is}
      ls := atat-6;
      rs := atat+1;
{handle these specially - the last bunch of stuff is always the same!}
      if pos(newsreadername,s)>0 then
        ls := 10;
      if ls<1 then
        ls := 1;
      if atat>length(s)-5 then
        rs := length(s)-5;
      for i := 1 to 3 do
        h[i] := 16*( (ord(s[ls+i*2-1])) and 15)+( (ord(s[ls+i*2])) and 15);
      for i := 1 to 3 do
        h[i+3] := 16*( (ord(s[rs+i*2-1])) and 15)+( (ord(s[rs+i*2])) and 15);
    end;
{$endif}

  h[1] := 0;
  h[2] := 0;
  atat := pos('@',s);
  if atat=0 then
    begin
{leave malformed ones alone}
    end
  else
    begin
      leng := length(s);
      l := min(16,leng);

      for i := 1 to l do
        if odd(ord(s[i])) then
          h[1] := (h[1] shl 1)+1
        else
          h[1] := h[1] shl 1;

      l := min(16,leng);

      startaft := leng-l;
      if startaft>atat then
        startaft := atat;

      for i := 1 to l do
        if odd(ord(s[startaft+i])) then
          h[2] := (h[2] shl 1)+1
        else
          h[2] := h[2] shl 1;
    end;

{$ifdef testhash}

{
writeln('hashed "',s,'" to ',h[1]:5,' ',h[2]:5);
}

{$endif}

end;

procedure swapi;

var
  t: integer;

begin
  t := i;
  i := j;
  j := t;
end;

procedure swapart;

var
  tempsubj: subjstringt;
  tempfilename: fnstringt;
  tempdate: datet;
  tempindents: byte;
  tempsizeink: byte;
  tempfrom: fromstringt;

{don't need to worry about hashing or canon stuff - by this time, not needed}

begin
  tempsubj := basesubjs[a];
  tempfilename := filenamesp^[a];
  tempdate := datesp^[a];
  tempindents := indents[a];
  tempsizeink := sizeink[a];
  tempfrom := fromsp^[a];

  basesubjs[a] := basesubjs[b];
  filenamesp^[a] := filenamesp^[b];
  datesp^[a] := datesp^[b];
  indents[a] := indents[b];
  sizeink[a] := sizeink[b];
  fromsp^[a] := fromsp^[b];

  basesubjs[b] := tempsubj;
  filenamesp^[b] := tempfilename;
  datesp^[b] := tempdate;
  indents[b] := tempindents;
  sizeink[b] := tempsizeink;
  fromsp^[b] := tempfrom;
end;

procedure sortitall;

type
  intptrst=array[1..maxarts] of integer;

var
  i,j: integer;

  currart: integer;

  dateptrs,subjptrs,finalptrs,revfinalptrs: intptrst;

  dateptrsdone: integer;
  finalptrsdone: integer;

  finalstart: integer;
  currsubjptr: integer;
  foundnewsubj: boolean;
  currsubj: subjstringt;
  currcanonfirstchar: char;

  step: integer;
  base: integer;
  lowpos: integer;
  highpos: integer;

  numartsdivstep: integer;

{$ifdef testsort}
  debugf: text;
  debugfn: string;
{$endif}

begin

{first sort by date, then for each oldest article, take the rest of the}
{articles in that thread together, sorting within the thread only}

  for i := 1 to numarts do
    dateptrs[i] := i;

{the dates equal but subjects not test is for comp.sources.* etc. v29i033}
{hopefully will help part 1/6 posts too (eg alt.sources)}

{$define bubble}
{$undef bubble}

{$ifdef bubble}

  for i := 1 to numarts-1 do
    for j := i+1 to numarts do
      if (datesp^[dateptrs[i]]>datesp^[dateptrs[j]]) then
        swapi(dateptrs[i],dateptrs[j])
      else if
       (
        (datesp^[dateptrs[i]]=datesp^[dateptrs[j]])
         and
        xfirstsubjg
         (
          canonfirstchars[dateptrs[i]],
          canonfirstchars[dateptrs[j]],
          basesubjs[dateptrs[i]],
          basesubjs[dateptrs[j]]
         )
       ) then
        swapi(dateptrs[i],dateptrs[j]);

{$else}

  step := 127;
  while step>0 do
    begin
      if not quiet then
        begin
          xwritei(step);
          xwrites('.');
        end;

      numartsdivstep := numarts div step;

      for base := 1 to step do
        for i := 0 to numartsdivstep do
          for j := i+1 to numartsdivstep do
            begin
              lowpos := base+i*step;
              highpos := base+j*step;

              if highpos<=numarts then
                begin

                  if datesp^[dateptrs[lowpos]]>datesp^[dateptrs[highpos]] then
                    swapi(dateptrs[lowpos],dateptrs[highpos])
                  else
                    if
                     (datesp^[dateptrs[lowpos]]=datesp^[dateptrs[highpos]])
                      and
                     xfirstsubjg
                      (
                       canonfirstchars[dateptrs[lowpos]],
                       canonfirstchars[dateptrs[highpos]],
                       basesubjs[dateptrs[lowpos]],
                       basesubjs[dateptrs[highpos]]
                      )
                     then
                      swapi(dateptrs[lowpos],dateptrs[highpos]);

                end;
            end;

      step := step div 2;   {it's vital that 1 div 2=0 here}
    end;

{$endif}

  notquiets(':');

{$ifdef testsort}
  debugfn := '\debug.th';
  writeln('using ',debugfn);
  assign(debugf,debugfn);
  rewrite(debugf);
{$endif}

{$ifdef testsort}
writeln(debugf,'date ordering:');
for i := 1 to numarts do
  write(debugf,dateptrs[i]:5,' ');
writeln(debugf);
writeln(debugf,'filenames in date order:');
for i := 1 to numarts do
  write(debugf,filenamesp^[dateptrs[i]]:5,' ');
writeln(debugf);
writeln(debugf);
writeln(debugf);
{$endif}

  for i := 1 to numarts do
    subjptrs[i] := i;

{$ifdef bubble}

  for i := 1 to numarts-1 do
    begin
      notquiets('.');

      for j := i+1 to numarts do
        begin
          if xfirstsubjg
           (
            canonfirstchars[subjptrs[i]],
            canonfirstchars[subjptrs[j]],
            basesubjs[subjptrs[i]],
            basesubjs[subjptrs[j]]
           ) then
            swapi(subjptrs[i],subjptrs[j]);
        end;
    end;

{$else}

  step := 127;
  while step>0 do
    begin
      if not quiet then
        begin
          xwritei(step);
          xwrites('.');
        end;

      numartsdivstep := numarts div step;

      for base := 1 to step do
        for i := 0 to numartsdivstep do
          for j := i+1 to numartsdivstep do
            begin
              lowpos := base+i*step;
              highpos := base+j*step;

              if highpos<=numarts then
                if xfirstsubjg
                 (
                  canonfirstchars[subjptrs[lowpos]],
                  canonfirstchars[subjptrs[highpos]],
                  basesubjs[subjptrs[lowpos]],
                  basesubjs[subjptrs[highpos]]
                 ) then
                  swapi(subjptrs[lowpos],subjptrs[highpos]);
            end;

      step := step div 2;   {it's vital that 1 div 2=0 here}
    end;

{$endif}

  notquiets(':');

{$ifdef testsort}
writeln(debugf,'subject ordering:');
for i := 1 to numarts do
  write(debugf,subjptrs[i]:5,' ');
writeln(debugf);
writeln(debugf,'filenames in subject order');
for i := 1 to numarts do
  write(debugf,filenamesp^[subjptrs[i]]:5,' ');
writeln(debugf);
writeln(debugf);
writeln(debugf);
{$endif}

{sort via finalptrs indirection to prevent extra swapping}

{major sort: oldest article first, and all in its thread}

  dateptrsdone := 0;
  finalptrsdone := 0;
  while finalptrsdone<numarts do
    begin
      inc(dateptrsdone);

{skip over ones we've flagged as done}

      if dateptrs[dateptrsdone]>0 then
        begin

          notquiets('.');

{dateptrs[dateptrsdone] now points to oldest article not yet done}

          currsubj := basesubjs[dateptrs[dateptrsdone]];
          currcanonfirstchar := canonicalfirstchar(currsubj);

{and currsubj is its subject -- now find all that match it}

{$ifdef testsort}
          writeln(debugf,'(oldest) curr canon:subj=',
           currcanonfirstchar,':',currsubj);
{$endif}
          currsubjptr := 1;

          currart := 0;
          while currart<numarts do
            begin
              inc(currart);

{if <= currsubj, then set the pointer -- to the first that matches}
{since subjptrs is the sorted subjects, it must match}

{$ifdef testsort}
{$ifdef verbosetestsort}
              writeln(debugf,'currsubjptr--is it ',currart,'?  comparing:',
               copy(basesubjs[subjptrs[currart]],1,32),'...',
               right(basesubjs[subjptrs[currart]],8));
{$endif}
{$endif}

              if not xfirstsubjg
               (
                currcanonfirstchar,
                canonfirstchars[subjptrs[currart]],
                currsubj,
                basesubjs[subjptrs[currart]]
               ) then
                begin
                  currsubjptr := currart;
                  currart := numarts;
                end;
            end;

          finalstart := finalptrsdone+1;

          foundnewsubj := false;
          while (finalptrsdone<numarts) and not foundnewsubj do
            begin

{$ifdef testsort}
              if currsubjptr>numarts then
                writeln(debugf,'gone off the end!')
              else
                begin
                 if not subjseq(currsubj,basesubjs[subjptrs[currsubjptr]]) then
                  writeln(debugf,'method 1: found a new subject');
                 if not xsubjseq(currcanonfirstchar,
                  canonfirstchars[subjptrs[currsubjptr]],
                  currsubj,
                  basesubjs[subjptrs[currsubjptr]]) then
                   writeln(debugf,'method 2: found a new subject');
                 if xsubjseq(currcanonfirstchar,
                  canonfirstchars[subjptrs[currsubjptr]],
                  currsubj,
                  basesubjs[subjptrs[currsubjptr]]) then
                   begin
                     writeln(debugf,'found equal: 1=',
                      currcanonfirstchar,':',currsubj);
                     writeln(debugf,'             2=',
                      canonfirstchars[subjptrs[currsubjptr]],':',
                      basesubjs[subjptrs[currsubjptr]]);
                   end;
                end;
{$endif}

              if currsubjptr>numarts then
                foundnewsubj := true
              else if xsubjseq
               (
                currcanonfirstchar,
                canonfirstchars[subjptrs[currsubjptr]],
                currsubj,
                basesubjs[subjptrs[currsubjptr]]
               ) then
                begin
                  inc(finalptrsdone);
                  finalptrs[finalptrsdone] := subjptrs[currsubjptr];
                  inc(currsubjptr);

{$ifdef testsort}
                  writeln(debugf,'subject matches--add #',
                   finalptrsdone,' ',finalptrs[finalptrsdone],', fn ',
                   filenamesp^[finalptrs[finalptrsdone]]);
{$endif}

                end
              else
                foundnewsubj := true;
            end;

{$ifdef testsort}
writeln(debugf,'currsubj=',currsubj);
writeln(debugf,'this chain, pre-ordering:');
for i := finalstart to finalptrsdone do
  write(debugf,finalptrs[i]:5,' ');
writeln(debugf);
for i := finalstart to finalptrsdone do
  write(debugf,filenamesp^[finalptrs[i]]:5,' ');
{$endif}

          for i := finalstart to finalptrsdone-1 do
            for j := i+1 to finalptrsdone do
              if not firstartfirst(finalptrs[i],finalptrs[j]) then
                swapi(finalptrs[i],finalptrs[j]);

{$ifdef testsort}
writeln(debugf);
writeln(debugf,'this chain, post-ordering:');
for i := finalstart to finalptrsdone do
  write(debugf,finalptrs[i]:5,' ');
writeln(debugf);
for i := finalstart to finalptrsdone do
  write(debugf,filenamesp^[finalptrs[i]]:5,' ');
writeln(debugf);
writeln(debugf,'----------------');
writeln(debugf);
{$endif}

{
          notquiets('<');
}

          for i := 1 to numarts do
            if xsubjseq
             (
              currcanonfirstchar,
              canonfirstchars[dateptrs[i]],
              currsubj,
              basesubjs[dateptrs[i]]
             ) then
              dateptrs[i] := -dateptrs[i];

{
          notquiets('>');
}

        end;
    end;

{$ifdef testsort}
writeln(debugf,'the whole thing:');
for i := 1 to numarts do
  write(debugf,finalptrs[i]:5,' ');
writeln(debugf);
for i := 1 to numarts do
  write(debugf,filenamesp^[finalptrs[i]]:5,' ');
writeln(debugf);
writeln(debugf,'----------------');
writeln(debugf);
{$endif}

{$ifdef testsort}
  writeln('closing ',debugfn);
  close(debugf);
{$endif}

  for i := 1 to numarts do
    revfinalptrs[finalptrs[i]] := i;

  for i := 1 to numarts-1 do
    if finalptrs[i]<>i then
      begin
        swapart(i,finalptrs[i]);
        finalptrs[revfinalptrs[i]] := finalptrs[i];
        revfinalptrs[finalptrs[i]] := revfinalptrs[i];
        finalptrs[i] := i;
        revfinalptrs[i] := i;
      end;

end;

procedure readinarts;

const
  maxoverviewlines=4;

var
  dotnewsreadernamedot: string;
  highestseen: word;
  wroteanything: boolean;
  fileinfo: searchrec;
  iscaughtup: boolean;

  morearticles: boolean;

  subject: string;
  from: string;
  newsgroups: string;
  messageid: string;
  references: string;
  inreplyto: string;

  basefilename: string;
  filename: string;
  filenum: word;
  filesize: longint;

  datestr: string;
  mailgroup: boolean;
  bufferedkey: char;
  i: integer;
  workwithit: boolean;
  readnomore: boolean;
  highestfile: word;
  mangledsubject: string;
  waskilled: boolean;
  possgroup: string;
  upsearchtext: string;
  worthalook: boolean;
  catchupunreadlastpageignore: char;

  ignorestring: string;

  hasoverview: boolean;
  overviewf: text;

  overviewlines: array[1..maxoverviewlines] of string;

procedure readoverviewline;

var
  i: integer;

begin
  for i := 1 to maxoverviewlines do
    overviewlines[i] := '';

  for i := 1 to maxoverviewlines do
    begin
      if not eof(overviewf) and not eoln(overviewf) then
        read(overviewf,overviewlines[i]);
    end;

  if not eoln(overviewf) then
    xwritelns('overview information left over!');

  readln(overviewf);
end; {procedure readoverviewline}

function nextoverviewitem: string;

var
  result: string;
  ch: char;
  currline: integer;
  tabpos: integer;
  done: boolean;

begin
  result := '';

  currline := 1;

  done := false;

  while not done do
    begin
      if length(overviewlines[currline])=0 then
        inc(currline)
      else if currline>maxoverviewlines then
        done := true
      else
        begin
{$ifdef old}
          ch := overviewlines[currline][1];
          overviewlines[currline] := copy(overviewlines[currline],2,255);
          if ch=tab then
            done := true
          else
            result := result+ch;
{$endif}
          tabpos := pos(tab,overviewlines[currline]);
          if tabpos=0 then
            begin
              result := result+overviewlines[currline];
              overviewlines[currline] := '';
              inc(currline);
            end
          else
            begin
              result := result+copy(overviewlines[currline],1,tabpos-1);
              overviewlines[currline] :=
               copy(overviewlines[currline],tabpos+1,255);
              done := true;
            end;
        end;
    end;

  nextoverviewitem := result;
end; {function nextoverviewitem}

{getoverviewheader is _destructive_, alas}

{tag has to end with `:'}

function getoverviewheader(tag: string): string;

var
  result: string;
  foundheader: string;
  done: boolean;
  uptag: string;

begin
  result := '';

  done := false;
  uptag := upper(tag);

  while not done do
    begin
      foundheader := nextoverviewitem;

      if foundheader='' then
        done := true
      else if upper(copy(foundheader,1,length(tag)))=uptag then
        begin
          result := ltrim(copy(foundheader,length(tag)+1,255));
          done := true;
        end;
    end;

  getoverviewheader := result;
end;  {function getoverviewheader}

begin  {procedure readinarts}
  dotnewsreadernamedot := '.'+newsreadername+'.';

  unscannedarts := false;

  highestseen := 0;
  wroteanything := false;
  if startingart=impossibleart then
    begin
      if readpagesback<>0 then
        startingart := max(alreadyread-readpagesback*sellpp,0)
      else
        startingart := alreadyread;
    end;

  readpagesback := 0;
  nextwhilereading := false;
  readnomore := false;
  highestart := 0;
  highestfile := 0;

  bufferedkey := ' ';

  upsearchtext := upper(searchtext);

  mailgroup := ismailgroup(currgroup);

  if not mailgroup then
    if entergroupcommand<>'' then
      begin
        notquietlns('running '+entergroupcommand+' '+groupdir);
        execviacomspec(entergroupcommand+' '+groupdir);
        notquietlns('back from '+entergroupcommand);
      end;

  if mailagent and mailgroup then
    begin
      iscaughtup := true;

{note -- for mail groups, ignore the overview file}

      findfirst(groupdir+'\'+articlefilenamepattern,archive,fileinfo);
      while (doserror=0) and iscaughtup do
        begin
          filenum := atow(fileinfo.name);
          if (filenum>startingart) and isdigit(fileinfo.name[1]) then
            iscaughtup := false;
          findnext(fileinfo);
        end;

      if iscaughtup then
        begin
          warn2
           (
           'all mail from '+currgroup,
           'has been read.  the last page will be shown'
           );
          readpagesback := 1;
          startingart := max(alreadyread-readpagesback*sellpp,0)
        end;
    end;

  if mailgroup then
    readunfiltered := true;

  if not dexists(groupdir) then
    xwritelnsss('directory ',groupdir,' does not exist');

  hasoverview := false;

  if not mailgroup and (overviewbasename<>'') then
    begin
      safereset(overviewf,groupdir+'\'+overviewbasename);
      if fileresult=0 then
        begin
          hasoverview := true;
          notquietlns('(using overview file)');
        end;
    end;

  if hasoverview then
    begin
      morearticles := not eof(overviewf);
    end
  else
    begin
      findfirst(groupdir+'\'+articlefilenamepattern,archive,fileinfo);
      morearticles := (doserror=0);
    end;

  while morearticles and (numarts<maxarts) and not nextwhilereading and
   not readnomore do
    begin

      if xkeypressed then
        begin
          bufferedkey := xreadkey;
          if bufferedkey='N' then
            nextwhilereading := true
          else if bufferedkey='O' then
            readnomore := true
          else if (bufferedkey='!') and trusted then
            begin
              shellout;
            end
          else if bufferedkey='Q' then
            begin
{}{} {should it use confirmquit here?}
              nextwhilereading := true;
              alreadyingroup := true;
              currgroup := '';
            end;
        end;

      if hasoverview then
        readoverviewline;

      if hasoverview then
        basefilename := nextoverviewitem
      else
        basefilename := fileinfo.name;

      filenum := atow(basefilename);
      filename := groupdir+'\'+basefilename;

      if filenum>highestseen then
        highestseen := filenum;

      worthalook := false;

      if not nextwhilereading and not readnomore and
       (filenum>startingart) and isdigit(basefilename[1]) then
        worthalook := true;

      if worthalook and (searchinheaders or searchinbody) then
        begin

          worthalook := false;

          if searchinheaders then
            worthalook := searchart(filename,upsearchtext,yesheadersearch);

{don't search body unless not found in headers}
          if not worthalook and searchinbody then
            worthalook := searchart(filename,upsearchtext,noheadersearch);

{if not worthalook, then it was just searching that took it out}
          if not worthalook then
            begin
              wroteanything := true;

              if justdots then
                xwrites('.')
              else
                xwrites(basefilename);

              if not highlightsearchhits then
                xwrites('n');

              if not justdots then
                if wanderingnumbers then
                  xwrites(' ')
                else
                  xwritess('     ',^M);
            end;

        end;

      if worthalook then
        begin

          datestr := '(internal error)';
          messageid := '(internal error)';
          references := '(internal error)';

          if hasoverview then
            begin
              subject := nextoverviewitem;
              from := nextoverviewitem;
              datestr := nextoverviewitem;
              messageid := nextoverviewitem;
              references := nextoverviewitem;
              filesize := atol(nextoverviewitem);
              ignorestring := nextoverviewitem;  {lines}

              {
                get newsgroups if you can, but don't be drastic
                and go to disk and search the article itself unless necessary
              }

              newsgroups := getoverviewheader('newsgroups:');
              if (newsgroups='') and not readunfiltered then
                newsgroups := getheaderline(filename,'newsgroups:');
            end
          else
            begin
              subject := getheaderline(filename,'subject:');
              from := getheaderline(filename,'from:');
              newsgroups := getheaderline(filename,'newsgroups:');
              filesize := fileinfo.size;
            end;

{some people put tabs in the Subject: line!  ick!}

          subject := expand(subject);

          if highlightsearchhits then
            begin
              if searchinheaders or searchinbody then
                xhighvideo;
            end;

          if justdots then
            xwrites('.')
          else
            xwrites(basefilename);

          if highlightsearchhits then
            begin
              if searchinheaders or searchinbody then
                xlowvideo;
            end;

          wroteanything := true;

{if there's from and newsgroups, but no subject, keep it in search}

          if (subject='') and (from<>'') and (newsgroups<>'') then
            subject := 'No Subject - From '+from;

          if readunfiltered and (subject='') then
            subject := 'No Subject - From '+from;

          if (subject='') and missingsubjectisok then
            subject := 'No Subject - From '+from;

          waskilled := false;
          workwithit := true;

          if not readunfiltered then
            begin
              if subject='' then
                begin
                  workwithit := false;
                  xwrites('e');
                end
              else if alreadyseen(newsgroups) then
                begin
                  workwithit := false;
                  xwrites('s');
                end
              else
                begin
                  workwithit := not subjkilled(subject);
                  if workwithit then
                    workwithit := not fromkilled(from);
                  waskilled := not workwithit;
                  if waskilled then
                    xwrites('k');
                  if antikillevenkilled then
                    workwithit := true;
                end;
            end;

          if workwithit then
            begin
              inc(numarts);
              filenamesp^[numarts] := basefilename;

{ use mangledsubject instead of basesubjs[numarts] to prevent accidental }
{ thread separation when Re: makes it go beyond subjstringt length }

{ changed 'Re: ' to 'Re:' - a LOT of broken systems out there! }

              mangledsubject := subject;
              indents[numarts] := 0;
              while upper(copy(mangledsubject,1,3))='RE:' do
                begin
                  inc(indents[numarts]);
                  mangledsubject := ltrim(copy(mangledsubject,4,255));
                end;
              basesubjs[numarts] := mangledsubject;
              canonfirstchars[numarts] :=
               canonicalfirstchar(basesubjs[numarts]);

              fromsp^[numarts] := trim(ltrim(getfromname(from)));
              if fromsp^[numarts]='' then
                fromsp^[numarts] := getfromaddr(from)
              else if length(fromsp^[numarts])<=8 then
                fromsp^[numarts] := fromsp^[numarts]+', '+getfromaddr(from);

              if filesize>255*1024 then
                sizeink[numarts] := 255
              else
                sizeink[numarts] :=
                 longint(filesize+1023) div longint(1024);

              if not hasoverview then
                datestr := getheaderline(filename,'date:');

              datesp^[numarts] := stringtodate(datestr);

              if not hasoverview then
                messageid := getheaderline(filename,'message-id:');

              sethash(hmessageidsp^[numarts],messageid);

              if not hasoverview then
                references := getheaderline(filename,'references:');

{ Andrew system non-compliance, looks like }

              if not hasoverview then
                begin
                  inreplyto := getheaderline(filename,'in-reply-to:');
                  if pos('>',inreplyto)<>0 then
                    inreplyto := copy(inreplyto,1,pos('>',inreplyto));

{ needs to only grab up to the next > char}

                  if length(references)+length(inreplyto)<250 then
                    if copy(inreplyto,1,1)='<' then
                      if pos(inreplyto,references)=0 then
                        references := references+' '+inreplyto;
                end;

{ don't wipe out data with a 0 just because there's nothing in the header }
              if numoccur('<',references)>0 then
                indents[numarts] := numoccur('<',references);

              if not mailgroup then
                begin

{for use with auto-select key - start of antikill}
                  if antikillreferences then
                    if pos(fqdn,references)<>0 then
                      indents[numarts] := indents[numarts] or 128;

{for author's use to make sure everything's working}
                  if antikillthisnewsreader then
                    if pos(dotnewsreadernamedot,messageid)<>0 then
                      indents[numarts] := indents[numarts] or 128
                    else if pos(oldnewsreadername,messageid)<>0 then
                      indents[numarts] := indents[numarts] or 128;

                  if indents[numarts]<128 then
                    if subjantikilled(subject) then
                      indents[numarts] := indents[numarts] or 128
                    else if fromantikilled(from) then
                      indents[numarts] := indents[numarts] or 128;

                  if (indents[numarts] and 128)<>0 then
                    xwrites('a');

                end;

              if (indents[numarts]<128) and waskilled then
                begin
{if was killed, only antikilling can bring it back}
                  dec(numarts);
                end
              else
                begin
                  while numoccur('>',references)>4 do
                    ignorestring := chopfirstw(references);

                  sethash(hreferencesp[1]^[numarts],
                    chopfirstw(references));
                  sethash(hreferencesp[2]^[numarts],
                    chopfirstw(references));
                  sethash(hreferencesp[3]^[numarts],
                    chopfirstw(references));
                  sethash(hreferencesp[4]^[numarts],
                    chopfirstw(references));

                  if filenum>highestart then
                    highestart := filenum;
                end

            end;

          if not justdots then
            if wanderingnumbers then
              xwrites(' ')
            else
              xwritess('     ',^M);

          if not readnomore then
            if filenum>highestfile then
              highestfile := filenum;
        end;

      if hasoverview then
        begin
          morearticles := not eof(overviewf);
        end
      else
        begin
          findnext(fileinfo);
          morearticles := (doserror=0);
        end;
    end;

  readunfiltered := false;
  searchinheaders := false;
  searchinbody := false;
  startingart := impossibleart;

  if numarts=0 then
    begin
      if wroteanything then
        xwriteln;
      xwritelns('no new articles');
    end
  else if wanderingnumbers then
    xwriteln;

{if there's no files at ALL, that's close enough}

  if (highestseen<>0) and (highestseen<alreadyread) and
   not nextwhilereading and not readnomore then
    begin
      warn3
       (
       'there ARE articles for this group on disk, but none close to the',
       'entry in your join file.  you may want to check for re-sequenced',
       'or missing news files.'
       );

      catchupunreadlastpageignore := onekeydef(
       '<c>atch up, mark all as <u>nread, <l>ast page only, <i>gnore',
       'culi','i');

      if catchupunreadlastpageignore<>'i' then
        begin
          warn('can only ignore now, sorry');
        end;

    end;

{if all were read but filtered, show them as read to avoid scanning next time}

  if
   (
    checkdeletionsgroup<>''
   )
   or
   (
    (numarts=0) and
    not nextwhilereading and
    not readnomore and
    not searchinheaders and
    not searchinbody
   )
   then
    updatejoin(highestfile);

  if morearticles and (numarts=maxarts) then
    unscannedarts := true;

{handle 'G'oto while scanning already-read groups where O doesn't work}

  if xkeypressed then
    bufferedkey := xreadkey;

  if bufferedkey='G' then
    begin
      possgroup := '';
      pickagroup(possgroup);
      xclreolxy(1,lpp);
      if possgroup<>'' then
        begin
          nextwhilereading := true;
          currgroup := possgroup;
          alreadyingroup := true;
        end;
    end
  else if bufferedkey='Q' then
    begin
{}{} {should it use confirmquit here?}
      nextwhilereading := true;
      alreadyingroup := true;
      currgroup := '';
    end;

  if hasoverview then
    close(overviewf);

end;  {procedure readinarts}

procedure groupinit;

procedure groupinitkills;

var
  s: string;
  killgroup: string;
  inglobals: boolean;
  killline: integer;
  sizewarned: boolean;

function killeof: boolean;

begin
  if killfileinmem then
    killeof := (killline>=numkills)
  else
    killeof := eof(killf);
end;

function nextkillline: killstringt;

var
  s: string;

begin
  if killfileinmem then
    begin
      inc(killline);
      nextkillline := killtextp^[killline];
    end
  else
    begin
      readln(killf,s);
      nextkillline := s;
    end;
end;

begin

{read in kill file for this group}

  numsubjks := 0;
  numfromks := 0;
  nonglobalkills := false;

  killline := 0;
  inglobals := true;

  sizewarned := false;

  if haskillfile then
    begin
      if not killfileinmem then
        begin
          notquietlns('reading in kill file...');
          reset(killf);
        end;

{allow defaults to come before the first Newsgroups line}

      killgroup := currgroup;
      while not killeof do
        begin
          s := nextkillline;

{if it's a new Newsgroups: selection, then check it - otherwise, process}

          if (parseheadername(s)='Newsgroups') or (copy(s,1,1)=':') then
            begin
              killgroup := parseheadervalue(s);
              inglobals := false;
            end
          else if killgroup=currgroup then
            begin

              if showsubjectkills and showfromkills then
                xwritelnss('kill: ',s)
              else
                begin
                  if showsubjectkills then
                    if parseheadername(s)='Subject' then
                      xwritelnss('kill: ',s);
                  if showfromkills then
                    if parseheadername(s)='From' then
                      xwritelnss('kill: ',s);
                end;

              if parseheadername(s)='Subject' then
                begin
                  if numsubjks<maxkills then
                    begin
                      inc(numsubjks);
                      killsubjsp^[numsubjks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalkills := true;
                    end
                  else
                    begin
{}{} {too many subject kills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('kill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else if parseheadername(s)='From' then
                begin
                  if numfromks<maxkills then
                    begin
                      inc(numfromks);
                      killfromsp^[numfromks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalkills := true;
                    end
                  else
                    begin
{}{} {too many from kills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('kill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else
                begin
{}{} {invalid entry in kill file}
                  warn('unrecognizable entry in kill file');
                  warn(copy(s,1,40));
                end;
            end;
        end;
    end;
end;

procedure groupinitantikills;

var
  s: string;
  antikillgroup: string;
  inglobals: boolean;
  antikillline: integer;
  sizewarned: boolean;

function antikilleof: boolean;

begin
  if antikillfileinmem then
    antikilleof := (antikillline>=numantikills)
  else
    antikilleof := eof(antikillf);
end;

function nextantikillline: killstringt;

var
  s: string;

begin
  if antikillfileinmem then
    begin
      inc(antikillline);
      nextantikillline := antikilltextp^[antikillline];
    end
  else
    begin
      readln(antikillf,s);
      nextantikillline := s;
    end;
end;

begin

{read in antikill file for this group}

  numsubjaks := 0;
  numfromaks := 0;
  nonglobalantikills := false;

  antikillline := 0;
  inglobals := true;

  sizewarned := false;

  if hasantikillfile then
    begin
      if not antikillfileinmem then
        begin
          notquietlns('reading in antikill file...');
          reset(antikillf);
        end;

{allow defaults to come before the first Newsgroups line}

      antikillgroup := currgroup;
      while not antikilleof do
        begin
          s := nextantikillline;

{if it's a new Newsgroups: selection, then check it - otherwise, process}

          if (parseheadername(s)='Newsgroups') or (copy(s,1,1)=':') then
            begin
              antikillgroup := parseheadervalue(s);
              inglobals := false;
            end
          else if antikillgroup=currgroup then
            begin

              if showsubjectantikills and showfromantikills then
                xwritelnss('antikill: ',s)
              else
                begin
                  if showsubjectantikills then
                    if parseheadername(s)='Subject' then
                      xwritelnss('antikill: ',s);
                  if showfromantikills then
                    if parseheadername(s)='From' then
                      xwritelnss('antikill: ',s);
                end;

              if parseheadername(s)='Subject' then
                begin
                  if numsubjaks<maxkills then
                    begin
                      inc(numsubjaks);
                      antikillsubjsp^[numsubjaks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalantikills := true;
                    end
                  else
                    begin
{}{} {too many subject antikills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('antikill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else if parseheadername(s)='From' then
                begin
                  if numfromaks<maxkills then
                    begin
                      inc(numfromaks);
                      antikillfromsp^[numfromaks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalantikills := true;
                    end
                  else
                    begin
{}{} {too many from antikills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('antikill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else
                begin
{}{} {invalid entry in antikill file}
                  warn('unrecognizable entry in antikill file');
                  warn(copy(s,1,40));
                end;
            end;
        end;
    end;
end;

begin
  numarts := 0;
  headerinmem := '';
  highestread := 0;

  groupdir := getgroupdir(currgroup);
  if groupdir='' then
    begin
      if haltonunknowngroups then
        begin
          xwritelns('could not find /dir= entry for this group - location of');
          xwritelns('  news unknown.  make sure you are using the new DEFAULT');
          xwritelns('  lines instead of the old (v1.63 and lower) FORUM lines');
          xwriteln;
          xwritelns('also make sure you have not missed any forum sets if you');
          xwritelns('  used the -s or --forum-set-list options');
          shutdown(1);
        end
      else
        begin
          xwritelns('could not find directory for this group... continuing');
        end;
    end
  else
    begin
      notquietlnss('news directory=',groupdir);

      groupinitkills;
      groupinitantikills;
    end;
end;

procedure findhighest;

var
  s: string;

begin
  reset(joinf);
  alreadyread := impossibleart;
  while (alreadyread=impossibleart) and not eof(joinf) do
    begin
      readln(joinf,s);
      if getfirstw(s)=currgroup then
        alreadyread := getalreadyread(s);
    end;

{ only needed for initial single-group stuff }

  if alreadyread=impossibleart then
    begin
      xwritelnss('not joined to ',currgroup);
      shutdown(1);
    end;

{ end of only needed part }

end;

end.
