/*===========================================================================
SOLAR slrreply v0.94 :: Module list.c

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
06-29-93 KJH Creation of module to perform newsrc updates from LIST.
             LIST file for reply purposes contains format :
                group<tab>y|n
             Case is insignificant.
07-15-94 KJH Changed all printf() to fprintf()
===========================================================================*/

#include <stdio.h>
#include <dir.h>
#include <string.h>

#define LIST_NAME              "LIST"
#define YES 0
#define NO  1

extern char user_path[MAXPATH];             /* From slrreply.c */
extern char _slrerr[80];                    /* From slrreply.c */
extern int  use_wafjoin;                    /* From slrreply.c */

extern int join2newsrc();                   /* From join.c     */
extern int newsrc2join();                   /* From join.c     */

int add_to_newsrc(char *group);
int remove_from_newsrc(char *group);

/*
Function: int process_list()
Purpose : If packet has a LIST file, perform update of newsrc.
Return  : zero on success, non-zero on error and set _slrerr.
*/

int process_list()
{
  FILE *list_file = NULL;
  char listbuf[128];
  char groupname[80];
  struct ffblk ffblk;
  char *token;

  if (findfirst(LIST_NAME,&ffblk,0) != 0)
    goto GoodExit;

  if ((list_file = fopen(ffblk.ff_name,"rt")) == NULL)
  {
    sprintf(_slrerr,"error opening file %s",LIST_NAME);
    goto ErrorExit;
  }

  fprintf(stdout,"Processing %s file for subscription updates...\n\n",LIST_NAME);

  /* Check to see if we need to convert JOIN
     to NEWSRC.HPG first */

  if (use_wafjoin == YES)
  {
    /* Convert JOIN to NEWSRC.HPG. If it doesn't work,
       then assume there is no JOIN file */

    if (join2newsrc() != 0)
      fprintf(stdout,"process_list: %s",_slrerr);
  }

  while (fgets(listbuf,128,list_file) != NULL)
  {
    token = strtok(listbuf,"\t");
    if (!token)
      fprintf(stdout,"group name missing in line: \n  %s\n",listbuf);
    else
    {
      strcpy(groupname,token);

      token = strtok(NULL,"\t");
      if (!token)
        fprintf(stdout,"subscription flag missing in line:\n  %s\n",listbuf);
      else
      {
        if ((token[0] == 'y') || (token[0] == 'Y'))
        {
          if (add_to_newsrc(groupname) != 0)
            fprintf(stdout,"%s\n",_slrerr);
        }
        else
        {
          if ((token[0] == 'n') || (token[0] == 'N'))
          {
            if (remove_from_newsrc(groupname) != 0)
              fprintf(stdout,"%s\n",_slrerr);
          }
          else
          {
            fprintf(stdout,"subscription flag unknown in line:\n  %s\n",listbuf);
          }
        }
      }
    }
  }

GoodExit:
  if (use_wafjoin == YES)
  {
    /* Convert NEWSRC.HPG back to JOIN. If it doesn't work,
       then assume there is no NEWSRC.HPG file */

    if (newsrc2join() != 0)
      fprintf(stdout,"process_list: %s",_slrerr);
  }
  if (list_file) fclose(list_file);
  return 0;
ErrorExit:
  if (list_file) fclose(list_file);
  return 1;
}

/*
Function: int add_to_newsrc(char *group)
Purpose : Add a group to newsrc file if it doesn't already exist.
Return  : zero on success, non-zero on error and set _slrerr.
*/

int add_to_newsrc(char *group)
{
  FILE *newsrc_file = NULL;
  char newsrc_path[MAXPATH];
  char addbuf[128];

  strcpy(newsrc_path,user_path);
  strcat(newsrc_path,"\\NEWSRC.HPG");
  if ((newsrc_file = fopen(newsrc_path,"rt")) != NULL)
  {
    while (fgets(addbuf,128,newsrc_file) != NULL)
    {
      if (strnicmp(addbuf,group,strlen(group)) == 0)
        goto GoodExit;
    }
  }
  fclose(newsrc_file);

  if ((newsrc_file = fopen(newsrc_path,"at")) != NULL)
  {
    fprintf(newsrc_file,"%s:\n",group);
    fclose(newsrc_file);
    fprintf(stdout,"- Added group: %s\n",group);
  }
GoodExit:
  if (newsrc_file) fclose(newsrc_file);
  return 0;
BadExit:
  if (newsrc_file) fclose(newsrc_file);
  return 1;
}

/*
Function: int remove_from_newsrc(char *group)
Purpose : Remove a group from the newsrc file.
Return  : zero on success, non-zero on error.
*/
int remove_from_newsrc(char *group)
{
  FILE *newsrc_file = NULL;
  FILE *new_newsrc_file = NULL;
  char new_newsrc_path[MAXPATH];
  char newsrc_path[MAXPATH];
  char delbuf[128];

  strcpy(newsrc_path,user_path);
  strcpy(new_newsrc_path,user_path);
  strcat(newsrc_path,"\\NEWSRC.HPG");
  strcat(new_newsrc_path,"\\newsrc.new");

  if ((newsrc_file = fopen(newsrc_path,"rt")) != NULL)
  {
		if ((new_newsrc_file = fopen(new_newsrc_path,"wt")) == NULL)
    {
      sprintf(_slrerr,"error creating new NEWSRC file");
      goto ErrorExit;
    }
    while (fgets(delbuf,128,newsrc_file) != NULL)
    {
      if (strnicmp(delbuf,group,strlen(group)) != 0)
        fprintf(new_newsrc_file,"%s",delbuf);
    }
    fclose(new_newsrc_file);
    fclose(newsrc_file);
		unlink(newsrc_path);
		rename(new_newsrc_path,newsrc_path);
    fprintf(stdout,"- Removed group: %s\n",group);
  }
GoodExit:
  if (newsrc_file) fclose(newsrc_file);
  if (new_newsrc_file) fclose(new_newsrc_file);
  return 0;
ErrorExit:
  if (new_newsrc_file) fclose(new_newsrc_file);
  if (newsrc_file) fclose(newsrc_file);
  return 1;
}

