/*
Module::getopt.c
Purpose: Parse command line arguments.

Hacked from getopt.c from Borland International so that the switch
character is always '/'.
*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <dos.h>

int optind  = 1;  /* index of which argument is next  */
int opterr  = 1;  /* allow error message  */
char   *optarg;   /* pointer to argument of current option */

static	char   *letP = NULL;	/* remember next option char's location */
static  char  SW = '/';       /* DOS switch character, '/' only       */

int getopt(int argc, char *argv[], const char *optionS)
{
	unsigned char ch;
	char *optP;

	if (argc > optind) {
		if (letP == NULL) {
			if ((letP = argv[optind]) == NULL || 
				*(letP++) != SW)  goto gopEOF;
			if (*letP == SW) {
				optind++;  goto gopEOF;
			}
		}
		if (0 == (ch = *(letP++))) {
			optind++;  goto gopEOF;
		}
		if (':' == ch  ||  (optP = strchr(optionS, ch)) == NULL)  
			goto gopError;
		if (':' == *(++optP)) {
			optind++;
			if (0 == *letP) {
				if (argc <= optind)  goto  gopError;
				letP = argv[optind++];
			}
			optarg = letP;
			letP = NULL;
		} else {
			if (0 == *letP) {
				optind++;
				letP = NULL;
			}
			optarg = NULL;
		}
		return ch;
	}
gopEOF:
	optarg = letP = NULL;  
  return EOF;

gopError:
	optarg = NULL;
	errno  = EINVAL;
/*  if (opterr)
    fprintf(stdout,"Invalid argument on command line");
*/
	return ('?');
}

