/*===========================================================================
SOLAR v0.94 :: Module mail.c

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
05-03-93 KJH  Started history. Added screen output for message count.
06-12-93 KJH  Added code to process Waffle 1.64 mailbox files.
07-15-94 KJH  Changed all printf() to fprintf()
===========================================================================*/

/* Include Files */
#include <stdio.h>
#include <dir.h>
#include <string.h>

#define MAILBOX_DESC  "Electronic Mailbox"
#define MAILBOX_NAME "MAILBOX.F"    /* Complies with v1.65 of Waffle.  */
#define AREAS_NAME       "AREAS"    /* Complies with v1.1 of Helldiver */
#define BATCH_EXT          "MSG"    /* packet format.                  */
#define INDEX_EXT          "IDX"

#define YES                    0
#define NO                     1

enum Helldiver_Types { u, M, m, n, C, c };  /* Supported HDPF types */

/* External Data */
extern int  mail_message;           /* From solar.c    */
extern char temp_path[MAXPATH];     /* From solar.c    */
extern char user_path[MAXPATH];     /* From solar.c    */
extern char log_path[MAXPATH];      /* From solar.c    */
extern char _slrerr[80];            /* From solar.c    */
extern char batch_prefix[10];       /* From msg2hldr.c */
extern char waffle_version[5];			/* From solar.c 	 */

/* External Functions */
extern FILE *open_areas_file();     /* From msg2hldr.c */
extern FILE *open_batch_file();     /* From msg2hldr.c */
extern int  get_batch_prefix();     /* From msg2hldr.c */

/* Local Data */
char buf[1024];

/*
Function: long batch_mail(char username[9])
Purpose : Write user's mailbox to HDPF *.MSG file in temp_path
Return  : Number of mail messages written, -1 on error and set _slrerr.
*/

long batch_mail(char username[9])
{
  FILE *open_mail_file(char *mail_path);

  FILE *mail_file  = NULL;
  FILE *areas_file = NULL;
  FILE *batch_file = NULL;
	char buf[1024];
  char temp[10];
  char temp_mail_path[MAXPATH];
  int  index1 = 0, index2 = 0, x = 0, done;
  long mail_count = 0L;
  struct ffblk ffblk;

  if (strcmp(waffle_version,"1.64") == 0)
  {
    strcpy(temp_mail_path,user_path);
    strcat(temp_mail_path,"\\");
    strcat(temp_mail_path,username);
    strcat(temp_mail_path,".*");
  }
  else
  {
    strcpy(temp_mail_path,user_path);
    strcat(temp_mail_path,"\\");
    strcat(temp_mail_path,MAILBOX_NAME);
  }
	done = findfirst(temp_mail_path,&ffblk,0);
  if (done != 0)
  {
    fprintf(stdout,"No messages in mailbox\n");
    goto GoodExit;
	}
  else
  {
    buf[0] = '\0';
    ltoa(mail_count,temp,10);
    fprintf(stdout,"Packing mailbox :  ");
  }
  while (!done)
  {
    if ((mail_file = open_mail_file(ffblk.ff_name)) != NULL)
    {
      while ((fgets(buf,1024,mail_file)) != NULL)
      {
        /* There are mail messages in mailbox, so open batch file if needed */
        if (!batch_file)
        {
          if (get_batch_prefix() != 0) goto ErrorExit;
          if ((batch_file = open_batch_file()) == NULL) goto ErrorExit;
          if ((strcmp(waffle_version,"1.64") == 0) && (mail_message == M))
          {
            fprintf(batch_file,"\x01\x01\x01\x01");
          }
        }
        if (strcmp(waffle_version,"1.64") != 0)
        {
          /* Check for four CTRL-A's marking new message or end of file */
          if ((strncmp(buf,"\x01\x01\x01\x01",4)) == 0)
          {
            if (strlen(buf) == 4) /* terminating string in Waffle mail file */
            {
              /* write the terminating string if MMDF format and exit loop */
              if (mail_message == M) fprintf(batch_file,"%s\n",buf);
              break;
            }

            /* Update internal counter and on-screen counter */
            mail_count++;
            for (x = 0; x < strlen(temp); x++)
            {
              fprintf(stdout,"\b");
            }
            ltoa(mail_count,temp,10);
            fprintf(stdout,"%s",temp);

            /* If Unix-format mailbox, skip the leading CNTL-A's */
            if (mail_message == m)
            {
              index1 = 0;
              while (buf[index1] == '\x01') index1++;
              index2 = 0;
              while (buf[index1] != '\n')
              {
                buf[index2++] = buf[index1++];
              }
              buf[index2++] = '\n';
              buf[index2] = '\0';
            }
          }
        }
        fprintf(batch_file,"%s",buf);
      } /* while */
      fclose(mail_file);
      if (strcmp(waffle_version,"1.64") == 0)
      {
        if (mail_message == M) fprintf(batch_file,"\x01\x01\x01\x01");
        mail_count++;
        for (x = 0; x < strlen(temp); x++)
        {
          fprintf(stdout,"\b");
        }
        ltoa(mail_count,temp,10);
        fprintf(stdout,"%s",temp);
      }
    } /* if */
    done = findnext(&ffblk);
  } /* while */

  fclose(batch_file);

  fprintf(stdout," mail messages packed\n");

  /* Write info to index file if messages were found. Always write
     a mail index type of 'n', as no header files are produced for mail */

  if (mail_count > 0)
  {
    areas_file = open_areas_file();
    fprintf(areas_file,"%s\tmailbox\t",batch_prefix);
    switch (mail_message) {
      case m  : fprintf(areas_file, "m"); break;
      case M  : fprintf(areas_file, "M"); break;
    }
    fprintf(areas_file,"n\t%s\n",MAILBOX_DESC);
    fclose(areas_file);
  }

GoodExit:
  return mail_count;
ErrorExit:
  if (mail_file) fclose(mail_file);
  if (batch_file) fclose(batch_file);
	if (areas_file) fclose(areas_file);
  return -1L;
}

/*
Function: open_mail_file(char *mail_path)
Purpose : Open mail file in read/text mode.
Return  : NULL on error, pointer to file on success.
*/

FILE *open_mail_file(char *mail_path)
{
	FILE *file;

  char path[MAXPATH];

  strcpy(path,user_path);
  strcat(path,"\\");
  strcat(path,mail_path);

  file = fopen(path,"rt");
  return file;
}

