/*===========================================================================
SOLAR v0.94 :: Module messages.c

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
05-13-93 KJH  Started history.
05-26-93 KJH  Added code to build and update newsrc.hpg file.
06-25-93 KJH  Added trailing field to LIST file to indicate
              subscription status on group.
07-15-94 KJH  Changed all printf() to fprintf()
===========================================================================*/

/* Header Files */
#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define SOLAR_JOIN  "NEWSRC.HPG"
#define LIST_NAME         "LIST"
#define YES										 0
#define NO										 1

extern char _slrerr[80];                          /* From solar.c */
extern long news_total_messages;                  /* From solar.c */
extern long news_total_bytes;                     /* From solar.c */
extern int  time_left;                            /* From solar.c */
extern int  send_list;                            /* From solar.c */
extern char temp_path[MAXPATH];                   /* From solar.c */
extern char user_path[MAXPATH];                   /* From solar.c */

extern int  timechk(int min_left);                /* From timechk.c */
extern void write_description(FILE *areas_file);
extern void dump_join_to_new();

typedef struct forum_type {
	char forum_path[MAXPATH];
	struct forum_type *next;
} FORUM;
FORUM *forum;

char join_name[80];
long last_read;
long totbyte_count;

void *xmalloc(size_t size);
void remove_list();
int  create_list_file();
int  parse_join_entry(char *buf);

long batch_messages()
{
  FILE          *open_join_file();
  int           load_forums();
  int           read_join_file(FILE *join_file);
	int           set_news_path();
  int           build_newsrc();
  extern long   messages_to_helldiver();

  FILE *join_file = open_join_file();
  long message_count = 0L;
  long temp_count = 0L;
	int  status;

  if (load_forums() != 0) goto ErrorExit;
  if (!join_file)
  {
    switch (build_newsrc()) {
			case -1   : goto ErrorExit;
      case  0   : goto DoListFile;
      default   : if ((join_file = open_join_file()) == NULL)
                  {
                    goto ErrorExit;
                  }
                  break;
		}
  }

  totbyte_count = 0L;
  while ((status = read_join_file(join_file)) != 1)
  {
		if (timechk(time_left) != 0) goto ErrorExit;
    if (status != 2)   /* User is subscribed to area */
    {
      switch (set_news_path()) {
        case 1  : fprintf(stdout,"Newsgroup: %s - Not found... removing.\n",join_name);
                  break;
        case -1 : fprintf(stdout,"Newsgroup: %s - No messages... skipping.\n",join_name);
									dump_join_to_new();
                  break;
        case 0  : fprintf(stdout,"Newsgroup: %s ",join_name);
                  if ((temp_count = messages_to_helldiver()) < 0L)
                  {
                    goto ErrorExit;
									}
                  message_count += temp_count;
                  break;
        case -2 : goto ErrorExit;
        case  2 : fprintf(stdout,"Newsgroup: %s - Access denied... skipping.\n",join_name);
                  dump_join_to_new();
                  break;
			}
    }
    if (message_count > news_total_messages)
    {
      fprintf(stdout,"Exceeded maximum of %lu messages\n",news_total_messages);
      while ((status = read_join_file(join_file)) != 1)
			{
        if (status != 2)
        {
          dump_join_to_new();
        }
      }
      break;
		}
    if (totbyte_count > news_total_bytes)
    {
      fprintf(stdout,"Exceeded maximum of %lu bytes\n",news_total_bytes);
      while ((status = read_join_file(join_file)) != 1)
      {
				if (status != 2)
        {
          dump_join_to_new();
        }
      }
      break;
    }
	}
	fclose(join_file);

DoListFile:
  if (send_list == YES)
  {
		fprintf(stdout,"Creating message area list... ");
    if (create_list_file() != 0)
    {
      fprintf(stderr,"\n<solar> warning: %s\n",_slrerr);
    }
    else
    {
      fprintf(stdout," message areas listed\n");
    }
  }
  remove_list();
GoodExit:
  return message_count;
ErrorExit:
  if (forum) remove_list();
  if (join_file) fclose(join_file);
  return -1L;
}

/*
Function: open_join_file()
Purpose : Open SOLAR_JOIN in read/text mode.
Return  : Pointer to the SOLAR_JOIN file, exit on error.
*/

FILE *open_join_file()
{
  extern char user_path[MAXPATH];

  FILE *join_file;

	char join_path[MAXPATH];

	strcpy(join_path, user_path);
  strcat(join_path, "\\");
  strcat(join_path, SOLAR_JOIN);
  if ((join_file = fopen(join_path, "rt")) == NULL)
	{
    strcpy(_slrerr,"subscription file does not exist");
	}
	return join_file;
}

/*
Function: read_join_file()
Purpose : Read a line from the join file. Store the area name and
					last read message number in global variables. In number
          lists, use the last number to indicate the last read message
          number.
Return  : 1 on end of file, 0 on success, 2 to flag the area for no processing
*/

int read_join_file(FILE *join_file)
{
  extern FILE *open_new_join_file();

  FILE *new_join_file = NULL;
  char  buf[128];

	if (fgets(buf,80,join_file))
	{
    if (buf[0] == '!')
		{
			new_join_file = open_new_join_file();
      fprintf(new_join_file,"%s",buf);
			fclose(new_join_file);
      goto SkipExit;
    }
    if (parse_join_entry(buf) != 0) goto SkipExit;
  }
	else
	{
		goto EOFExit;
	}
GoodExit:
  return 0;
EOFExit:
  return 1;
SkipExit:
  return 2;
}

/*
Function: int parse_join_entry(char *buf)
Purpose : Parse join entry into join_name and last_read.
Return  : zero on success, non-zero on error.
*/

int parse_join_entry(char *buf)
{
  int   x = 0;
	char  *p = NULL;

  strcpy(join_name,"NONE");
  last_read = 0L;

  if (!(p = strtok(buf,":")))
  {
		fprintf(stderr,"Invalid join file format: %s\n",buf);
    goto ErrorExit;
  }
  if (p[0] == '!') x = 1;
  while ((p[x] != '\n') && (p[x] != '\0') && (p[x] != ':'))
  {
		if (p[0] == '!')
    {
      join_name[x - 1] = tolower(p[x]);
    }
    else
    {
      join_name[x] = tolower(p[x]);
		}
    x++;
  }
  if (p[0] == '!')
    join_name[x - 1] = '\0';
  else
		join_name[x] = '\0';

  if ((p = strtok(NULL,":")) == NULL)
  {
    last_read = 0L;
  }
  else
	{
    strcpy(buf,p);
    if (!(p = strtok(buf,"-")))
    {
      fprintf(stderr,"Invalid join number range format: %s\n",buf);
      goto ErrorExit;
		}
    /* Find the last number in the number list and store it */
    while ((p = strtok(NULL,"-")) != NULL)
    {
      last_read = atol(p);
    }
  }
GoodExit:
  return 0;
ErrorExit:
  return 1;
}

/*
Function: load_forums()
Purpose : Load the parameters from Waffle's static forums: line into
          a linked list on the heap. Store full paths to the forum files.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int load_forums()
{
  extern char static_path[MAXPATH];
  extern char system_path[MAXPATH];
  FILE *static_file = fopen(static_path,"rt");
  FORUM *current = NULL;

  int idx  = 0;
  int idx2 = 0;

  char buf[128];
  char buf2[MAXPATH];
  char *p = NULL;

	forum = NULL;

  if (!static_file)
  {
    sprintf(_slrerr,"error opening static file %s",static_path);
		goto ErrorExit;
  }

  buf2[0] = '\0';

  while (fgets(buf,128,static_file) != NULL)
	{
		if (strnicmp(buf,"forums",6) == 0)
		{
      while ((buf[idx] != ':') && (buf[idx] != '\n') && (buf[idx] != '\0'))
			{
        idx++;
			}
			idx++;
      while ((buf[idx] == ' ') && (buf[idx] != '\0') && (buf[idx] != '\n'))
			{
        idx++;
			}
      while ((buf[idx] != '\0') && (buf[idx] != '\n'))
			{
				if (((buf[idx] == ' ') && (buf2[idx] != ' ')) || (buf[idx] != ' '))
        {
          buf2[idx2++] = buf[idx];
				}
        idx++;
			}
			buf2[idx2] = '\0';

      if (strlen(buf2) > 0)
      {
        p = strtok(buf2," ");
				while (p != NULL)
				{
					if (forum == NULL)
          {
            forum = current = xmalloc(sizeof(FORUM));
            if (!forum) goto ErrorExit;
            forum->next = NULL;
					}
					else
					{
						current->next = xmalloc(sizeof(FORUM));
            if (!current->next) goto ErrorExit;
            current = current->next;
						current->next = NULL;
					}
					strcpy(current->forum_path,system_path);
          strcat(current->forum_path,"\\");
          strcat(current->forum_path,p);
					p = strtok(NULL," ");
				}
			}
		}
	}
  current = NULL;
GoodExit:
  return 0;
ErrorExit:
  if (static_file) fclose(static_file);
	return 1;
}

/*
Function: remove_list()
Purpose : Remove forums linked list from memory.
Return  : N/A
*/

void remove_list()
{
  FORUM *current = forum;

	while (current != NULL)
	{
    forum = current;
		current = current->next;
    free(forum);
	}
	forum = NULL;
  return;
}

/*
Function: int set_news_path()
Purpose : Sets current directory based on newsgroup name.
Return  : 0 on success
          1 if newsgroup is not in forum files
          2 if group is marked /nosolar in forum file
         -2 on error and set _slrerr.
*/

int set_news_path()
{
  FILE *open_forum_file(char path[MAXPATH]);
  char *name_to_path();
  char *get_dir_path(char *forum_line);
  int  set_directory(char path[MAXPATH]);

	FILE  *forum_file   = NULL;

  FORUM *current = forum;

  char  buf[128];
  char  news_path[MAXPATH];
	char  group_path[MAXPATH];
  char  work_path[MAXPATH];

  strcpy(group_path,"NONE");
  strcpy(news_path,"NONE");
  strcpy(work_path,"NONE");

	while ((current) && (strcmp(group_path,"NONE") == 0))
	{
    if ((forum_file = open_forum_file(current->forum_path)) == NULL)
    {
      goto ErrorExit;
    }
		while ((fgets(buf,128,forum_file)) && (strcmp(group_path,"NONE") == 0))
		{
			if (strnicmp(buf,join_name,strlen(join_name)) == 0)
      {
        if (strstr(buf,"/nosolar") != NULL) goto DenyExit;
        strcpy(group_path,get_dir_path(buf));
				if (strcmp(group_path,"NONE") == 0)
				{
					strcpy(group_path,name_to_path());
				}
			}
			if ((strnicmp(buf,"DEFAULT",7) == 0) || (strnicmp(buf,"FORUM",5) == 0))
			{
				strcpy(work_path,get_dir_path(buf));
				if (strcmp(work_path,"NONE") != 0)
				{
					strcpy(news_path,work_path);
				}
			}
		}
		fclose(forum_file);
		current = current->next;
	}
	current = NULL;

	if (strcmp(news_path,"NONE") == 0)
	{
    strcpy(_slrerr,"forum file has no /DIR= parameter");
    goto ErrorExit;
  }
  if (strcmp(group_path,"NONE") == 0)
  {
    goto InvalidExit;
	}
  else
  {
		strcat(news_path,group_path);
  }
GoodExit:
	return(set_directory(news_path));
InvalidExit:
  return 1;
ErrorExit:
  if (forum_file) fclose(forum_file);
  return -2;
DenyExit:
	if (forum_file) fclose(forum_file);
  return 2;
}

/*
Function: FILE *open_forum_file(char path[MAXPATH])
Purpose : Open file. Not sure why this is a function.
Return  : Pointer to file, NULL and set _slrerr on fail.
*/

FILE *open_forum_file(char path[MAXPATH])
{
  FILE *filep    = NULL;

  if (!(filep = fopen(path, "rt")))
	{
    sprintf(_slrerr,"error opening forum file %s",path);
	}
	return filep;
}

/*
Function: char *name_to_path()
Purpose : Convert Usenet-format newsgroup name to a disk path.
Return  : Disk path, or NULL and set _slrerr on error.
*/

char *name_to_path()
{
  static char  path[MAXPATH];
  char  name[80];
  int   idx    = 0;
	char  *token;

  strcpy(name,join_name);
  strcpy(path,"NONE");

	if ((token = strtok(name,".")) != NULL)
  {
		strcpy(path,"\\");
  }
	else
  {
    return path;
  }
	while (token != NULL)
  {
    if (strlen(token) > 8)
    {
			for (idx = 0; idx < 8; idx++)
			{
		    token[idx] = token[idx];
			}
      token[idx] = '\0';
		}
		strcat(path, token);
		if ((token = strtok(NULL,".")) != NULL)
    {
			strcat(path,"\\");
    }
	}
  return path;
}

/*
Function: *get_dir_path(char *forum_line)
Purpose : Get the path from /DIR= parameter in FORUM or DEFAULT
          line, if present. Handles with or without quotes.
Return  : Path value, or NONE if not found.
*/

char *get_dir_path(char *forum_line)
{
  static char  path[MAXPATH];
	int   idx    = 0;
	int   idx2   = 0;
	char  *token;

	strcpy(path,"NONE");
  strupr(forum_line);
  if ((token = strstr(forum_line,"/DIR=")) != NULL)
	{
		while (token[idx++] != '=');
		while ((token[idx] != ' ') && (token[idx] != '\0') && (token[idx] != '\n'))
		{
			if (token[idx] != '\"') path[idx2++] = token[idx];
			idx++;
		}
		path[idx2] = '\0';
  }
  return path;
}

/*
Function: int set_directory(char path[MAXPATH])
Purpose : Accept d:\directory\subdirs arg and do a chdir
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int set_directory(char path[MAXPATH])
{
  char disk_drive = path[0];
  char new_path[MAXPATH];
  int disknum = 0;
	int x = 0;

  disk_drive = toupper(disk_drive);
	disknum = disk_drive - 65;
	if ((disknum >= 0) && (disknum <=25))
	{
		setdisk(disknum);
	}
	else
	{
    sprintf(_slrerr,"invalid disk for directory: %c",disk_drive);
    goto ErrorExit;
	}

  new_path[0] = '\0';
	for (x = 2; x < strlen(path); x++)
	{
		new_path[x - 2] = path[x];
	}
	new_path[x - 2] = '\0';
	if (chdir(new_path) != 0)
	{
		sprintf(_slrerr,"error changing to directory %s",new_path);
		goto ErrorExit;
	}
GoodExit:
	return 0;
ErrorExit:
	return -1;
}

void *xmalloc(size_t size)
{
  void *q = NULL;

	if ((q = malloc(size)) == NULL)
	{
    strcpy(_slrerr,"not enough memory");
	}
	return(q);
}

/*
Function: int create_list_file()
Purpose : Create LIST file containing all message areas.
Return  : zero on success, non-zero on error and set _slrerr.
*/

int create_list_file()
{
  extern char join_name[80];

	FILE *open_forum_file(char path[MAXPATH]);
	int list_vs_newsrc(char *groupname);

  FILE *list_file = NULL;
  FILE *forum_file = NULL;

  char listbuf[128];
	char list_path[MAXPATH];
  int x = 0, area_count = 0;
  char temp[8];
  FORUM *current = forum;

  strcpy(list_path,temp_path);
  strcat(list_path,"\\");
  strcat(list_path,LIST_NAME);
	if ((list_file = fopen(list_path,"wt")) == NULL)
  {
    sprintf(_slrerr,"error opening %s for write",list_path);
    goto ErrorExit;
  }
  ltoa(area_count,temp,10);
  while (current)
	{
    if ((forum_file = open_forum_file(current->forum_path)) == NULL)
    {
      goto ErrorExit;
    }
    while (fgets(listbuf,128,forum_file) != NULL)
    {
			if ((strnicmp(listbuf,"DEFAULT",7) != 0) &&
          (strnicmp(listbuf,"FORUM",5) != 0) &&
          (strnicmp(listbuf,"#",1) != 0) &&
          (listbuf[0] != '\n') &&
					(strstr(listbuf,"/nosolar") == NULL))
      {
				x = 0;
        while ((listbuf[x] != ' ') && (listbuf[x] != '\n'))
        {
          join_name[x] = listbuf[x];
          x++;
        }
        join_name[x] = '\0';
        fprintf(list_file,"%s\tu\t",join_name);
        write_description(list_file);
        if (list_vs_newsrc(join_name) == 0)
          fprintf(list_file,"\ty");
        else
          fprintf(list_file,"\tn");
        fprintf(list_file,"\n");

        area_count++;
        for (x = 0; x < strlen(temp); x++)
        {
          fprintf(stdout,"\b");
        }
        ltoa(area_count,temp,10);
        fprintf(stdout,"%s",temp);
      }
    }
    fclose(forum_file);
		current = current->next;
  }
  fclose(list_file);
  current = NULL;

GoodExit:
  return 0;
ErrorExit:
  if (current) current = NULL;
  if (forum_file) fclose(forum_file);
  if (list_file) fclose(list_file);
  return 1;
}

/*
Function: int build_newsrc()
Purpose : Build or modify NEWSRC.HPG subscription file.
Return  : number of groups subscribed, -1 on error and set _slrerr.
*/

int build_newsrc()
{
	FILE *open_forum_file(char path[MAXPATH]);
	int  get_option(char *groupname, long high_msg, int defval);

	FILE *old_newsrc_file = NULL;
	FILE *new_newsrc_file = NULL;
	FILE *newsrc_file     = NULL;
	FILE *forum_file  = NULL;
	int  x = 0;
	int  sub_count = 0;
	int  kill_list   = YES;
	int	 subscribed  = NO;
	long high_msgno  = 0L;
	long low_msgno   = 0L;
	char option;
  char search_string[80];
  char old_newsrc_path[MAXPATH];
  char new_newsrc_path[MAXPATH];
	char newsrc_path[MAXPATH];
  char forumbuf[128];
  char newsrcbuf[128];
  FORUM *current = NULL;

	/* This function can be called with or without the forum files */
  /* loaded in a linked list. Check for the list, and load it if */
  /* not already loaded. If the list is loaded here, remember to */
  /* kill the list when exiting the function.                    */

  kill_list = NO;
  if (!forum)
  {
		if (load_forums() != 0) goto ErrorExit;
    kill_list = YES;
  }

  /* Build paths to various NEWSRC files */

  strcpy(old_newsrc_path,user_path);
  strcat(old_newsrc_path,"\\NEWSRC.OLD");
  strcpy(new_newsrc_path,user_path);
  strcat(new_newsrc_path,"\\NEWSRC.NEW");
  strcpy(newsrc_path,user_path);
  strcat(newsrc_path,"\\NEWSRC.HPG");

  /* Check for existing NEWSRC.HPG file. If found, process */
  /* the subscribed groups first giving NEWSRC.OLD         */

  if ((newsrc_file = fopen(newsrc_path,"rt")) != NULL)
  {
		if ((old_newsrc_file = fopen(old_newsrc_path,"wt")) == NULL)
    {
      sprintf(_slrerr,"error opening %s for write",old_newsrc_path);
      goto ErrorExit;
    }
    fprintf(stdout,"\nProcessing current subscription list:\n\n");
    while (fgets(newsrcbuf,128,newsrc_file) != NULL)
    {
      if (parse_join_entry(newsrcbuf) != 0)
      {
        fprintf(stdout,"<solar> warning: %s\n",_slrerr);
        fprintf(stdout,"%s dropped from newsrc file\n",newsrcbuf);
      }
			else
      {
        switch (set_news_path()) {
          case  1 : fprintf(stdout,"Group: %s - Not valid... unsubscribing.\n",join_name);
                    break;
					case -2 : goto ErrorExit;
					case  2 : fprintf(stdout,"Group: %s - Access denied... unsubscribing.\n",join_name);
										break;
					default : high_msgno = high_fileno();
										low_msgno = low_fileno();
                    if (low_msgno > last_read)
                    {
                      last_read = low_msgno;
                    }
                    if (high_msgno < last_read)
                    {
                      last_read = high_msgno;
                    }
                    option = get_option(join_name,high_msgno,YES);
                    if ((option == 'Y') || (option == 'y'))
										{
											fprintf(old_newsrc_file,"%s: 1-%lu\n",join_name,last_read);
											sub_count++;
										}
										if ((option == 'q') || (option == 'Q'))
										{
											goto NoUpdateExit;
										}
										if ((option == 'e') || (option == 'E'))
										{
											goto UpdateExit;
										}
										if ((option == 'c') || (option == 'C'))
										{
											fprintf(old_newsrc_file,"%s: 1-%lu\n",join_name,high_msgno);
											sub_count++;
										}
										if ((option == 'n') || (option == 'N'))
										{
                      if (last_read > 0L)
                      {
                        fprintf(old_newsrc_file,"!%s: 1-%lu\n",join_name,last_read);
                      }
                      else
                      {
                        fprintf(old_newsrc_file,"!%s:\n",join_name);
                      }
                      sub_count++;
										}
				}
			}
		}
		fclose(old_newsrc_file);
		fclose(newsrc_file);
		if (sub_count == 0) unlink(old_newsrc_path);
	}

  /* Now process all entries in each forum file. Do not inquire again */
  /* on groups in NEWSRC.OLD, if it exists, just copy them over into  */
  /* NEWSRC.NEW. No need to be reduntant.                             */

  fprintf(stdout,"\nProcessing all unsubscribed groups\n\n");
  if ((new_newsrc_file = fopen(new_newsrc_path,"wt")) == NULL)
  {
    sprintf(_slrerr,"error opening %s for write\n",newsrc_path);
    goto ErrorExit;
  }
  old_newsrc_file = fopen(old_newsrc_path,"rt");

  current = forum;
	while (current)
  {
    if ((forum_file = open_forum_file(current->forum_path)) == NULL)
    {
      goto ErrorExit;
    }
    while (fgets(forumbuf,128,forum_file) != NULL)
    {
			if ((strnicmp(forumbuf,"DEFAULT",6) != 0) &&
          (strnicmp(forumbuf,"FORUM",5) != 0)   &&
          (forumbuf[0] != '\n') && (forumbuf[0] != '#') &&
          (forumbuf[0] != ' ')  &&
          (strstr(forumbuf,"/nosolar") == NULL))
			{
        x = 0;
        while ((forumbuf[x] != ' ') && (forumbuf[x] != '\n')) x++;
        forumbuf[x] = '\0';
        subscribed = NO;
        if (old_newsrc_file)
        {
          while (fgets(newsrcbuf,128,old_newsrc_file) != NULL)
          {
            if (newsrcbuf[0] == '!')
            {
              x = 1;
              while ((newsrcbuf[x] != '\0') && (newsrcbuf[x] != '\n'))
							{
                newsrcbuf[x - 1] = newsrcbuf[x];
                x++;
              }
              newsrcbuf[x - 1] = '\0';
            }
            if (strnicmp(forumbuf,newsrcbuf,strlen(forumbuf)) == 0)
            {
              subscribed = YES;
              break;
            }
          }
					fseek(old_newsrc_file,SEEK_SET,0L);
				}
GetOption:
				if (subscribed == NO)
				{
					option = get_option(forumbuf,0L,NO);
          if ((option == 'Y') || (option == 'y'))
					{
            fprintf(new_newsrc_file,"%s:\n",forumbuf);
						sub_count++;
					}
					if ((option == 'q') || (option == 'Q'))
					{
						goto NoUpdateExit;
          }
					if ((option == 'e') || (option == 'E'))
          {
            goto UpdateExit;
          }
				}
      }
    }
    fclose(forum_file);
    current = current->next;
  }
UpdateExit:
  if (forum_file) fclose(forum_file);
	if ((forum) && (kill_list == YES)) remove_list();
  fclose(new_newsrc_file);
  if (old_newsrc_file) fclose(old_newsrc_file);
  if (sub_count > 0)
  {
    unlink(newsrc_path);
    rename(old_newsrc_path,newsrc_path);
    unlink(old_newsrc_path);
    if ((new_newsrc_file = fopen(new_newsrc_path,"rt")) != NULL)
    {
      if ((newsrc_file = fopen(newsrc_path,"at")) == NULL)
      {
        sprintf(_slrerr,"error creating subscription file");
        goto ErrorExit;
      }
      while (fgets(newsrcbuf,128,new_newsrc_file) != NULL)
      {
        fprintf(newsrc_file,"%s",newsrcbuf);
      }
      fclose(new_newsrc_file);
			unlink(new_newsrc_path);
      fclose(newsrc_file);
    }
    fprintf(stdout,"Subscription file updated\n");
  }
  else
  {
    unlink(new_newsrc_path);
    fprintf(stdout,"No changes made to subscription file\n");
	}
  current = NULL;
  return sub_count;
NoUpdateExit:
  if (forum_file) fclose(forum_file);
	if ((forum) && (kill_list == YES)) remove_list();
  fclose(new_newsrc_file);
	unlink(new_newsrc_path);
  if (old_newsrc_file)
  {
    fclose(old_newsrc_file);
    unlink(old_newsrc_path);
  }
	fprintf(stdout,"No changes made to subscription file\n");
  return 0;
ErrorExit:
  current = NULL;
  if (forum_file) fclose(forum_file);
	if ((forum) && (kill_list == YES)) remove_list();
	if (new_newsrc_file) fclose(new_newsrc_file);
	if (old_newsrc_file) fclose(old_newsrc_file);
  return -1;
}

int get_option(char *groupname, long high_msg, int defval)
{
	static char choice;
  int valid_choice = NO;

  valid_choice = NO;
  while (valid_choice == NO)
  {
    fprintf(stdout,"Group: %s : ",groupname);
		if (defval == YES)
      fprintf(stdout,"<%lu new> (Y,n,k,c,e,q,?) : ",high_msg - last_read);
    else
      fprintf(stdout,"(y,N,e,q,?) : ");
    choice = getche();
    fprintf(stdout,"\n");
    if ((choice == 'q') || (choice == 'Q') ||
        (choice == 'y') || (choice == 'Y') ||
        (choice == 'n') || (choice == 'N') ||
        (choice == 'e') || (choice == 'E'))
    {
			valid_choice = YES;
    }
    else
    {
      if (choice == '\x0D')
      {
				if (defval == YES)
        {
          choice = 'Y';
          valid_choice = YES;
        }
				if (defval == NO)
        {
          choice = 'N';
          valid_choice = YES;
        }
      }
      else
      {
				if (defval == YES)
        {
          if ((choice == 'c') || (choice == 'C'))
            valid_choice = YES;
          if ((choice == 'k') || (choice == 'K'))
            valid_choice = YES;
        }
      }
    }
    if (valid_choice == NO)
    {
      fprintf(stdout,"\nY = Yes, subscribe to group\n");
			if (defval == YES)
      {
        fprintf(stdout,"N = No, don't resubscribe to group\n");
        fprintf(stdout,"K = Kill group from subscription file\n");
        fprintf(stdout,"C = Catch up on all messages in group\n");
      }
      else
      {
        fprintf(stdout,"N = No, don't subscribe to group\n");
      }
      fprintf(stdout,"E = End, save groups subscribed so far\n");
      fprintf(stdout,"Q = Quit, make no changes to subscription\n\n");
    }
  }
  return choice;
}

/*
Function: int list_vs_newsrc(char *groupname);
Purpose : Compare group name against entries in subscription file.
Return  : zero if group is subscribed, non-zero if not.
*/

int list_vs_newsrc(char *groupname)
{
  FILE *newsrc_file = NULL;
  char newsrc_path[MAXPATH];
  char compbuf[80];

  strcpy(newsrc_path,user_path);
  strcat(newsrc_path,"\\NEWSRC.HPG");

  if ((newsrc_file = fopen(newsrc_path,"rt")) == NULL)
    goto NotFoundExit;

  while (fgets(compbuf,80,newsrc_file) != NULL)
  {
    if (strnicmp(compbuf,groupname,strlen(groupname)) == 0)
      goto FoundExit;
  }

NotFoundExit:
  if (newsrc_file) fclose(newsrc_file);
  return 1;
FoundExit:
  if (newsrc_file) fclose(newsrc_file);
  return 0;
}
