@echo off
rem PSWPG - use pbmplus package to create a Word Perfect graphics file
rem with a postscript image and a TIF preview image.

rem Written by Robert W. Babcock.  Last revision: 10/12/93

rem MAKEWPG and this BAT file were developed while the author was supported
rem by various NASA and Smithsonian grants.  They are not subject to copyright.

rem programs required: get, ghost, ppmmerge, pnmmerge, makewpg

rem ***** User configuration section *****

	set ghostpath=c:\utility\ghost
	set pbmpath=c:\cad\graphics\pbmplus\bin
	set makewpgpath=c:\compiler\mysource
	set pbmtemp=d:\tmp
	set tmpdrive=d

rem **************************************

rem Portable BitMap programs come from unix, and expect to be called through
rem symbolic links where the program name specifies the desired function.
rem This doesn't work under DOS, so programs must be renamed or copied with
rem alternate names.

rem Files created
rem	$$.pcx - Ghostscript output, full page size
rem	$$.pbm - Portable Bit Map, full page
rem	$$.pb2 - Cropped
rem	$$.pb3 - Bilevel
rem	$$.tif - TIFF preview image

if "%2" == "" goto Usage
if "%PBMTEMP" == "" goto Usage
set savepbm=NO
if NOT %1 == -s goto DontSave
	set savepbm=YES
	shift
:DontSave
	set cutprog=pnmcrop
	set cutargs=

if NOT %1 == -c goto AutoCrop
	shift
	set cutprog=pnmcut
	set cutargs=%1 %2 %3 %4
	shift
	shift
	shift
	shift

:AutoCrop

rem Record the starting drive and path so we can switch back latter.  PBMPLUS
rem programs get confused if they are invoked with a complete path name, so
rem they must either be on the path or in the current directory.  Since they
rem must also be copied or renamed so that their name indicates their function,
rem this is done in a scratch directory.

	get YE
	set drive=%GET%
	get Y
	set startdir=%GET%
	set sourcedir=%GET%
	if "%SOURCEDIR%" == "\" set sourcedir=
	%TMPDRIVE%:
	cd %PBMTEMP%

rem First, Ghostscript makes a PCX file
	echo calling ghostscript to create intermediate PCX file
	echo -dNOPAUSE -sDEVICE=pcx16 -sOutputFile=%PBMTEMP%\$$.pcx >%PBMTEMP%\$$.$$$ -I%GHOSTPATH%\
	%GHOSTPATH%\gs @%PBMTEMP%\$$.$$$ %DRIVE%:%SOURCEDIR%\%1 quit.ps
	erase %PBMTEMP%\$$.$$$

rem PCXTOPPM makes a portable bitmap file
	echo calling PCXTOPPM to create intermediate PPM file
	copy %PBMPATH%\ppmmerge.exe %PBMTEMP%\pcxtoppm.exe
	pcxtoppm %PBMTEMP%\$$.pcx >%PBMTEMP%\$$.pbm
	erase %PBMTEMP%\pcxtoppm.exe
	if %SAVEPBM% == NO erase %PBMTEMP%\$$.pcx

rem PNMCROP or PMNCUT crops off the whitespace added by Ghostscript
	echo calling %CUTPROG% to trim excess whitespace
	copy %PBMPATH%\pnmmerge.exe %PBMTEMP%\%CUTPROG%.exe
	%CUTPROG% %CUTARGS% %PBMTEMP%\$$.pbm >%PBMTEMP%\$$.pb2
	if %SAVEPBM% == NO erase %PBMTEMP%\$$.pbm

rem PNMDEPTH converts to bilevel
	echo calling PNMDEPTH to convert to bilevel
	rename %CUTPROG%.exe pnmdepth.exe
	pnmdepth 1 %PBMTEMP%\$$.pb2 >%PBMTEMP%\$$.pb3
	if %SAVEPBM% == NO erase %PBMTEMP%\$$.pb2

rem PNMTOTIF makes a TIF file
	echo calling PNMTOTIF to create preview image
	rename %pnmdepth.exe pnmtotif.exe
	pnmtotif -packbits %PBMTEMP%\$$.pb3 >%PBMTEMP%\$$.tif
	erase %PBMTEMP%\pnmtotif.exe

rem MAKEWPG combines the postscript and TIF files
	echo calling MAKEWPG to combine postscript and preview images
	%DRIVE%:
	cd %STARTDIR%
	%MAKEWPGPATH%\makewpg %DRIVE%:%SOURCEDIR%\%1 %PBMTEMP%\$$.tif %2
	if %SAVEPBM% == NO erase %PBMTEMP%\$$.tif

goto Done

:Usage
	echo usage: makewpg  [-s]  [-c x y w h]  postscript_file  WP_file
	echo   normally WP file should be given .EPF extension
	echo   Environment variable PBMTEMP must be defined.  It is used as location for
	echo   scratch files.  Do not include a trailing backslash in the definition.
	echo   Optional -s means save the intermediate files (mostly for debugging)
	echo   Optional x y w h are x/y and width/height to crop intermediate PCX file

:Done
rem clean up environment
	set ghostpath=
	set pbmpath=
	set makewpgpath=
	set pbmtemp=
	set tmpdrive=
	set get=
