#============================================================================
#
#       INPORT Demo Program for XA 
#
#       This command file shows you how to react to input 
#       from the Game Adapter (Joystick Port). 
#       NOTE: Certain functions require Registered version XA 2.x 
#
#       The current switch status of the joystick may be obtained by 
#       reading in the data from port address 201H (hexadecimal).  This 
#       status is then stored in the variable "GAME".
#               GAME = INPORT 201H
#
#       The status of Button A is located in Bit 5 of GAME. If the bit is
#       a '0', then the button is currently pressed. Otherwise, if the bit
#       is '1', then button is released. The status of Button B is located 
#       in Bit 4 of GAME. To determine the individual state of each button,
#       each bit must be "masked", or isolated. A mask of 32 (Hex 20) is 
#       applied (bit-wise AND, the "&" operator) for Button A. A mask of
#       16 (Hex 10) is applied for Button B.
#
#       To reduce the number of CP-290 transmissions, another variable
#       "MODULE" is assigned a value of the current state of the controlled
#       module. This will prevent redundant transmissions.
#
#       In order to make this loop as efficient as possible, the statement
#       "DISPLAY OFF" is used. 
#
#       Note that this file is in fact EXECUTING...
#
#

DECLARE VAR MODULE = OFF             # Intialize state to Off
DECLARE VAR GAME
DISPLAY OFF                          # Turn display off to speed execution

:LOOP                                # This is the beginning of the loop
GAME = INPORT 201H                   # Read the joystick port
IF !(GAME & 20H)                     # Check Button A
  IF (MODULE == OFF)                 # If module is currently Off...
    DISPLAY ON                       # (turn display on so we can see cmd)
    c2 on                            # ...Turn module On
    DISPLAY OFF
    MODULE = ON                      # ...update status of module to On
    # DOS c:\sblaster\vplay c:\sblaster\yr.voc    # Make SoundBlaster talk
  ENDIF
ENDIF

# Check Button B
IF !(GAME & 10H)                     # Check Button B
  IF (MODULE == ON)                  # If module is currently On...
    DISPLAY ON                       # (turn display on so we can see cmd)
    C2 off                           # ...Turn module Off
    DISPLAY OFF
    MODULE = OFF                     # ...update its status too
    # DOS c:\sblaster\vplay c:\sblaster\witch.voc
  ENDIF
ENDIF

GOTO LOOP                            # Keep repeating loop until <ESC> pressed.

:EXIT                                # Special label to search for when <ESC>.
DISPLAY ON
C2 OFF                               # Put module back into a known state.
