
#include "stdio.h"
#include "ctype.h"
#include "dos.h"

/* #define LOCAL */

union REGS rrv,srv;


main()
{
	int c;
	
	while(carrier()) {
		c=fgetc(stdin);
		if(c==EOF)
			exit(0);
		putchr(c);
		c=getchr();
		if(c==19)
			wtchr();
		if(c==3 || c==24 || c==11)
			exit(1);
	}
	exit(2);
}

/* send character c to modem and screen */
putchr(c)
{
	fputc(c,stderr);
	while(!moready() && carrier())
		;
	mochar(c);
	if(c=='\n') {
		while(!moready() && carrier())
			;
		mochar('\r');
	}
}


getchr()
{
	int c;

	if(c=inkey())
		return(c);
	if(miready())
		return(michar());
	return(NULL);
}


/* wait for a character from console or modem */
wtchr()
{
	int c;

	while((c=getchr())==NULL)
		;
	return(c);
}


/* returns non 0 iff a modem character ready */
miready()
{
#ifdef LOCAL
	return(0);
#endif

	srv.x.ax = 0x0300;
	int86(0x14, &srv, &rrv);
	return (rrv.x.ax & 0x100);
}

/* input a character from modem assuming miready returns 1 */
michar()
{
	srv.x.ax = 0x0200;
	int86(0x14, &srv, &rrv);
	return (rrv.x.ax & 0xff);
}

carrier()		/* only tests COM1 -- change 0x3fe to 0x2fe for COM2 */
{
#ifdef LOCAL
	return(TRUE);
#endif

	if((inp(0x3fe)&0x80)!=0x80)
		exit(1);
	return(TRUE);
}


/* Returns non 0 iff modem is ready to send a character */
moready()
{
#ifdef LOCAL
	return(1);
#endif

	srv.x.ax = 0x0300;
	int86(0x14, &srv, &rrv);
	return (rrv.x.ax & 0x2000);
}

/* sends c to the modem */
mochar(c)
{
/*
#ifdef LOCAL
	return;
#endif
*/
	srv.x.ax = 0x0100 | (c & 0xff);
	int86(0x14, &srv, &rrv);
}

