;;; -*-  Mode: LISP -*- (C) Ben Olasov 1988, 1989
;;;  Not-so-tiny two-pick door command

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: DOOR.LSP     Copyright (C) Ben Olasov 1989                        ;;;
;;; Inquiries:                                                              ;;;
;;;                                                                         ;;;
;;;     Ben Olasov                                                          ;;;
;;;     Graphic Systems, Inc.:                                              ;;;
;;;                                                                         ;;;
;;;                    New York, NY:   PH (212) 725-4617                    ;;;
;;;                    Cambridge, MA:  PH (617) 492-1148                    ;;;
;;;                    MCI-Mail:       GSI-NY   344-4003                    ;;;
;;;                                                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; This program is provided 'as is' without warranty of any kind, either 
;; expressed or implied, including, but not limited to the implied warranties of
;; merchantability and fitness for a particular purpose.  The entire risk as to
;; the quality and performance of the program is with the user.  Should the 
;; program prove defective, the user assumes the entire cost of all necessary 
;; servicing, repair or correction. 
;; AutoLisp and AutoCad are registered trademarks of AutoDesk, Inc.

(gc)
(vmon)
(princ "\nPlease wait- loading.. ")

(DEFUN C:DOOR (/ HP1 HP2 DWIDTH SP1 SP2 C-LAY BOX LIN1 LINE1 LINE2)
       (MODES '("CMDECHO" "COORDS" "OSMODE" "BLIPMODE"))
       (SETVAR "CMDECHO" 0)
       (SETVAR "COORDS" 2)
       (SETVAR "OSMODE" 256)
       (SETQ HP1 (GETPOINT "\nHinge pt: ")
             HP1 (OSNAP HP1 "NEAR")
             SP1 (GETPOINT HP1 "\nSwing pt: ")
             SP1 (OSNAP SP1 "NEAR")
             DWIDTH (DISTANCE HP1 SP1)
             C-LAY (GETVAR "CLAYER"))
       (SETVAR "OSMODE" 0)
       (SETQ BOX (SSGET "C" (LIST (- (CAR HP1) 12.0) (- (CADR HP1) 12.0))
                            (LIST (+ (CAR HP1) 12.0) (+ (CADR HP1) 12.0))))
       (IF (AND BOX
                (SETQ LIN1 (SSGET HP1))
                (SETQ L_NM (SSNAME LIN1 0))
                (LINE? L_NM))
           (PROGN (SETQ LINE1 (ENTGET L_NM))
                  (SSDEL (CDR (ASSOC -1 LINE1)) BOX) ;; remove first line from box
                  (FOREACH ENT (SS2ENAMLIST BOX)
                           (SETQ E (ENTGET ENT))
                           (IF (OR (/= (CDR (ASSOC 8 E))
                                       (CDR (ASSOC 8 LINE1)))
                                   (/= (CDR (ASSOC 0 E)) "LINE")
                                   (NOT (PARALLEL E LINE1)))
                               (SSDEL (CDR (ASSOC -1 E)) BOX)))
                  (SETVAR "OSMODE" 0)
                  (SETVAR "BLIPMODE" 0)
                  (IF (> (SSLENGTH BOX) 0) ;; look in the box
                      (PROGN (SETQ LINE2 (ENTGET (SSNAME BOX 0))
                                   HP2 (INTERS (CDR (ASSOC 10 LINE2))
                                               (CDR (ASSOC 11 LINE2))
                                   HP1 (POLAR HP1 (IF (> PI (ANGLE HP1 SP1))
                                                      (- (ANGLE HP1 SP1) (/ PI 2.0))
                                                      (+ (ANGLE HP1 SP1) (/ PI 2.0)))
                                              (DISTANCE HP1 SP1)) nil))
                             (COMMAND "LAYER" "S" (CDR (ASSOC 8 LINE1)) "")
                             (SETQ SP2 (POLAR HP2 (ANGLE HP1 SP1) DWIDTH)
                                   P5 (POLAR HP1 (ANGLE HP2 HP1) DWIDTH))
                             (COMMAND "BREAK" HP1 SP1)
                             (COMMAND "BREAK" HP2 SP2)
                             (COMMAND "LINE" HP1 HP2 "")
                             (COMMAND "LINE" SP1 SP2 "")
                             (COMMAND "LINE" HP1 P5 "")
                             (COMMAND "ARC" SP1 "E" P5 "D" (ATOF (ANGTOS (ANGLE HP2 HP1) 0 4)))
                             (COMMAND "LAYER" "S" C-LAY ""))))
           (PRINC "\ndoor: invalid selection set"))
       (MODER)
       (PRINC))

(princ "\rPlease wait- loading.. \\")

;; convert a selection set to a list of entity names
(DEFUN SS2ENAMLIST (SS / ENTLIST COUNTER)
        (SETQ COUNTER 0)
        (REPEAT (SSLENGTH SS)
            (PROGN (SETQ ENTLIST (CONS (SSNAME SS COUNTER) ENTLIST))
                   (SETQ COUNTER (1+ COUNTER)))) ENTLIST)

(princ "\rPlease wait- loading.. \|")

(DEFUN PARALLEL (LINE1 LINE2)                 ;; takes 2 e-lists as arguments-
       (OR (~= (ANGLE (CDR (ASSOC 10 LINE1))  ;; allow tolerance for nearly 
                      (CDR (ASSOC 11 LINE1))) ;; parallel lines
               (ANGLE (CDR (ASSOC 10 LINE2))
                      (CDR (ASSOC 11 LINE2))) (/ PI 180.0)) ;; 1 rad tolerance
           (~= (ANGLE (CDR (ASSOC 11 LINE1))
                      (CDR (ASSOC 10 LINE1)))
               (ANGLE (CDR (ASSOC 10 LINE2))
                      (CDR (ASSOC 11 LINE2))) (/ PI 180.0))))

(princ "\rPlease wait- loading.. \/")

(DEFUN ~= (ACT_VAL TEST_VAL TOL)  ;;fuzzy equality
       (AND (<= ACT_VAL (+ TEST_VAL TOL))
            (>= ACT_VAL (- TEST_VAL TOL))))

(princ "\rPlease wait- loading.. \-")

;; from AutoDesk
(DEFUN MODES (A)
       (SETQ MLST '())
       (REPEAT (LENGTH A)
               (SETQ MLST (APPEND MLST (LIST (LIST (CAR A) (GETVAR (CAR A))))))
               (SETQ A (CDR A))))

(princ "\rPlease wait- loading.. \\")

;; from AutoDesk
(DEFUN MODER ()
       (REPEAT (LENGTH MLST)
               (SETVAR (CAAR MLST) (CADAR MLST))
               (SETQ MLST (CDR MLST))))

(princ "\rPlease wait- loading.. \|")

(DEFUN LINE? (ENM) ;; takes an entity name as its argument
       (IF (AND ENM (= (CDR (ASSOC 0 (ENTGET ENM))) "LINE"))
           'T
           (PROGN (PRINC "\nWall entities must be lines.") nil)))

(princ "\rPlease wait- loading.. \/")

(PRINC "\r2 pick door command C:DOOR loaded.  Type DOOR to begin.")
(PRINC)

