TITLE	TUNE	6-10-84	[4-19-88]
;Toad Hall Disassembly, tweak

LF	EQU	0AH
CR	EQU	0DH
UNK_FREQ equ	0FFFEH
TUNE_END equ	0FFFFH

;
;INITIAL VALUES :	CS:IP	0000:0100
;			SS:SP	0000:FFFF
CodeSeg	SEGMENT
	ASSUME DS:CodeSeg,SS:CodeSeg,CS:CodeSeg,ES:CodeSeg
	ORG	100H

Tune	proc	near
	JMP	Start

;Table of tune data addresses
tuneTable	label	word
	DW	tune1,tune2,tune3,tune4,tune5
	DW	tune6,tune7,tune8,tune9

;words are (1) frequency lsb & msb, (2) duration
tune1	DW	05DCH,0008H
	dw	053CH,0008H
	dw	06A4H,0008H
	dw	0D48H,0008H
	dw	08FCH,0010H
	DW	TUNE_END

tune2	DW	05DCH,0008H
	dw	053CH,0008H
	dw	06A4H,0008H
	dw	08FCH,0008H
	dw	0474H,0010H
	DW	TUNE_END

tune3	DW	05DCH,0008H
	dw	053CH,0008H
	dw	06A4H,0008H
	DW	0D48H,0008H
	dw	08FCH,0008H
	DW	08FCH,0008H
	dw	08FCH,0008H
	dw	0D48H,0008H
	dw	08FCH,0008H
	dw	08FCH,0008H
	DW	08FCH,0008H
	dw	0FA0H,0010H
	dw	TUNE_END

tune4	DW	0FA0H,0010H
	dw	0FA0H,0010H
	dw	0FA0H,0008H
	dw	0FA0H,0010H
	dw	0D48H,0010H
	DW	0DACH,0008H
	dw	0DACH,0010H
	dw	0FA0H,0008H
	dw	0FA0H,0010H
	dw	1068H,0008H
	DW	0FA0H,0010H
	dw	TUNE_END

tune5	DW	07D0H,0008H
	dw	0708H,0008H
	dw	0640H,0008H
	dw	053CH,0010H
	dw	0640H,0008H
	DW	053CH,0010H
	dw	TUNE_END

tune6	DW	0708H,0008H
	dw	0640H,0010H
	dw	053CH,0010H
	dw	0640H,0008H
	dw	0708H,0008H
	DW	0640H,0008H
	dw	07D0H,0020H
	dw	UNK_FREQ,0008H
	dw	03E8H,0008H
tune7	label	word
tune8	label	word
tune9	label	word
	dw	TUNE_END

;If you want tunes 7 through 9:
; Add their data here.
; Rem out the appropriate bogus "tune%" label(s) above.
; Insure each tune ends with 0FFFFH

;L01E1	  L0113 DI
;tune7	DW	TUNE_END
;tune8	DW	TUNE_END
;tune9	DW	TUNE_END

;If you know you have a fast processor, you can fiddle this
;delay constant appropriately (or just use the cmd line slow..fast
;adjuster).

delayConst	dw	2000H		;delay constant

Start:
	cld				;insure fwd
	MOV	DI,65H			;DOS PSP cmd line?
;original used BL throughout .. but AX/AL is faster...
	MOV	al,[DI]			;snarf PSP data
	CMP	al,20H			;any slow..fast modifier?
	JZ	L0202			;nope, no delay modifier
	 AND	al,0FH			;mask the delay to 0..15
	 MOV	CL,4
	 SHL	al,CL			;*16
	 MOV	byte ptr delayConst+1,al	;new delay constant msb
L0202:	MOV	DI,5DH			;cmd line start
CmdLup:
	MOV	al,[DI]			;snarf cmd line char
	CMP	al,'1'
	JB	Die_224			; illegal
	CMP	al,'9'			; illegal
	JA	Die_224
	AND	al,0FH			;mask to 0..15
	DEC	al			;adjust
	SHL	al,1			; * 2 for words
	XOR	ah,ah			;clear msb
	mov	bx,ax			;into BX for offset
	MOV	SI,[BX+tuneTable]	;get this tune's starting offset
	CALL	Play_Tune		;play the tune
	INC	DI			;bump cmd line ptr
	JMP	SHORT	CmdLup		; and continue processing cmd line

Die_224:
	mov	ax,4C00H		;terminate process
	int	21H
Tune	endp


;L0225	  L021E CC  L025E CJ
Play_Tune	proc	near
	LODSW				;get tune data (note frequency)
	CMP	AX,TUNE_END		; done?
	JZ	Tune_Done		; yep
	MOV	DX,AX			;remember it here
	MOV	AL,0B6H			;prepare sound register
	OUT	43H,AL
	MOV	AL,dl			;sound data lsb
	OUT	42H,AL
	MOV	AL,dh			;sound data msb
	OUT	42H,AL
	IN	AL,61H			;get sound reg status
	MOV	BH,AL			;save in BH for output later
	CMP	DX,UNK_FREQ		;was last data this?
	JZ	Skp24A			; yep, don't bother sound reg
	 OR	AL,3
	 OUT	61H,AL			;fiddle sound reg somehow
Skp24A:	LODSW				;snarf next tune data (note length)
Lup24B:	MOV	CX,delayConst		;delay constant
Delay24F:
	LOOP	Delay24F		;delay a bit
	DEC	AX			;decrement note length counter
	JNZ	Lup24B			;keep playing
	MOV	AL,BH			;get that status back
	OUT	61H,AL			;sound off ?
	MOV	CX,delayConst		;delay constant
Delay25C:
	LOOP	Delay25C
	JMP	SHORT	Play_Tune	;loop until tune is done

Tune_Done:
	RET
Play_Tune	endp

CodeSeg	ENDS
	END	Tune
