;************************************************************************
;*									*
;*	ELF.A86.  This stupid program will set the specified error level*
;*	for batch files.  It has two modes of operation:  If invoked by:*
;*	ELF <CR> it will display: (Y/N)? on the screen & wait for one	*
;*	of these keys to be pressed.  It will then exit with errorlevel *
;*	255 if N was pressed, or error level 0 if Y was pressed.  With  *
;*	careful editing of prompts in a batch file, this can be used	*
;*	to make run-time operator decisions in batch files.		*
;*	The second invocation is:  ELF XX <CR>  Where XX is a two digit *
;*	HEXIDECIMAL number.  ELF will terminate with the specified	*
;*	error level.  This can add error level processing to programs	*
;*	that do not support it by chaining to ELF upon termination.	*
;*	Remember that the batch file ERRORLEVEL command only accepts	*
;*	decimal radix arguments.  Hex was used for ELF out of pure	*
;*	laziness on the part of the programmer!				*
;*	Written by:  Mark D. Pickerill  9 Sept. 1988.  The user bears	*
;*	all responsiblity for testing & use.  ELF stands for (E)rror	*
;*	(L)evel (F)ile, although the name was inspired by Tolkien,	*
;*	more than anything else.  COSMAC users take note!		*
;*									*
;************************************************************************
;
;v1.1, 28 Oct 88
; Toad Hall Tweak
; - reformatting to ASM/MASM format.
; - slight tweaks (in lower case or w/'TH' comments)
; David Kirschbaum
; Toad Hall
; kirsch@braggvax.ARPA

CR	EQU	0DH		; Carriage return
LF	EQU	0AH		; Line feed
EOF	EQU	1AH		; End of file

CSEG	segment public para 'code'
	assume	CS:Cseg, DS:Cseg, ES:Cseg

	ORG	0100H		; Start of tpa

ELF	proc	near
	JMP	short START	; Jump past ego section

	DB	CR,LF,'ELF, Error Level File'
	DB	CR,LF,'By M.D.P. 9 Sept. 1988'
	db	CR,LF,'(Toad Hall Tweak, 881028',EOF
Elf	endp

START	proc	near
;TH DS and CS are set to CS in .COM programs
;	PUSH	CS		; Set data segment
;	POP	DS		; It's set
;	PUSH	DS		; Get this segment
;	POP	ES		; And set es as well
	cld			;insure fwd
	MOV	SI,0080H	; Point to parameter field in psp
	lodsb			;get parameter length
	or	al,al		;any parm length?
	JZ	NOPARMS		; Do y/n

	xor	ch,ch		;zero CH
	mov	cl,al		;parm length into CX for counter
LOOP1:
	lodsb			; Get byte from parameter field
	CMP	AL,' '		; Space?
	LOOPZ	LOOP1		; Wait until you get a non-space char
	JZ	NOPARMS		; Do y/n
	MOV	AH,AL		; Get hex char
	lodsb			; Get next hex lsn
	CALL	GETHEX		; Convert to hex
	XCHG	AH,AL		; Store & retrieve msn
	CALL	GETHEX		; Convert
	XCHG	AH,AL		; Switch back
	ADD	AH,AH		; Compensate upper nybble
	ADD	AH,AH
	ADD	AH,AH
	ADD	AH,AH		; Ok, i`m tired of rotates!
	OR	AL,AH		; Ok we now have our number
	MOV	AH,4CH		; Mush dos terminate
	INT	21H		; Terminate with specified error level
Start	endp


GETHEX	proc	near
	CMP	AL,2FH		; <2f?
	JL	TERM		; Control, ignore
	CMP	AL,46H		; >46?
	JG	TERM		; Upper-case g or above, ignore
	CMP	AL,39H		; <39?
	JLE	NUMBER		; It's a number
	CMP	AL,41H		; <41?
	JL	TERM		; It's a punctuation, etc; ignore
LETTER: ADD	AL,09H		; 9 makes the lsn=hex version of input
NUMBER: AND	AL,0FH		; Strip msn, makes numbers hex & dumps
				; Useless msn for letters
	RET			; Near

TERM:	MOV	AX,4C01H	; Garbage parameters
	INT	21H
GetHex	endp


MESSAGE	DB	'(Y/N)?$'	; Question

NOPARMS	proc	near
	MOV	AH,09H		; Print string function
;	LEA	DX,MESSAGE	; Point
	mov	dx,offset message	;msg offset
	INT	21H		; Do it
NOPE:	MOV	AH,01H		; Console input
	INT	21H		; Get char
	AND	AL,5FH		; Make upper case
;	CMP	AL,'Y'		; Yes?
;	JZ	YES		; Yes
;	CMP	AL,'N'		; No?
;	JZ	NO		; Yes
;	JMP	NOPE		; Garbage, ignore
	mov	ah,0FFH		;assume no, errorlevel 0FFH
	cmp	al,'N'		;No?
	jz	No
	cmp	al,'Y'		;Yes?
	jnz	Nope		; Garbage, ignore
;YES:
	dec	ah		;errorlevel now 0
No:
	mov	al,4CH		;terminate
	xchg	al,ah		;AH=4CH, AL=errorlevel
	push	ax		;save

;TH put CrLf function inline since now only used once.
	MOV	AH,02H		;CONOUT FUNCTION
	MOV	DL,0DH		;SEND CR
	INT	21H		;DO IT
;TH Svc 2, Int 21H, does not disturb AH
;	MOV	AH,02H		;CONOUT FUNCTION
	MOV	DL,0AH		;SEND LF
	INT	21H		;DO IT

	pop	ax		;set up for termination
	INT	21H		; We're history
NoParms	endp


Cseg	ENDS
	end	Elf
