Title   MonOf   Determine type of monitor - 05 Oct 1987 - Davy Crockett

;       ͻ
;          Davy Crockett Productions   
;          5807 Cherrywood Lane, 104   
;          Greenbelt, Maryland 20770   
;       ͼ

RetNear Macro
        DB      0C3H
        Endm

Null    Equ     00H
CR      Equ     0DH
LF      Equ     0AH
Parms   Equ     80H

Cseg    Segment
        Assume  DS:Cseg, SS:Cseg, CS:Cseg, ES:Cseg

        Org     100H

MonOf:
        Mov     BX,Parms                ; point to trailer
        Cmp     Byte Ptr [BX],Null      ; anything there?
        Jnz     MonitorOnly             ; yes, skip help message
        Mov     DX,Offset MonHelp       ; point to message
        Mov     AH,09H                  ; display string function
        Int     21H                     ; StdOut

MonitorOnly:
        Int     11H                     ; Equipment check
        Mov     CL,4                    ; shift count
        Shr     AX,CL                   ; shift AX register
        And     AX,3                    ; strip extraneous bits
        Cmp     AX,3                    ; monochrome?
        Jz      MonoVideo               ; yes, go set for mono
        Mov     AL,2                    ; no, return color monitor
        Jmp     Short MonOfExit         ; exit stage left
MonoVideo:
        Mov     AL,1                    ; return monochrome
        Jmp     Short MonOfExit         ; exit stage left

MonOfExit:
        Mov     AH,4CH                  ; terminate a process
        Int     21H                     ; exit stage left

MonHelp         Equ     $
                DB      CR,LF,LF
                DB      '* MonOf * Version 1.0 * 05 Oct 1987 '
                DB      '* Davy Crockett *',CR,LF,LF
                DB      'Returns type of monitor in use.',CR,LF,LF
                DB      '    Execute:  MonOf [garbage]',CR,LF,LF
                DB      '    [garbage] can be anything to zap this display.'
                DB      CR,LF,LF
                DB      '    Return Code = 1, Monochrome Monitor.',CR,LF
                DB      '    Return Code = 2, Color Monitor.',CR,LF,LF
                DB      '$'

MonOfLen        Equ     (This Byte) - (Offset MonOf)
Filler          Equ     432 - MonOfLen
                DB      Filler DUP(0)
CopyRight       Equ     $
                DB      'ͻ '
                DB      'Davy Crockett '
                DB      ' Productions  '
                DB      ' 05 Oct 1987  '
                DB      'ͼ'

Cseg    Ends

End     MonOf
