#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*            GNUPLOT shell          */
/*             dialog box            */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <string.h>
#include <io.h>
#include "globals.h"
#include "defines.h"
#include "strtbl.h"
#include "gwsim.h"
#include "simgvar.h"
#include "basic.h"
#include "gep2.h"

void AddXYZLst( HWND hControl, LPSTR text );
void plot_text( LPSTR Buff );
void label_dyn( int idx, LPSTR str );
void label_dat( int idx, LPSTR str );

#pragma alloc_text( CODE16, AddXYZLst, Plot, plot_text, label_dyn, label_dat, GnuPlot )


/* function to add column titles on the X, Y and Z lists	*/

void AddXYZLst( HWND hControl, LPSTR text )
{
 int i;
 WORD ElWidth;
 HANDLE hDC;

 hDC = GetDC( hControl );
 ElWidth = 5 + LOWORD( GetTextExtent( hDC, text, _fstrlen(text) ) );
 SetTextJustification( hDC, 0, 0 );
 ReleaseDC( hControl, hDC );
 if( ElWidth > lbWidth )
 {
  lbWidth = ElWidth;
  SendMessage( hControl, LB_SETHORIZONTALEXTENT, lbWidth, 0 );
 }
 SendMessage( hControl, LB_INSERTSTRING, -1, (DWORD) text );
}



/* Function for the Plot... dialog box	*/

int FAR PASCAL Plot(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static HWND hX, hY, hZ, hZlog, hZtext, hDyn, hSs, hCont, hHidd;
 static int file, type;
 int  i,j;
 char auxstr[NAME_L+5];

 switch(Message)
 {
  case WM_INITDIALOG:
   /* save file and type							*/
   file = plot.file;
   type = plot.type;

   /* check if any data can be available			*/
   if( ( (totsel==0) ) && (!options.dyn) )
    SendMessage( hDlg, WM_COMMAND, IDCANCEL, 0 );

   /* get handles to controls						*/
   hX     = GetDlgItem( hDlg, IDC_X );
   hY     = GetDlgItem( hDlg, IDC_Y );
   hZ     = GetDlgItem( hDlg, IDC_Z );
   hZlog  = GetDlgItem( hDlg, IDRB_3E );
   hZtext = GetDlgItem( hDlg, IDSTAT_5 );
   hDyn   = GetDlgItem( hDlg, IDC_DYNAMICS );
   hSs    = GetDlgItem( hDlg, IDC_SS );
   hCont  = GetDlgItem( hDlg, IDRB_5E );
   hHidd  = GetDlgItem( hDlg, IDRB_5I );

   /* disable Z and check boxes if type is 2D */
   if( type==0 )
   {
    EnableWindow( hZ, FALSE );
    EnableWindow( hZlog, FALSE );
    EnableWindow( hZtext, FALSE );
    EnableWindow( hCont, FALSE );
    EnableWindow( hHidd, FALSE );
   }

   /* check the appropriate file radio button		*/
   if( ! options.dyn )
   {
    EnableWindow( hDyn, FALSE );
    file = 1;
   }
   if( totsel==0 )
   {
    EnableWindow( hSs, FALSE );
    file = 0;
   }

   if( file==0 )
    SendMessage( hDyn, BM_SETCHECK, (WORD) 1, 0 );
   else
    SendMessage( hSs, BM_SETCHECK, (WORD) 1, 0 );


   /* check the appropriate type radio button		*/
   SendDlgItemMessage( hDlg, IDRB_0E+plot.type, BM_SETCHECK, (WORD) 1, 0 );

   /* check boxes									*/
   SendDlgItemMessage( hDlg, IDRB_4E, BM_SETCHECK, (WORD) plot.lines, 0 );
   SendDlgItemMessage( hDlg, IDRB_2E, BM_SETCHECK, (WORD) plot.logx, 0 );
   SendDlgItemMessage( hDlg, IDRB_2I, BM_SETCHECK, (WORD) plot.logy, 0 );
   SendDlgItemMessage( hDlg, IDRB_3E, BM_SETCHECK, (WORD) plot.logz, 0 );
   SendDlgItemMessage( hDlg, IDRB_4I, BM_SETCHECK, (WORD) plot.colour, 0 );
   SendDlgItemMessage( hDlg, IDRB_5E, BM_SETCHECK, (WORD) plot.contour, 0 );
   SendDlgItemMessage( hDlg, IDRB_5I, BM_SETCHECK, (WORD) plot.hidden, 0 );

   /* initialize hX, hY and hZ: add all columns		*/
   if( file==1 )
   {
    if( plot.ny > totsel )
     plot.ny = 0;
    else
     for(i=0; i<plot.ny; i++ )
      if( plot.y[i] > totsel )
       for( j=i; j<plot.ny; j++ )
       {
        plot.y[j] = plot.y[j+1];
        i--;
       }
    for( i=0, lbWidth=0; i<totsel; i++ )
     for( j=0; j<noutpel; j++ )
      if( (outpel[j].idx-1) == (unsigned int) i )
      {
       AddElLst( hX, outpel, j, FALSE );
       AddElLst( hY, outpel, j, FALSE );
       AddElLst( hZ, outpel, j, FALSE );
      }
   }
   else
   {
    lbWidth=0;
    AddXYZLst( hX, (LPSTR) "time" );
    AddXYZLst( hY, (LPSTR) "time" );
    AddXYZLst( hZ, (LPSTR) "time" );
    for( i=0; i<nmetab; i++ )
    {
     wsprintf( (LPSTR) auxstr, "[%s]", (LPSTR) metname[i] );
     AddXYZLst( hX, (LPSTR) auxstr );
     AddXYZLst( hY, (LPSTR) auxstr );
     AddXYZLst( hZ, (LPSTR) auxstr );
    }
    for( i=0; i<nsteps; i++ )
    {
     wsprintf( (LPSTR) auxstr, "J(%s)", (LPSTR) stepname[i] );
     AddXYZLst( hX, (LPSTR) auxstr );
     AddXYZLst( hY, (LPSTR) auxstr );
     AddXYZLst( hZ, (LPSTR) auxstr );
    }
   }

   /* highlight the current selections			*/
   SendMessage( hX, LB_SETCURSEL, (WORD) plot.x, 0 );
   SendMessage( hZ, LB_SETCURSEL, (WORD) plot.z, 0 );
   for( i=0; i<plot.ny; i++)
    SendMessage( hY, LB_SELITEMRANGE, 1, MAKELONG( plot.y[i], plot.y[i] ) );

   /* cause a WM_PAINT to be sent to the window	*/
   InvalidateRect( hDlg, NULL, FALSE );
   return TRUE;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_Y:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
      if( type!=0 )
      {
       for( i=0; i<plot.ny; i++ )
        SendMessage( hY, LB_SELITEMRANGE, 0, MAKELONG( plot.y[i], plot.y[i] ) );
      }
      plot.ny = (int) SendMessage( hY, LB_GETSELITEMS, (WORD) 10, (DWORD) (int huge *) plot.y );
     }
     return TRUE;


    case IDRB_0E:
     if( SendDlgItemMessage( hDlg, IDRB_0E, BM_GETCHECK, 0, 0 ) )
     {
      type = 0;
      SendMessage( hZ, LB_SETCURSEL, -1, 0 );
      EnableWindow( hZ, FALSE );
      EnableWindow( hZlog, FALSE );
      EnableWindow( hZtext, FALSE );
      EnableWindow( hCont, FALSE );
      EnableWindow( hHidd, FALSE );
      InvalidateRect( hDlg, NULL, FALSE );
     }
     return TRUE;

    case IDRB_0I:
     if( SendDlgItemMessage( hDlg, IDRB_0I, BM_GETCHECK, 0, 0 ) )
      if( type == 0 )
      {
       plot.ny = (int) SendMessage( hY, LB_GETSELITEMS, (WORD) 10, (DWORD) (int huge *) plot.y );
       for( i=0; i<plot.ny; i++ )
        SendMessage( hY, LB_SELITEMRANGE, 0, MAKELONG( plot.y[i], plot.y[i] ) );
       EnableWindow( hZ, TRUE );
       EnableWindow( hZlog, TRUE );
       EnableWindow( hZtext, TRUE );
       EnableWindow( hCont, TRUE );
       EnableWindow( hHidd, TRUE );
       InvalidateRect( hDlg, NULL, FALSE );
      }
      type = 1;
     return TRUE;

    case IDC_SS:
     if(  ( SendDlgItemMessage( hDlg, IDC_SS, BM_GETCHECK, 0, 0 ) )
        &&
          ( file==0 )
       )
     {
      file=1;
      SendMessage( hX, LB_RESETCONTENT, 0, 0 );
      SendMessage( hY, LB_RESETCONTENT, 0, 0 );
      SendMessage( hZ, LB_RESETCONTENT, 0, 0 );
      for( i=0, lbWidth=0; i<totsel; i++ )
       for( j=0; j<noutpel; j++ )
        if( (outpel[j].idx-1) == (unsigned int) i )
        {
         AddElLst( hX, outpel, j, FALSE );
         AddElLst( hY, outpel, j, FALSE );
         AddElLst( hZ, outpel, j, FALSE );
        }
     }
     return TRUE;

    case IDC_DYNAMICS:
     if(  ( SendDlgItemMessage( hDlg, IDC_DYNAMICS, BM_GETCHECK, 0, 0 ) )
        &&
          ( file==1 )
       )
     {
      file=0;
      SendMessage( hX, LB_RESETCONTENT, 0, 0 );
      SendMessage( hY, LB_RESETCONTENT, 0, 0 );
      SendMessage( hZ, LB_RESETCONTENT, 0, 0 );
      lbWidth=0;
      AddXYZLst( hX, (LPSTR) "time" );
      AddXYZLst( hY, (LPSTR) "time" );
      AddXYZLst( hZ, (LPSTR) "time" );
      for( i=0; i<nmetab; i++ )
      {
       wsprintf( (LPSTR) auxstr, "[%s]", (LPSTR) metname[i] );
       AddXYZLst( hX, (LPSTR) auxstr );
       AddXYZLst( hY, (LPSTR) auxstr );
       AddXYZLst( hZ, (LPSTR) auxstr );
      }
      for( i=0; i<nsteps; i++ )
      {
       wsprintf( (LPSTR) auxstr, "J(%s)", (LPSTR) stepname[i] );
       AddXYZLst( hX, (LPSTR) auxstr );
       AddXYZLst( hY, (LPSTR) auxstr );
       AddXYZLst( hZ, (LPSTR) auxstr );
      }
     }
     return TRUE;

    case IDC_HELP:            /* Help on this Dialog Box				*/
  	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Plot" );
   	 return TRUE;

    case IDOK:
     /* save type and file */
     plot.file = file;
     plot.type = type;
     /* get x, y and z */
     plot.x = (int) SendMessage( hX, LB_GETCURSEL, 0, 0 );
     plot.ny = (int) SendMessage( hY, LB_GETSELITEMS, (WORD) 10, (DWORD) (int huge *) plot.y );
     plot.z = (int) SendMessage( hZ, LB_GETCURSEL, 0, 0 );
     /* get lines, xlog, ylog and zlog */
     plot.logx = (int) SendDlgItemMessage( hDlg, IDRB_2E, BM_GETCHECK, 0, 0 );
     plot.logy = (int) SendDlgItemMessage( hDlg, IDRB_2I, BM_GETCHECK, 0, 0 );
     plot.logz = (int) SendDlgItemMessage( hDlg, IDRB_3E, BM_GETCHECK, 0, 0 );
     plot.lines = (int) SendDlgItemMessage( hDlg, IDRB_4E, BM_GETCHECK, 0, 0 );
     plot.colour = (int) SendDlgItemMessage( hDlg, IDRB_4I, BM_GETCHECK, 0, 0 );
     plot.contour = (int) SendDlgItemMessage( hDlg, IDRB_5E, BM_GETCHECK, 0, 0 );
     plot.hidden = (int) SendDlgItemMessage( hDlg, IDRB_5I, BM_GETCHECK, 0, 0 );
     /* close this dialog box */
     EndDialog(hDlg, IDOK);
     return TRUE;

    case IDCANCEL:
     EndDialog(hDlg, IDCANCEL);
     return TRUE;
   }    /* End of WM_COMMAND                                 */
   return FALSE;

  default:
   return FALSE;
 }
}

/* Function of dialog box to point GnuplotExe	*/

int FAR PASCAL EdGnuplot(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 switch(Message)
 {
  case WM_INITDIALOG:
   return TRUE;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Plot" );
   	 return TRUE;

    case IDOK:
     /* close this dialog box */
     EndDialog(hDlg, IDOK);
     return TRUE;

    case IDCANCEL:
     EndDialog(hDlg, IDCANCEL);
     return TRUE;
   }    /* End of WM_COMMAND                                 */
   return FALSE;

  default:
   return FALSE;
 }
}


/* sets the labels for a plot of the dynamics */

void label_dyn( int idx, LPSTR str )
{
 if( idx == 0 )
  wsprintf( (LPSTR) str, "'time'" );
 else
  if( idx <= nmetab )
   wsprintf( (LPSTR) str, "'[%s]'", (LPSTR) metname[idx-1] );
   else
    if( idx > nmetab )
     wsprintf( (LPSTR) str, "'J(%s)'", (LPSTR) stepname[idx-1-nmetab] );
}

void label_dat( int idx, LPSTR str )
{
 int i;

 for( i=0; i<noutpel; i++ )
  if( outpel[i].idx-1 == (unsigned int) idx ) break;
 wsprintf( (LPSTR) str, "'%s'", outpel[i].title );
}


/* builds the commands for gnuplot to draw the plot */

void plot_text( LPSTR Buff )
{
 char File[256];
 char auxstr[128];
 char *p;
 int i, j;

 *Buff = '\0';
 if( plot.ny == 1 ) lstrcat( (LPSTR) Buff, (LPSTR) "set nokey\n" );
 if( plot.type != 0 )
 {
  lstrcat( (LPSTR) Buff, (LPSTR) "set parametric\nset ticslevel 0\n" );
  lstrcat( (LPSTR) Buff, (LPSTR) "set nopolar\nset surface\n" );
  lstrcat( (LPSTR) Buff, (LPSTR) "set urange [1e-20:]\nset vrange[1e-20:]\n" );
  if( plot.hidden )
   lstrcat( (LPSTR) Buff, (LPSTR) "set hidden3d\n" );
  else
   lstrcat( (LPSTR) Buff, (LPSTR) "set nohidden3d\n" );
  if( plot.contour )
   lstrcat( (LPSTR) Buff, (LPSTR) "set contour base\nset cntrparam bspline\n" );
  else
   lstrcat( (LPSTR) Buff, (LPSTR) "set nocontour\n" );
 }
 if( plot.logx ) lstrcat( (LPSTR) Buff, (LPSTR) "set logscale x\n" );
 if( plot.logy ) lstrcat( (LPSTR) Buff, (LPSTR) "set logscale y\n" );
 if( plot.logz ) lstrcat( (LPSTR) Buff, (LPSTR) "set logscale z\n" );
 if( plot.file==0 )
 {
  lstrcpy( (LPSTR) File, (LPSTR) FileName );
  if ( p = strrchr( File, '.' ) ) strcpy( p, ".dyn" );
  else strcat( File, ".dyn" );
  wsprintf( (LPSTR) auxstr, (LPSTR) "set title '%s'\n", (LPSTR) FileTitle );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
  wsprintf( (LPSTR) auxstr, (LPSTR) "set xlabel " );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
  label_dyn( plot.x, (LPSTR) auxstr );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
  lstrcat( (LPSTR) Buff, (LPSTR) "\n" );
  if( plot.ny==1 )
  {
   wsprintf( (LPSTR) auxstr, (LPSTR) "set ylabel " );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   label_dyn( plot.y[0], (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) "\n" );
  }
  if( plot.type==1 )
  {
   wsprintf( (LPSTR) auxstr, (LPSTR) "set zlabel " );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   label_dyn( plot.z, (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) "\n" );
  }
 }
 else
 {
  lstrcpy( (LPSTR) File, (LPSTR) DatName );
  wsprintf( (LPSTR) auxstr, (LPSTR) "set title '%s'\n", (LPSTR) DatTitle );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
  wsprintf( (LPSTR) auxstr, (LPSTR) "set xlabel " );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
  label_dat( plot.x, (LPSTR) auxstr );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
  lstrcat( (LPSTR) Buff, (LPSTR) "\n" );
  if( plot.type != 0 )
  {
   wsprintf( (LPSTR) auxstr, (LPSTR) "set zlabel " );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   label_dat( plot.z, (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) "\n" );
  }
  if( plot.ny==1 )
  {
   wsprintf( (LPSTR) auxstr, (LPSTR) "set ylabel " );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   label_dat( plot.y[0], (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
   lstrcat( (LPSTR) Buff, (LPSTR) "\n" );
  }
 }
 if( plot.type != 0 )  lstrcat( (LPSTR) Buff, (LPSTR) "s" );
 wsprintf( (LPSTR) auxstr, (LPSTR) "plot '%s' using %d:%d", (LPSTR) File, plot.x+1, plot.y[0]+1 );
 lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
 if( plot.ny > 1 )
 {
  lstrcat( (LPSTR) Buff, (LPSTR) " title " );
  if( plot.file==0 ) label_dyn( plot.y[0], (LPSTR) auxstr );
  else label_dat( plot.y[0], (LPSTR) auxstr );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
 }
 if( plot.type != 0 )
 {
  wsprintf( (LPSTR) auxstr, (LPSTR) ":%d", plot.z+1 );
  lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
 }
 if( plot.lines ) lstrcat( (LPSTR) Buff, (LPSTR) " with lines" );
 else lstrcat( (LPSTR) Buff, (LPSTR) " with dots" );
 if( plot.type==0 )
 {
  if( plot.ny > 1 )
   for( i=1; i<plot.ny; i++ )
   {
    wsprintf( (LPSTR) auxstr, (LPSTR) ", '%s' using %d:%d",
              (LPSTR) File, plot.x+1, plot.y[i]+1 );
    lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
    lstrcat( (LPSTR) Buff, (LPSTR) " title " );
    if( plot.file==0 ) label_dyn( plot.y[i], (LPSTR) auxstr );
    else label_dat( plot.y[i], (LPSTR) auxstr );
    lstrcat( (LPSTR) Buff, (LPSTR) auxstr );
    if( plot.lines ) lstrcat( (LPSTR) Buff, (LPSTR) " with lines" );
   }
 }
 lstrcat( (LPSTR) Buff, (LPSTR) "\npause -1 \"Press button to close\"\n" );
}


/* launches gnuplot to draw a plot (2D or 3D) */

int GnuPlot( HWND hWnd )
{
 OFSTRUCT OfStruct;
 int hFile, nRc;
 GLOBALHANDLE hBuff;
 LPSTR Buff;
 char szString[256];
 char GnuplotFile[256];

 hBuff = GlobalAlloc( GMEM_MOVEABLE | GMEM_DISCARDABLE, 1024 );
 Buff = GlobalLock( hBuff );

 /* generate a name for temporary file	*/
 GetTempFileName( 0, (LPSTR) "GPL", 0, (LPSTR) GnuplotFile );
 /* and add it to the list of files to delete in the end */
 GlobalUnlock( hTmpF );
 hTmpF = GlobalReAlloc( hTmpF, lstrlen( TmpFiles ) + lstrlen( GnuplotFile ) + 2, 0 );
 TmpFiles = GlobalLock( hTmpF );
 lstrcat( TmpFiles, GnuplotFile );
 lstrcat( TmpFiles, (LPSTR) "+" );
 /* put the gnuplot commands in Buff */
 plot_text( Buff );
 /* open the temporary file */
 hFile = OpenFile( (LPSTR) GnuplotFile, &OfStruct, OF_CREATE | OF_WRITE | OF_SHARE_COMPAT );
 {
  /* write the buffer to the file and close it							*/
  nRc = _lwrite( hFile, (LPSTR) Buff, (WORD) lstrlen( (LPSTR) Buff ) );
  _lclose( hFile );
 }
 if( nRc < lstrlen( Buff ) )
 {
  LoadString(hInst, IDS_ERR_NO_TEMP, szString, sizeof(szString));
  MessageBeep( MB_OK );
  MessageBox( hWnd, szString, FileTitle, MB_ICONINFORMATION );
  return IDS_ERR_NO_TEMP;
 }
 wsprintf( (LPSTR) szString, (LPSTR) "%s %s", (LPSTR) GnuplotExe, (LPSTR) GnuplotFile );
 if( options.debug )
 {
  lstrcat( (LPSTR) Buff, "\n\n" );
  lstrcat( (LPSTR) Buff, (LPSTR) szString );
  MessageBox( hWnd, Buff, (LPSTR) GnuplotFile, MB_ICONINFORMATION );
 }
 nRc = WinExec( (LPSTR) szString, SW_MINIMIZE );
 if( nRc<32 )
 {
  if( (nRc==2) || (nRc==3) )
   *GnuplotExe = '\0';
  else
   ErrorHandler( hInst, nRc );
  return nRc;
 }
 return 0;
}