;-----------------------------------------------------------------------;
; FAST_CLS Library procedure to be called from TURBO C			;
; This procedure clears the screen by writing zeros directly into the   ;
; screen buffer on the the video adapter defined in variable "vid_mem". ;
; This is the fastest way to clear the screen, although it useful only  ;
; when in non-text graphics mode.					;
;-----------------------------------------------------------------------;

	PUBLIC	_FAST_CLS
	NAME	FAST_CLS
_TEXT	SEGMENT	BYTE	PUBLIC	'CODE'
	ASSUME	CS:_TEXT

VID_MEM		EQU	0B000h		; Segment for MONO display adapter
					; change for your display type
					; CGA = 0B800h
;-----------------------------------------------------------------------;
_FAST_CLS	PROC	NEAR
		PUSH	BP		; Save the BP register
		MOV	BP,SP 		; Make BP point to top of stack
	
		MOV	AX,VID_MEM	; Point to mono display
		MOV	ES,AX		; Source = video adapter
		MOV	DI,0		; Destination = upper left corner
		MOV	AX,0		; Will fill buffer with zeros
		MOV	CX,2000		; Number of characters to write
		REP	STOSW		; Fill screen buffer fast!
		POP	BP		; Restore BP register
		RET			; Return to calling program
_FAST_CLS	ENDP
;-----------------------------------------------------------------------;

_TEXT		ENDS
		END
		
	