     /*   DEFINES USED IN HERCULES FUNCTIONS                       */

#define H_MEMLOC 0xB0000000 /* Hercules memory location            */
     /* the formula to convert a pixel position to a Hercules
        memory byte location                                       */
#define H_FORMULA (x1>>3)+((y1>>2)*90)+((y1 & 3)*8192)+h_apage*0x8000
#define MODEPORT 0x3B8     /* the Hercules ports                   */
#define ADDRPORT 0x3B4
#define DATAPORT 0x3B5
#define H_PSET   0         /*  several put modes                   */
#define H_AND    1
#define H_OR     2
#define H_XOR    3

   /*   EXTERNAL VARIABLES USED IN HERCULES FUNCTIONS              */

int    h_xpos=0;           /* the current graphics cursor position */
int    h_ypos=0;
int    h_xmin=0;           /* the limits of the current window     */
int    h_xmax=719;
int    h_ymin=0;
int    h_ymax=347;
int    h_vpage=0;          /* the current visible page             */
int    h_apage=0;          /* the current active page              */
int    h_pmode=H_PSET;     /* the current put mode                 */
int    h_color=1;          /* the current drawing color            */
int    h_vmode=7;          /* the current video mode               */
int    h_start=0;          /* a backstop for text                  */
char far *h_p;             /* a pointer to to Hercules memory      */

      /*      SOME FILL PATTERNS                                   */

char lgrey[8]={170,85,170,85,170,85,170,85};
char dgrey[8]={204,51,204,51,204,51,204,51};
char fore[8]={255,255,255,255,255,255,255,255};
char back[8]={0,0,0,0,0,0,0,0};
char nlines[8]={0,255,0,255,0,255,0,255};
char nstripes[8]={34,34,34,34,34,34,34,34};
char nrhatch[8]={17,34,68,136,17,34,68,136};
char nlhatch[8]={136,68,34,17,136,68,34,17};
char wlines[8]={0,0,0,255,0,0,0,255};
char wstripes[8]={128,128,128,128,128,128,128,128};
char wrhatch[8]={1,2,4,8,16,32,64,128};
char wlhatch[8]={128,64,32,16,8,4,2,1};

      /*     HERCULES PROTOTYPES                                   */

int     h_isherc(void);
int     h_init(int mode);
int     h_setvpage(int page);
int     h_moveto(int x1,int y1);
int     h_setpmode(int newpmode);
int     h_loadfont(char *fname,char *alphaptr);
void    h_onoff(int on);
void    h_boxfill(int x2,int y2,char *tile);
void    h_box(int x2,int y2,char *tile);
void    h_memor(char far *memptr,int fill,int count);
void    h_mempse(char far *memptr,int fill,int count);
void    h_memand(char far *memptr,int fill,int count);
void    h_memxor(char far *memptr,int fill,int count);
void    h_clrw(char *tile);
void    h_explode(char *tile);
void    h_patterns(void);
void    h_drawc(char letter,char *alphabet);
void    h_draws(char *string,char *alf_ptr);

