* Program Name: ds.prg *
* Author: Don L. Powells *
* (c) 1988 by Nantucket Corporation *

* Routine to display the structure of the dbf files in the 
*   current directory

SAVE SCREEN TO dispscrn
SCROLL(2,1,23,78,0)
SET COLOR TO i
CENTER(1,"ENHANCED LOCAL AREA NETWORK SUPPORT")
SET COLOR TO

* Draw screen heading
clear
@ 3,36 say "   "
@ 4,36 say "       "
@ 5,36 say "    "
@ 6,36 say "        "
@ 7,36 say "   "
@ 1,20 TO 9,60 DOUBLE
CENTER(1,"DISPLAY STRUCTURE")

* Present menu of dbf files
dbfcnt = ADIR("*.dbf")
DECLARE dbfs[dbfcnt]
ADIR("*.dbf",dbfs)
IF dbfcnt < 1
   ?? CHR(7)
   @ 0,0
   @ 0,0 say "There are no dbf files in this directory." +;
             " Press any key to continue."
   INKEY(0)
   @ 0,0
ELSE
   DECLARE dbfs[dbfcnt]

   * Load the array with the dbf names
   adir("*.dbf",dbfs)

   DO WHILE .T.
      * Offer user a menu of the dbf files and store the array
      *   subscript of the choice in a variable
      * Draw a box to contain the choices
      @ 11,35 to 19,46
      CENTER(21,"Highlight your choice and press <Enter>")
      CENTER(22,"Press<ESC> to exit DS program")
      subscpt = ACHOICE(12,36,18,45,dbfs)
      IF subscpt = 0
         EXIT
      ENDIF

      * Get the choice
      IF subscpt > 0 .and. subscpt <= dbfcnt
         curfile = dbfs[subscpt]
         * Chop off the extension
         curfile = SUBSTR(curfile,1,AT(".",curfile)-1)
         * Pad to a length of 8 with spaces
         curfile = IIF((LEN(curfile)<8),(curfile +;
            SPACE(8-LEN(curfile))),curfile)
      ELSE 
         curfile = SPACE(8)
      ENDIF

      IF curfile != SPACE(8)
         USE &curfile.   && Dot terminate macros to avoid errors
         * Create a file containing the structure of the chosen
         *   file
         COPY TO &curfile..str STRUCTURE EXTENDED
         USE &curfile..str
         DECLARE fields[fcount()], heads[4]
         * Fill the fields array with all the fieldnames from the
         *    currently open file
         * Note: Can also use AFIELDS() to fill the fields array
         FOR i=1 TO fcount()
            fields[i] = fieldname(i)
         NEXT
         * Define the column headings
         heads[1] = "Field Name"
         heads[2] = "Field Type"
         heads[3] = "Field Width"
         heads[4] = "No. of Decimals"
         @ 11,0 CLEAR TO 24,79
         * Draw a box to contain the table
         @ 12,0 TO 23,79
         CENTER(11,"Press <Enter> or <ESC> to exit")
         DBEDIT(13,1,22,78,fields,.F.,.F.,heads)
         CLOSE DATABASES
         subscpt = 1
         @ 11,0 CLEAR TO 24,79 
      ENDIF
   ENDDO
ENDIF
CLEAR
RESTORE SCREEN FROM dispscrn
RETURN
********************
* Function to center a string on a given row.
* Usage: Center(row#,expC)

FUNCTION Center
PARAMETERS trow,in_string
IF LEN(in_string)>=80
   @ trow,0 SAY in_string
ELSE 
   @ trow,(80 - LEN(in_string))/2 SAY in_string
ENDIF 

RETURN ("")
