{**
*   EXTEND.INC
*
*   DEFINEs and EXTERNs for interfacing with Clipper from Pascal.
*   Large model C only (double word pointers to code and data).
*
*   Modified from EXTEND.H
*   Copyright (c) 1987, 1988 Nantucket Corp.
}

#define CLIPPER      void pascal

{ _parinfo types }
#define UNDEF      0
#define CHARACTER  1
#define NUMERIC    2
#define LOGICAL    4
#define DATE       8
#define ALIAS      16
#define MPTR       32  {or'ed with type when passed by reference}
#define MEMO       65
#define WORD       128
#define ARRAY      512
#define NEWLINE    chr(13)
#define ENDSTR     chr(0)

type
   datestr   = packed array [1..8] of char;
   charstr   = packed array [1..64] of char;

   { Header structure }
   DBF_HEADER = record
                   signature : byte;       {03 = dbf, 83 dbf+dbt}
                   ymd       : array [1..3] of byte; {y+1900 m d}
                   last_rec  : integer4;
                   data_off  : quant;
                   rec_size  : quant;
                   pad       : array [1..20] of byte;
                end;

   dateptr   = ^datestr;
   charptr   = ^charstr;
   dbfhdrptr = ^DBF_HEADER;
   byteptr   = ^byte;
   adsdate   = ads of datestr;
   adschar   = ads of charstr;
   adsdbfhdr = ads of DBF_HEADER;
   adsbyte   = ads of byte;

{ parameter count/type }
function _parinfo : integer [c, varying]; extern;
function _parinfa : integer [c, varying]; extern;

{ parameter values }
function _parc    : adschar  [c, varying]; extern;
function _parcsiz : integer  [c, varying]; extern;
function _parclen : integer  [c, varying]; extern;
function _parni   : integer  [c, varying]; extern;
function _parnl   : integer4 [c, varying]; extern;
function _parnd   : real8    [c, varying]; extern;
function _parl    : integer  [c, varying]; extern;
function _pards   : adsdate  [c, varying]; extern;

{ one and only one of the _ret?? functions must be used }

{ Clipper-function return values }
{ function _retc    : adschar  [c, varying]; extern; }
function _retclen : adschar  [c]; extern;
function _retni   : integer  [c]; extern;
function _retnl   : integer4 [c]; extern;
function _retnd   : real8    [c]; extern;
function _retl    : integer  [c]; extern;
function _retds   : adschar  [c]; extern;

{ procedure (DO) return }
procedure _ret               [c]; extern;

{ allocate memory                           }
{ parameter:  requested size in bytes       }
{ returns:    far pointer to memory or NULL }
function _exmgrab(vars k :integer) : adsbyte [c]; extern;

{ free allocated memory }
{params: pointer from _exmgrab(), same size passed to _exmgrab()}
procedure _exmback(vars l : adsmem; vars m : byte); extern;

{ misc. }
function strlen(vars m : adschar) : byte; extern;

{ parameter check macros }
#define PCOUNT      (_parinfo(0))
#define ISCHAR(n)   (_parinfo(n) = CHARACTER)
#define ISNUM(n)    (_parinfo(n) = NUMERIC)
#define ISLOG(n)    (_parinfo(n) = LOGICAL)
#define ISDATE(n)   (_parinfo(n) = DATE)
#define ISMEMO(n)   (_parinfo(n) = MEMO)
#define ISBYREF(n)  (_parinfo(n) = MPTR)
#define ISARRAY(n)  (_parinfo(n) = ARRAY)
#define ALENGTH(n)  (_parinfa(n, 0))

function _dbfhead : adsdbfhdr [c, varying]; extern;
function _dbfopen : integer   [c, varying]; extern;
