#if !defined (STRFCTS)            /* Prevents multiple declarations errors */
#define STRFCTS


/*
   Module        : STRFCTS.H
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Rmy Gendron

   Description   : String related functions.
*/


/* Headers --------------------------------------------------------------- */

#include <stdio.h>


/* Macros ---------------------------------------------------------------- */

#include "stdmacro.h"


/* Typedefs -------------------------------------------------------------- */

#include "stdtype.h"


/* Prototypes ------------------------------------------------------------ */

#ifdef __cplusplus                     /* Enables linking with C++ modules */
extern "C" {
#endif

size_t far str_len                       /* Returns the length of a string */
(
   char huge *string                               /* Huge ptr to a string */
) ;

char huge * far str_cpy                  /* Copies one string into another */
(
   char huge *dest,                                   /* Destination array */
   char huge *src                                         /* Source string */
) ;

int far str_cmp                          /* Compares one string to another */
(
   char huge *string1,                                     /* First string */
   char huge *string2                                     /* Second string */
) ;

int far str_icmp        /* Case insensitive compares one string to another */
(
   char huge *string1,                                     /* First string */
   char huge *string2                                     /* Second string */
) ;

void far str_toupper                 /* Sets chars in string to upper case */
(
   char huge *string                               /* Huge ptr to a string */
) ;

void far str_tolower                 /* Sets chars in string to lower case */
(
   char huge *string                               /* Huge ptr to a string */
) ;

void far str_pastoc                /* Converts a pascal string to c format */
(
   char huge *string                                      /* Ptr to string */
) ;

void far str_ctopas                /* Converts a c string to pascal format */
(
   char huge *string                                      /* Ptr to string */
) ;

void far str_trim                   /* Removes leading and trailing spaces */
(
   char huge *string                                      /* Ptr to string */
) ;

void far str_invnames                      /* Inverts first and last names */
(
   char huge *string                                      /* Ptr to string */
) ;

char huge * far str_center                             /* Centers a string */
(
   char huge *string,                                     /* Ptr to string */
   int       area_length                                 /* Length of area */
) ;


#ifdef __cplusplus
}
#endif


/* End Source File ------------------------------------------------------- */

#endif