#if !defined (TINPUT)                // Prevents multiple declarations errors
#define TINPUT


/*
   Module        : TINPUT.HPP
   Version       : 2.0
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Gets an input from keyboard or mouse, optionally using a
                   filter and context sensitive help text.
*/


// Headers ------------------------------------------------------------------

#include <dir.h>
#include <stdio.h>


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions
#define MOUSE_INT 0x33                            // Mouse's interrupt number


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions

struct input_info                     // Holds keyboard and mouse input infos
{
   int  key_code ;                            // Ascii code of last char read
   bool key_lshift ;            // TRUE if left shift key is pressed on input
   bool key_rshift ;           // TRUE if right shift key is pressed on input
   bool key_lctrl ;              // TRUE if left CTRL key is pressed on input
   bool key_rctrl ;             // TRUE if right CTRL key is pressed on input
   bool key_lalt ;                // TRUE if left ALT key is pressed on input
   bool key_ralt ;               // TRUE if right ALT key is pressed on input
   int  mouse_row ;        // Row position if mouse's left button was pressed
   int  mouse_col ;        // Col position if mouse's left button was pressed
} ;

struct hlp_idx                                 // To build index to help file
{
   int          hlpctx ;                               // Help context number
   long int     filepos ;         // Position of context in help file (*.hlp)
   word         hlplength ;                // Number of chars in this context
   hlp_idx huge *next ;                         // Ptr to next struct in list
} ;


// Prototypes ---------------------------------------------------------------

class tinput
{
   bool          mouse_exists ;             // TRUE: A mouse driver was found
   bool          mouse_visible ;                    // TRUE: Mouse is visible
   bool          help_in_use ;  // TRUE: Help is in use (Don't use F1 again!)
   int           last_hlpctx ; // Last input help context given to input::get
   hlp_idx huge  *hifirst ;           // Ptr to first help_idx struct in list
   char          pathtohelp[MAXPATH] ;          // Complete path to help file


public:

far tinput () ;                                                // Constructor

far ~tinput () ;                                                // Destructor

void far tinput::mouse_init () ;                         // Initialises mouse

int far tinput::mouse_status () ;                   // Mouse's current status

void far tinput::mouse_show () ;                      // Shows mouse's cursor

void far tinput::mouse_hide () ;                      // Hides mouse's cursor

bool far tinput::mouse_lb_down () ;   // Tells if mouse's left button is down

void far tinput::mouse_pos                   // Gets current mouse's position
(
   int huge *row,                                   // To return row position
   int huge *col                                    // To return col position
) ;

int far tinput::get                             // Gets a keyb or mouse input
(
   input_info huge *ii=NULL,                      // Ptr to input_info struct
   int             filter=0,                  // Valid key code, or 0 for all
   int             hlpctx=EV_NOHLPCTX,       // Context number while in {get}
   bool            buffer=FALSE      // TRUE: Reads from keyb or mouse buffer
) ;


private:

void far tinput::onlinehelp                           // Displays online help
(
   int hlpctx                                          // Help context number
) ;

} ;


// --------------------------------------------------------------------------

extern tinput input ;                    // Reference to global tinput object


// End Header File ----------------------------------------------------------

#endif
