#include "blkmenu.h"

BlockMenu::BlockMenu(rect coord, char* fName, char* h, int shadow,
	       char* HOT, char** ITEMSTRINGS,
	       rect STATUSPOS, int STATUSTYPE, char** STATUSSTRINGS,
	       int* STATUSLIST, int res, BORDERS b_type,
	       BORDERS hdr_b_type, int pat, int hdr_pat, int elem_pat,
               int menu_pat)
	: Block(coord, fName, "", shadow,
	       res, b_type, NO_BORDER, pat, hdr_pat, elem_pat)
    {
    menu = new TextMenu(rect(coord.origin.X + 3 + textX(shadow),
             coord.origin.Y + 1 + textY(shadow),
	     coord.corner.X - 3 - textX(shadow),
	     coord.corner.Y - 1 - textY(shadow)),
	     "", h, HOT, 1, 1, ITEMSTRINGS, STATUSPOS,
	       STATUSTYPE, STATUSSTRINGS, STATUSLIST,
	       FIXED, 0, b_type, hdr_b_type, menu_pat, hdr_pat);

    menu->set_ret(1);

    insert(menu, 1);

    assign(menu, left_element, AC_LEFT);
    assign(menu, right_element, AC_RIGHT);
    assign(menu, up_element, AC_UP);
    assign(menu, dn_element, AC_DOWN);
    assign(menu, cancel_element, AC_CANCEL);
    assign(menu, pg_up_element, AC_PG_UP);
    assign(menu, pg_dn_element, AC_PG_DN);
    }
////////////////////////
void BlockMenu::rearrange()
    {
    Block::rearrange();
    rect coord = textRect(w1->bound());

    menu->repose(rect(coord.origin.X + 3 + textX(w1->get_shadow()),
                      coord.origin.Y + 1 + textY(w1->get_shadow()),
		      coord.corner.X - 3 - textX(w1->get_shadow()),
		      coord.corner.Y - 1 - textY(w1->get_shadow())));
    }
/////////////////////////
void BlockMenu::hide()
    {
    menu->hide();
    w1->hide();
    }
///////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    char* LIST[] = { "1. one", "2. two", "3. three", "4. four",
                     "5. five", "6. six", "7. seven", "8. eight",
		     "9. nine", "" };

    BlockMenu m(rect(10, 10, 60, 20), "window.pcy", "Block Menu", 6,
	       "123456789", LIST, rect(0, 24, 79, 25), STRING_STATUS,
	       LIST, NULL, MOVE | RESIZE | SCROLL_VERT | SCROLL_HORIZ,
	       SHOW_BORDER, SHOW_BORDER, 11, 14, 13, 16);

    m.show_window();
    m.exe();
    m.hide();
    close_KNOW_HOW();
    closegraph();
    }

*/