#include "icon.h"
#include "process.h"
#include "image_p.h"

void save_image(char* fName, loc pos, int type)
    {
    int i_size;    // save icon
    loc size = icon_size(type);
    i_size = (size.X + 1 + 7) / 8 * 4 * (size.Y + 1)+ sizeof(imageP);
    void* image = (void*)malloc(i_size + 10);
    getimage(pos.X, pos.Y, pos.X + size.X, pos.Y + size.Y, image);
    FILE *stream;
    if(!((stream = fopen(fName, "a+b")) == NULL))
	fwrite(image, i_size, 1, stream); /* write to file */
    fclose(stream); /* close file */
    delete image;
    }
/////////////////////////
imageP get_image(char* fName, int type, int num)
    {
    FILE *stream;
    if((stream = fopen(fName, "r+b")) == NULL)
	return NULL;
    loc size = icon_size(type);
    int i_size = ((size.X + 1 + 7) >> 3 << 2) * (size.Y + 1) + sizeof(imageP);
    imageP image = (imageP)malloc(i_size + 10);
    get_image(stream, num, image, i_size);
    fclose(stream);
    return image;
    }
/////////////////////////
void get_image(FILE* stream, int num, imageP image, int i_size)
    {
    long pos = (long)i_size * (num - 1);
    fseek(stream, pos, SEEK_SET);
    fread(image, i_size, 1, stream);
    }
///////////////////////////////
void Icon::show()
    {
    imageP im;
    if((im = extract()) == NULL)
	return;
    mouseHideCursor();
    rect dest = screenRect(rectangle);
    put_image_correct(im, dest);
    Frame::show();
    delete im;
    mouseShowCursor();
    }
////////////////////////
void Icon::press()
    {
    hilite();
    Press::press();
    }
////////////////////////
void Icon::release()
    {
    unhilite();
    Press::release();
    }
////////////////////////
void Icon::icon_set(loc c, int n)
    {
    rectangle =	rect(c, c + pScreenSet->icon_types[type]);
    num = n;
    }
//////////////////////////
char* Icon::icon_open()
    {
    char* resName;
    switch(pScreenSet->g_driver)
	{
	case EGA:
	    switch(pScreenSet->g_mode)
		{
		case EGALO:
		    switch(type)
			{
			case 1: resName = "egalo1.res"; break;
			case 2: resName = "egalo2.res"; break;
			case 3: resName = "egalo3.res"; break;
			}
		    break;
		case EGAHI:
		    switch(type)
			{
			case 1: resName = "egahi1.res"; break;
			case 2: resName = "egahi2.res"; break;
			case 3: resName = "egahi3.res"; break;
			}
		    break;
		}
	    break;
	case VGA:
	    switch(pScreenSet->g_mode)
		{
		case VGALO:
		    switch(type)
			{
			case 1: resName = "egalo1.res"; break;
			case 2: resName = "egalo2.res"; break;
			case 3: resName = "egalo3.res"; break;
			}
		    break;
		case VGAMED:
		    switch(type)
			{
			case 1: resName = "egahi1.res"; break;
			case 2: resName = "egahi2.res"; break;
			case 3: resName = "egahi3.res"; break;
			}
		    break;
		case VGAHI:
		    switch(type)
			{
			case 1: resName = "vgahi1.res"; break;
			case 2: resName = "vgahi2.res"; break;
			case 3: resName = "vgahi3.res"; break;
			}
		    break;
		}
	    break;
	}
    return resName;
    }
//////////////////////////
imageP Icon::extract()
    {
    char* resName = icon_open();
    return get_image(resName, type, num);
    }
////////////////////////////////
void Icon::hilite()
    {
    rect r = screenRect(rectangle);
    void* image = (void*)malloc(imagesize(r.origin.X, r.origin.Y,
				r.corner.X, r.corner.Y));
    getimage(r.origin.X, r.origin.Y,
	     r.corner.X, r.corner.Y, image);
    putimage(r.origin.X, r.origin.Y, image, NOT_PUT);
    delete image;
    }
//////////////////////////
loc icon_size(int icon_type)
    {
    loc size;
    switch(icon_type)
	{
	case 1: size = pScreenSet->ICON_PIXELS_1;
	    break;
	case 2: size = pScreenSet->ICON_PIXELS_2;
	    break;
	case 3: size = pScreenSet->ICON_PIXELS_3;
	    break;
	}
    return size;
    }
////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Icon i(loc(1, 1), 2, LARGE_ICON, SHOW_BORDER);
    i.show();
    i.exe();

    close_KNOW_HOW();
    closegraph();
    }
*/
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Icon i(loc(1, 1), 2, LARGE_ICON, SHOW_BORDER);
    char* file = i.icon_open();

    FILE *stream;
    if((stream = fopen(file, "r+b")) == NULL)
	return;
    loc size = icon_size(LARGE_ICON);
    int i_size = ((size.X + 1 + 7) >> 3 << 2) * (size.Y + 1) + sizeof(imageP);
    imageP image = (imageP)malloc(i_size + 10);
    for(int k = 0; k < 10; k++)
        for(int j = 1; j < 15; j++)
            {
            get_image(stream, j, image, i_size);
            putimage(10, 10, image, COPY_PUT);
            }
    fclose(stream);
    delete image;
    close_KNOW_HOW();
    closegraph();
    }
*/