/*  IMAGE.H    This file contains the simple toolkit for working with images.
	Images are in the getimage() formate. We use the postulate, that
	color pictures have 4 planes, and BW pictures - one.
*/

#ifndef __IMAGE_H_
#define __IMAGE_H_

#include <alloc.h>
#include "graphpp.h"
#include "image_p.h"

enum { BW, COLOR };

/*
    Read pixel color from image.
*/
extern int image_get_pixel(imageP image, loc pos, int bitpx = 1,
                           int nplanes = 4);
/////////////////////////
/*
    Put pixel to the image, changing all planes, if necessary.
*/
extern void image_put_pixel(imageP image, loc pos, int col,
			    int bitpx = 1, int nplanes = 4);
/////////////////////////
/*
    Shows part of image on screen with deformation.
    Arguments: src - rectangle in source image, dest - left-top coordinates
               on screen, ... , comp_s and comp_d - deformation of source
               and destination, it corresponds to divx, divy, multx, multy,
	       flag == 1 - use image_get_pixel - for pixel - to - pixel
	       (not byte - to byte) output, trans contains directive to
	       use one of the colors as transparent (do not show it).
               Default value is 16 (no transparent color).
*/
extern void image_screen(imageP image, rect src, loc dest,   // src - in image, dest - on screen
		 int bitpx = 1, int nplanes = 4,
		 loc comp_s = loc(1, 1),
		 loc comp_d = loc(1, 1), int flag = 0);

/*
    Copies part of screen to the part of image, no deformation.
*/
extern void screen_image(imageP image, rect scr, loc dest); // no deformation

#endif __IMAGE_H_