
//#define WANT_STREAM

#include "include.h"

#include "newmat.h"


/**************************** test program ******************************/

void Print(const Matrix& X);
void Print(const UpperTriangularMatrix& X);
void Print(const DiagonalMatrix& X);
void Print(const SymmetricMatrix& X);
void Print(const LowerTriangularMatrix& X);

void trymat6()
{
//   cout << "\nSixth test of Matrix package\n";
   Tracer et("Sixth test of Matrix package");
   Exception::PrintTrace(TRUE);

   int i,j;


   DiagonalMatrix D(6);
   UpperTriangularMatrix U(6);
   for (i=1;i<=6;i++) { for (j=i;j<=6;j++) U(i,j)=i*i*i-50; D(i,i)=i*i+i-10; }
   LowerTriangularMatrix L=(U*3.0).t();
   SymmetricMatrix S(6);
   for (i=1;i<=6;i++) for (j=i;j<=6;j++) S(i,j)=i*i+2.0+j;
   Matrix MD=D; Matrix ML=L; Matrix MU=U; Matrix MS=S;
   Matrix M(6,6);
   for (i=1;i<=6;i++) for (j=1;j<=6;j++) M(i,j)=i*j+i*i-10.0;  
   {
      Tracer et1("Stage 1");
      Print(Matrix(MS+(-MS)));
      Print(Matrix((S+M)-(MS+M)));
      Print(Matrix((M+U)-(M+MU)));
      Print(Matrix((M+L)-(M+ML)));
   }
   {
      Tracer et1("Stage 2");
      Print(Matrix((M+D)-(M+MD)));
      Print(Matrix((U+D)-(MU+MD)));
      Print(Matrix((D+L)-(ML+MD)));
      Print(Matrix((-U+D)+MU-MD));
      Print(Matrix((-L+D)+ML-MD));
   }
   {
      Tracer et1("Stage 3 - concatenate");
      RowVector A(5);
      A << 1 << 2 << 3 << 4 << 5;
      RowVector B(5);
      B << 3 << 1 << 4 << 1 << 5;
      Matrix C(3,5);
      C <<  2 <<  3 <<  5 <<  7 << 11
        << 13 << 17 << 19 << 23 << 29
        << 31 << 37 << 41 << 43 << 47;
      Matrix X1 = A & B & C;
      Matrix X2 = (A.t() | B.t() | C.t()).t();
      Matrix X3(5,5);
      X3.Row(1)=A; X3.Row(2)=B; X3.Rows(3,5)=C;
      Print(Matrix(X1-X2));
      Print(Matrix(X1-X3));
      LowerTriangularMatrix LT1; LT1 << (A & B & C);
      UpperTriangularMatrix UT1; UT1 << (A.t() | B.t() | C.t());
      Print(LowerTriangularMatrix(LT1-UT1.t()));
      DiagonalMatrix D1; D1 << (A.t() | B.t() | C.t());
      ColumnVector At = A.t();
      ColumnVector Bt = B.t();
      Matrix Ct = C.t();
      LowerTriangularMatrix LT2; LT2 << (At | Bt | Ct);
      UpperTriangularMatrix UT2; UT2 << (At.t() & Bt.t() & Ct.t());
      Matrix ABt = At | Bt;
      DiagonalMatrix D2; D2 << (ABt | Ct);
      Print(LowerTriangularMatrix(LT2-UT2.t()));
      Print(DiagonalMatrix(D1-D2));
      Print(Matrix(LT1+UT2-D2-X1));
      Matrix M1 = LT1 | UT2; Matrix M2 = UT1 & LT2;
      Print(Matrix(M1-M2.t()));
      M1 = UT2 | LT1; M2 = LT2 & UT1;
      Print(Matrix(M1-M2.t()));
      M1 = (LT1 | UT2) & (UT2 | LT1);
      M2 = (UT1 & LT2) | (LT2 & UT1);
      Print(Matrix(M1-M2.t()));
      SymmetricMatrix SM1; SM1 << (M1 + M1.t());
      SymmetricMatrix SM2; SM2 << ((SM1 | M1) & (M1.t() | SM1));
      Matrix M3(20,20);
      M3.SubMatrix(1,10,1,10) = SM1;
      M3.SubMatrix(1,10,11,20) = M1;
      M3.SubMatrix(11,20,1,10) = M2;
      M3.SubMatrix(11,20,11,20) = SM1;
      Print(Matrix(M3-SM2));
   }


//   cout << "\nEnd of sixth test\n";
}

