#include	<stdio.h>
#include	<dos.h>

/*
	by	Tom Zimniewicz

	this file is one of three, the others are excom.asm and excom.txt
*/

/*
	(C) 1987, Crystal Computer Consulting Inc.
	This software may be used freely, at your own risk,
	as long as this notice is not removed.
*/

#define	EXINIT	4		/* ah value for extended init */
#define	EXREM	5		/* ah value to remove excom */
#define	EXCOM	0x5A5A		/* magic value to identify excom */
#define	NOCTS	0x00000010	/* CTS not required for transmit */
#define	NODSR	0x00000020	/* DSR not required for transmit */
#define	DTR	0x00000100	/* DTR input flow control */
#define	RTS	0x00000200	/* RTS input flow control */
#define	XNXFIN	0x00010000	/* XON/XOFF input flow control */
#define	XNXFOUT	0x00020000	/* XON/XOFF output flow control */
#define	ANYXOUT	0x00040000	/* any char restarts output after XOFF */
#define	B19200	0x00100000	/* set baud rate to 19200 */
#define	B38400	0x00200000	/* set baud rate to 38400 */
#define	COMINIT	0x80000000	/* port was selected */

typedef struct {
	char
		*str;		/* command string */
	void
		(*fnct)();	/* command to execute */
	long
		arg;		/* argument to pass */
} CMDS;				/* exmode command table */

char
	*insmsg = "excom installed",
	*remmsg = "excom not installed",
	*helpmsg;
int
	portnum = -1;		/* port to initialize */
long
	init1 = 0,		/* extended init for com1 */
	init2 = 0;		/* extended init for com2 */
void
	exit(), install(), remcom(), exinit(), setport();
CMDS
	cmds[] = {
		"install",	install,	0,
		"remove",	remcom,		0,
		"com1",		setport,	0,
		"com2",		setport,	1,
		"nocts",	exinit,		NOCTS,
		"nodsr",	exinit,		NODSR,
		"dtr",		exinit,		DTR,
		"rts",		exinit,		RTS,
		"xnxfin",	exinit,		XNXFIN,
		"xnxfout",	exinit,		XNXFOUT,
		"anyxout",	exinit,		ANYXOUT,
		"19200",	exinit,		B19200,
		"38400",	exinit,		B38400,
		NULL
	};


main(argc, argv)
int
	argc;
register char
	**argv;
{
	register CMDS
		*cmdp;

	/* is excom installed */
	if (int14(EXINIT, 0L, 0) == EXCOM && int14(EXINIT, 0L, 1) == EXCOM)
		helpmsg = insmsg;
	else
		helpmsg = remmsg;

	if (argc == 1)
		help(helpmsg);

	while (*++argv != NULL) {
		/* look up the argument in the command table */
		for (cmdp = cmds;  cmdp->str != NULL;  ++cmdp)
			if (strcmp(*argv, cmdp->str) == 0)
				break;

		if (cmdp->str == NULL)
			help("bad command");

		else {
			/* excom must be installed to set options */
			if (helpmsg == remmsg && cmdp->fnct != install)
				help(helpmsg);

			/* execute the command */
			(*cmdp->fnct)(cmdp->arg);
		}
	}

	if ((init1 & (B19200 | B38400)) == (B19200 | B38400)
	    || (init2 & (B19200 | B38400)) == (B19200 | B38400))
		help("ambiguous baud rate setting");

	/* actually send the init bits to excom */
	if ((init1 & COMINIT) != 0)
		int14(EXINIT, init1, 0);

	if ((init2 & COMINIT) != 0)
		int14(EXINIT, init2, 1);

	exit(0);
}


/* install excom */
void
install()
{
	system("excom");
	helpmsg = insmsg;
}


/* remove excom */
void
remcom()
{
	int14(5, 0L, 0);
	helpmsg = remmsg;
}


/* collect up the init bits for each port */
void
exinit(thebit)
long
	thebit;
{
	if (portnum == -1)
		help("no port selected");

	else if (portnum == 0)
		init1 |= thebit;

	else
		init2 |= thebit;
}


/* set port number */
void
setport(newport)
long
	newport;
{
	portnum = newport;

	if (portnum == 0)
		init1 |= COMINIT;

	else
		init2 |= COMINIT;
}


/* perform int 14h with ah, al, bx & dx as passed, return ax value */
int14(cmd, val, port)
int
	cmd;
long
	val;
int
	port;
{
	union REGS
		ir,		/* registers send to bios */
		or;		/* registers returned from bios */

	ir.h.ah = cmd;
	ir.h.al = val >> 16;
	ir.x.cx = val;
	ir.x.dx = port;

	int86(0x14, &ir, &or);

	return or.x.ax;
}


/* provide a bit of assistance */
help(msg)
char
	*msg;
{
	printf("\n%s\n\n", msg);

	fputs("install\t\tinstall excom\n", stdout);
	fputs("remove\t\tremove excom\n", stdout);
	fputs("com1\t\tsubsequent commands for com1\n", stdout);
	fputs("com2\t\tsubsequent commands for com2\n", stdout);
	fputs("nocts\t\tdon't require CTS to transmit\n", stdout);
	fputs("nodsr\t\tdon't require DSR to transmit\n", stdout);
	fputs("dtr\t\tuse DTR for input flow control\n", stdout);
	fputs("rts\t\tuse RTS for input flow control\n", stdout);
	fputs("xnxfin\t\tuse XON/XOFF (^S ^Q) input flow control\n", stdout);
	fputs("xnxfout\t\tuse XON/XOFF (^S ^Q) output flow control\n", stdout);
	fputs("anyxout\t\tany char will restart after XOFF\n", stdout);
	fputs("19200\t\tset baud rate\n", stdout);
	fputs("38400\t\tset baud rate\n", stdout);

	exit(1);
}
