/*
	mem.h
	
	definition info for memory management
	
	William May
	
	created:	3/25/87
*/

#define SYSERR -1

/*
 * roundew, truncew - round up or truncate address to the next
 * even word.
 */

#define roundew(x)	(int *)((3 + (long)(x)) & (~3))
#define truncew(x)	(int *)(((long)(x)) & (~3))

#define DEFSIZE  (150000)	/* default size for a new pool */

/*
 * node structure for each node in the free memory list
 */
struct mblock {
	struct mblock *mnext;
	unsigned long mlen;
};

/*
 * structure for pools
 */
struct pool {
	struct pool *pnext;
	struct mblock firstblock;
};
