/*
	Copyright (C) 1987 Paradigm Systems Inc.  All rights reserved.
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<signal.h>

#include	"loc.h"
#include	"globals.h"
#include	"externs.h"

/*
	LOCATE *** MS-DOS ROM Utility
	Copyright (C) 1987 Paradigm Systems, Inc.  All rights reserved.

	This version is released in the public domain and may not be sold.
*/

int	main(argc, argv)
int argc;
char *argv[];
{
	char	*s, *input_file ;
	unsigned char	*entry_point ;
	int	i ;

	/*
		This is the root module of the locate utility and it controls the
		sequencing of the entire location process.
	*/

	/* Install a Control-C interrupt handler */
	if (signal(SIGINT, break_handler) == (int(*)()) -1)   {
		fprintf(stderr, "Failure to install break handler\n") ;
		abort() ;
	}

	/* Build a command line string using argv[0] through argv[argc-1] */
	command_line[0] = '\0' ;
	for (i = 0; i < argc; i++)   {
		strcat(command_line, argv[i]) ;
		strcat(command_line, " ") ;
	}

	/* Test if the user needs help in running this utility */
	if (argc == 1)
		help = TRUE ;

	config_fname[0] = abs_fname[0] = print_fname[0] = '\0' ;
	
	/* Process each argument in sequence until all are processed */
	while (--argc > 0 && (*++argv)[0] == '-')   {
		for (s = argv[0] + 1;  *s != '\0';  s++)   {
			switch (*s)   {
				case 'b':
					boot_rec = TRUE ;
					break ;

				case 'c':
					config = TRUE ;
					if (*++s)
						strcpy(config_fname, s) ;
					*s-- = '\0' ;
					break ;

				case 'h':
					hex_name = TRUE ;
					if (*++s)
						strcpy(abs_fname, s) ;
					*s-- = '\0' ;
					break ;

				default:
					help = TRUE ;
					argc = 0 ;
					break ;
			}
		}
	}
	input_file = argv[0] ;

	if (help == TRUE)   {
		fprintf(stderr, "\nUsage is\n\n") ;
		fprintf(stderr, "\tlocate switches exefile\n\n") ;
		fprintf(stderr, "The valid switches are:\n\n") ;
		fprintf(stderr, "\t%-14s create bootstrap record\n", "-b") ;
		fprintf(stderr, "\t%-14s configuration filename\n", "-c[name]") ;
		fprintf(stderr, "\t%-14s hex filename\n", "-h[name]") ;
		exit(1) ;
	}

	fprintf(stderr, "                 MS-DOS Locate Utility - Version 1.0A\n") ;
	fprintf(stderr, "        Copyright (C) 1987 Paradigm Systems Inc.  ") ;
	fprintf(stderr, "All rights reserved.\n\n") ;
	fprintf(stderr, "Public Domain Software courtesy of\n") ;
	fprintf(stderr, "        Paradigm Systems, Inc.\n        P.O. Box 152\n") ;
	fprintf(stderr, "        Milford, MA 01757\n\n") ;

	/* Open and create the files used in the location process */
	open_file_system(input_file) ;
	
	/* Install the routine to shutdown the utility gracefully in the
		event of an error. */
	onexit(close_file_system) ;

	/* Build the segment descriptor list using the link map */
	seg_list = build_seg_list();

	/* Process the locate configuration file */
	if (process_locate_file(seg_list) == ERROR)   {
		fprintf(stderr, "Error(s) reading the locate map\n") ;
		exit(1) ;
	}

	/* Convert any public symbols to their new physical addresses */
	read_symbol_table(seg_list) ;
	
	/* Read the load module and perform the segment fixups */
	entry_point = load_exe_file() ;

	/* Add a bootstrap record if enabled on the command line */
	if (boot_rec == TRUE)
		create_bootstrap(seg_list, entry_point) ;

	/* Output the load module in the specified format */
	output_hex_OMF(abs_file, seg_list, entry_point) ;

	/* Make the locate map containing the new segment assignments */
	print_statistics(map_fname, print_fname, command_line, exe_fname, \
		abs_fname, config_fname, entry_point) ;

	exit(0) ;
}


void	break_handler()
{
	/*
		The break handler is provided to catch Ctrl-C interrupts from the
		user and perform a shutdown of the program in a graceful manner.
	*/
		
	/* Set the user abort flag for the file system close routine */
	user_abort = TRUE ;
	exit(1) ;
}

