/* ----------- microsft.c ------------ */

/*
 *  Surrogate Turbo C functions
 *  for Microsoft C users.
 */

#include <dos.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <conio.h>
#include <bios.h>

/* -------- One of these is your Display Adapter -------- */
#define MDA 1           /* Monochrome Display Adapter */
#define CGA 2           /* Color Graphics Adapter     */
#define EGA 3           /* Enhanced Graphics Adapter  */
#define VGA 4           /* Video Graphics Array       */

#define ADAPTER EGA     /* Specifies the Display Adapter */

#if ADAPTER==MDA
#define VSEG 0xb000     /* VSEG is the video memory segment */
#else
#define VSEG 0xb800
#endif

#if ADAPTER==CGA
#define SNOW 1
/* --- assembly language vpeek.asm: manages CGA flicker --- */
void vpoke(unsigned adr, unsigned off, int ch);
int vpeek(unsigned adr, unsigned off);
#else
#define SNOW 0
/* ---- macros for vpeek and vpoke for non-CGA systems ---- */
#define MKFP(s,o)    (((long)s<<16)|o)
#define vpoke(a,b,c) (*((int  far*)MKFP(a,b))=c)
#define vpeek(a,b)   (*((int  far*)MKFP(a,b)))
#endif

static union REGS rg;

/* --- a structure defined within Turbo C and used by us --- */
struct {
    char filler1[4];
    char attribute;     /* saves the current video attribute */
    char filler2[5];
    char snow;          /* says if the adapter snows */
} _video;

static int wlf,wtp,wrt,wbt; /* current window corners */
static int wx,wy;           /* current window cursor  */

/* ------- define a video window ---------- */
void window(int lf,int tp,int rt,int bt)
{
    wlf = lf;
    wtp = tp;
    wrt = rt;
    wbt = bt;
    _video.snow = (char ) SNOW;
}

/* ------ makes a video offset from x,y coordinates ----- */
#define vaddr(x,y) (((y)-1)*160+((x)-1)*2)

/* -- makes far pointer to video RAM from x,y coordinates -- */
void far * pascal __vptr(int x, int y)
{
    void far *vp;

    FP_SEG(vp) = VSEG;
    FP_OFF(vp) = vaddr(x,y);
    return vp;
}

/* ---- writes a block of memory to video ram ----- */
void pascal __vram(int far *vp, int far *bf, int len)
{
    while(len--)    {
        vpoke(VSEG, FP_OFF(vp), *bf++);
        vp++;
    }
}

/* ---- gets a block of memory from video ram ----- */
void pascal __getvram(int far *vp, int far *bf, int len)
{
    while(len--)    {
        *bf++ = vpeek(VSEG, FP_OFF(vp));
        vp++;
    }
}

/* ----- writes a memory block to a video window ----- */
void puttext(int lf,int tp,int rt,int bt,char *sv)
{
    while (tp < bt+1)   {
        __vram(__vptr(lf, tp), (int far *) sv, rt+1-lf);
        tp++;
        sv += (rt+1-lf)*2;
    }
}

/* ----- reads a memory block from a video window ------ */
void gettext(int lf,int tp,int rt,int bt,char *sv)
{
    while (tp < bt+1)   {
        __getvram(__vptr(lf, tp), (int far *) sv, rt+1-lf);
        tp++;
        sv += (rt+1-lf)*2;
    }
}

/* ------ moves a video window (used for scrolling) ------ */
void movetext(int lf, int tp, int rt, int bt, int lf1, int tp1)
{
    int nolines = bt - tp + 1;
    int incr = tp - tp1;
    int len, i;
    unsigned src, dst;

    if (tp > tp1)   {
        src = tp;
        dst = tp1;
    }
    else    {
        src = bt;
        dst = tp1+nolines-1;
    }
    while (nolines--)   {
        len = rt - lf + 1;
        for (i = 0; i < len; i++)
            vpoke(VSEG, vaddr(lf1+i, dst),
                vpeek(VSEG,vaddr(lf+i, src)));
        src += incr;
        dst += incr;
    }
}

/* ----- position the window cursor ------ */
void gotoxy(int x,int y)
{
    wx = x;
    wy = y;
    rg.h.ah = 15;
    int86(16, &rg, &rg);
    rg.x.ax = 0x0200;
    rg.h.dh = wtp + y - 2;
    rg.h.dl = wlf + x - 2;
    int86(16, &rg, &rg);
}

/* ----- return the window cursor x coordinate ----- */
int wherex(void)
{
    return wx;
}

/* ----- return the window cursor y coordinate ----- */
int wherey(void)
{
    return wy;
}

/* ----- sets the window foreground (text) color ------- */
void textcolor(int cl)
{
    _video.attribute = (_video.attribute & 0xf0) | (cl&0xf);
}

/* ----- sets the window background color ------- */
void textbackground(int cl)
{
    _video.attribute = (_video.attribute & 0x8f) | ((cl&7)<<4);
}

void writeline(int, int, char *);

/* ------ our substitution for MSC cprintf -------- */
void wprintf(char *ln, ...)
{
    char dlin [81], *dl = dlin, ch;
    int cl[81], *cp = cl;
    va_list ap;

    va_start(ap, ln);
    vsprintf(dlin, ln, ap);
    va_end(ap);

    while (*dl) {
        ch = (*dl++ & 255);
        if (!isprint(ch))
            ch = ' ';
        *cp++ = ch | (_video.attribute << 8);
    }
    __vram(__vptr(wx+wlf-1,wy+wtp-1),
            (int far *) cl, strlen(dlin));
    wx += strlen(dlin);
}

/* ------ our substitution for MSC putch -------- */
void wputch(c)
{
    if (!isprint(c))
        putch(c);
    wprintf("%c", c);
}

/* ------ our substitution for MSC getch -------- */
int wgetch(void)
{
    static unsigned ch = 0xffff;

    if ((ch & 0xff) == 0)   {
        ch++;
        return (ch >> 8) & 0x7f;
    }
    ch = _bios_keybrd(_KEYBRD_READ);
    return ch & 0x7f;
}
