#define FIFOSIZE   1024

struct fifohdr {
  int count;
  unsigned char *inptr;
  unsigned char *outptr;
};

typedef struct {
  struct fifohdr hdr;
  unsigned char data[FIFOSIZE];
} FIFO;

/* Serial Data defines */
#define COM1   0x3F8
#define COM2   0x2F8


/* Offsets from base address to 8250 UART registers */
#define Int_Enable_Reg   1
#define Int_Id_Reg       2
#define LineControl      3
#define ModemControl     4
#define LineStatus       5
#define ModemStatus      6
/* Only valid while LineControl MSB (DivBit) is turned on */
#define DLL              0    /* Baud Rate divisor Low */
#define DLM              1    /* Baud Rate divisor High */
/* Status Bit definitions */
#define DataRdyBit   0x01
#define DTRBit       0x01
#define Out2Bit      0x08
#define ORBit        0x01
#define RTSBit       0x02
#define CTSBit       0x10
#define DSRBit       0x20
#define TxRdyBit     0x20
#define RIBit        0x40
#define CDBit        0x80
/* Line Control Bits */
#define BrkBit       0x40
#define DivBit       0x80

/* 8259 Registers */
#define Int_Mask_Reg    0x21
#define Int_Cmd_Reg     0x20
#define End_Int_Cmd     0x20

