// -------- border.cpp

#include "desktop.h"
#include "dfwindow.h"

void DFWindow::AdjustBorders()
{
	BorderAdj = TopBorderAdj = BottomBorderAdj = 0;
	if (attrib & BORDER)
		BorderAdj = TopBorderAdj = BottomBorderAdj = 1;
	if (attrib & TITLEBAR)
		TopBorderAdj = 1;
}

void DFWindow::Title()
{
	if (visible && (attrib & TITLEBAR) && title != NULL)	{
		int wd = ClientWidth();
		int tlen = min(title->Strlen(), wd-4);
		String sp1((wd-tlen)/2, ' ');
		String sp2(wd - (sp1.Strlen() + tlen), ' ');
		String tlin = sp1 + title->left(tlen) + sp2;
		int fg = this == desktop.InFocus() ? WHITE : BLACK;

		WriteWindowString(tlin, BorderAdj, 0, fg, CYAN);
		if (attrib & CONTROLBOX)
			WriteWindowChar(CONTROLBOXCHAR, 2, 0, fg, CYAN);
        if (attrib & (MINBOX | MAXBOX))     {
			int tend = ClientWidth() - 1;
            if (windowstate == ISRESTORED)	{
		        if (attrib & MINBOX)
					WriteWindowChar(MINPOINTER, tend, 0, fg, CYAN);
		        if (attrib & MAXBOX)
					WriteWindowChar(MAXPOINTER, tend+1, 0, fg, CYAN);
			}
            else if (windowstate == ISMAXIMIZED)	{
				WriteWindowChar(RESTOREPOINTER, tend+1, 0, fg, CYAN);
		        if (attrib & MINBOX)
					WriteWindowChar(MINPOINTER, tend, 0, fg, CYAN);
			}
			else if (windowstate == ISMINIMIZED)
				WriteWindowChar(RESTOREPOINTER, tend+1, 0, fg, CYAN);
		}
	}
}

void DFWindow::Border()
{
	if (visible)	{
		if (attrib & BORDER)	{
	    	unsigned int lin, side, ne, nw, se, sw;
			if (DblBorder && this == desktop.InFocus())	{
        		lin  = FOCUS_LINE;
        		side = FOCUS_SIDE;
        		ne   = FOCUS_NE;
        		nw   = FOCUS_NW;
        		se   = FOCUS_SE;
        		sw   = FOCUS_SW;
    		}
    		else    {
        		lin  = LINE;
        		side = SIDE;
        		ne   = NE;
        		nw   = NW;
        		se   = SE;
        		sw   = SW;
    		}
			int wd = ClientWidth();
			int ht = Height() - 1;
			int rt = Width() - 1;

			String line(wd, lin);

			// ------- top border
			int fg = colors.ffg;
			int bg = colors.fbg;
			WriteWindowChar(nw, 0,  0, fg, bg);
			WriteWindowChar(ne, rt, 0, fg, bg);
			if (!(attrib & TITLEBAR))
				WriteWindowString(line, 1, 0, fg, bg);

			// ------ side borders
			for (int y = 1; y < ht; y++)	{
				WriteWindowChar(side, 0, y, fg, bg);
				if (windowstate != ISRESTORED || !(attrib & VSCROLLBAR))
					WriteWindowChar(side, rt, y, fg, bg);
			}

			// ----- bottom border
			WriteWindowChar(sw, 0,  y, fg, bg);
			WriteWindowChar(se, rt, y, fg, bg);
			if (windowstate != ISRESTORED ||
					!(attrib & (HSCROLLBAR | STATUSBAR)))
				WriteWindowString(line, 1, y, fg, bg);
		}
		Title();
	}
}

void DFWindow::Shadow()
{
	if (windowstate == ISRESTORED && visible && (attrib & SHADOW))	{
		int lf = Left();
		int tp = Top();
		int ht = Height();
		int wd = Width();
		int x = wd;
		int c;
		for (int y = 1; y < ht; y++)	{
	    	c = desktop.screen().GetVideoChar(x+lf, y+tp);
			WriteWindowChar(c, x, y, ShadowFG, ShadowBG);
		}
		String ln(wd, ' ');
		for (x = 0; x < wd; x++)
	    	ln[x] = desktop.screen().GetVideoChar(x+1+lf, y+tp);
		WriteWindowString(ln, 1, y, ShadowFG, ShadowBG);
	}
}



