// ------------- focus.cpp

#include "dflatpp.h"

void DFWindow::CaptureFocus()
{
	if (this != desktop.FocusCapture())	{
		if (desktop.FirstCapture() == NULL)
			desktop.SetFirstCapture(desktop.InFocus());
		prevcapture = desktop.FocusCapture();
		desktop.SetFocusCapture(this);
		SetFocus();
	}
}

void DFWindow::ReleaseFocus()
{
	if (this == desktop.FocusCapture())	{
		desktop.SetFocusCapture(prevcapture);
		prevcapture = NULL;
		if (desktop.FocusCapture() == NULL)	{
			if (desktop.FirstCapture() != NULL)
				desktop.FirstCapture()->SetFocus();
			desktop.SetFirstCapture(NULL);
		}
		else
			desktop.FocusCapture()->SetFocus();
	}
}

Bool DFWindow::SetFocus()
{
	if (this != desktop.InFocus())	{
		if (desktop.InFocus() != NULL)
			desktop.InFocus()->ResetFocus();
		desktop.SetFocus(this);
		Dequeue();		// move the window to the
		Enqueue();		// top of the focus queue
		Show();
		// --- notify parent that child has taken the focus
		if (parent != NULL)
			parent->EnterFocus(this);
	}
	return True;
}

void DFWindow::ResetFocus()
{
	if (parent != NULL)
		// --- notify parent that child has relinquished the focus
		parent->LeaveFocus(this);
	desktop.SetFocus(NULL);
	Border();
}

// --- set the focus to the next eligible sibling window
void DFWindow::NextSiblingFocus()
{
	DFWindow *Wnd = desktop.InFocus();
	while (Wnd != NULL)	{
		if (Wnd->next == NULL)	{
			if (Wnd->parent != NULL)
				Wnd = Wnd->parent->first;
		}
		else
			Wnd = Wnd->next;
		if (Wnd == desktop.InFocus())
			break;
		if (Wnd != NULL)
			if (Wnd->SetFocus())
				break;
	}
}

// --- set the focus to the next previous eligible sibling window
void DFWindow::PrevSiblingFocus()
{
	DFWindow *Wnd = desktop.InFocus();
	while (Wnd != NULL)	{
		if (Wnd->prev == NULL)	{
			if (Wnd->parent != NULL)
				Wnd = Wnd->parent->last;
		}
		else
			Wnd = Wnd->prev;
		if (Wnd == desktop.InFocus())
			break;
		if (Wnd != NULL)
			if (Wnd->SetFocus())
				break;
	}
}

// --------- add the window to the linked list
void DFWindow::Enqueue()
{
	next = prev = NULL;
	if (parent != NULL)	{
    	if (parent->first == NULL)
        	parent->first = this;
		prev = parent->last;
    	if (prev != NULL)
			prev->next = this;
		parent->last = this;
	}
	else if (desktop.ApplWnd() == NULL)
		desktop.SetApplication(this);
}

// --------- remove the window from the linked list
void DFWindow::Dequeue()
{
	if (parent != NULL)	{
    	if (prev != NULL)
			prev->next = next;
    	if (next != NULL)
			next->prev = prev;
    	if (this == parent->first)
			parent->first = next;
    	if (this == parent->last)
			parent->last = prev;
	}
	else if (this == desktop.ApplWnd())
		desktop.SetApplication(NULL);
}



