// ------- menusel.cpp

#include <string.h>
#include "menusel.h"

MenuSelection SelectionSeparator(SEPARATOR);
MenuSelection SelectionTerminator(TERMINATOR);

void MenuSelection::NullSelection()
{
	label = NULL;
	cmdfunction = NULL;
	type = NORMAL;
	cascade = NULL;
	isenabled = True;
	accelerator = 0;
	cascade = NULL;
	toggle = Off;
}

void MenuSelection::CommonConstructor(	char *Label,
										int Accelerator,
										void (DFWindow::*CmdFunction)(),
										Bool Active,
										MenuType Type,
										Toggle Tgl,
										MenuSelection **Cascaders)
{
	NullSelection();
	if (Label != NULL)
		label = new String(Label);
	accelerator = Accelerator;
	cmdfunction = CmdFunction;
	isenabled = Active;
	type = Type;
	toggle = Tgl;
	cascaders = Cascaders;
}

MenuSelection::MenuSelection(	char *Label,
								void (DFWindow::*CmdFunction)(),
								int Accelerator,
								Bool Active )
{
	CommonConstructor(Label, Accelerator, CmdFunction,
								Active, NORMAL, Off);
}

MenuSelection::MenuSelection(	char *Label,
								void (DFWindow::*CmdFunction)(),
								Toggle Tgl,
								int Accelerator,
								Bool Active)
{
	CommonConstructor(Label, Accelerator, CmdFunction,
							Active, TOGGLE, Tgl);
}

MenuSelection::MenuSelection(char *Label,
							MenuSelection **Cascaders,
							int Accelerator,
							Bool Active )
{
	CommonConstructor(Label, Accelerator, NULL,
							Active, CASCADER, Off, Cascaders);
}

MenuSelection::MenuSelection(MenuType Type)
{
	NullSelection();
	type = Type;
}



