// ------------- radio.cpp

#include "radio.h"
#include "desktop.h"

RadioButton::RadioButton(char *lbl, int lf, int tp, DFWindow *par)
				: TextBox(lf, tp, 1, strlen(lbl)+5, par)
{
	OpenWindow();
	String lb("( ) ");
	lb += lbl;
	lb += " ";
	SetText(lb);
}

// ----------- common constructor code
void RadioButton::OpenWindow()
{
	windowtype = RadioButtonWindow;
	if (windowstate == CLOSED)
		TextBox::OpenWindow();
	SetColors();
	setting = False;
}

void RadioButton::CloseWindow()
{
    TextBox::CloseWindow();
}

// -------- set the fg/bg colors for the window 
void RadioButton::SetColors()
{
	colors.fg =
	colors.sfg =
	colors.ffg =
	colors.hfg = Parent()->ClientFG(); 
	colors.bg =
	colors.sbg =
	colors.fbg =
	colors.hbg = Parent()->ClientBG();
	shortcutfg = RED;
}

void RadioButton::Paint()
{
	if (visible)	{
		if (isEnabled())
			WriteShortcutLine(0, colors.fg, colors.bg);
		else 
			WriteTextLine(0, colors.hfg, colors.hbg);
	}
}

Bool RadioButton::SetFocus()
{
	TextBox::SetFocus();
	desktop.cursor().normalcursor();
	desktop.cursor().SetPosition(Left()+1, Top());
	desktop.cursor().Show();
	return True;
}

void RadioButton::ResetFocus()
{
	TextBox::ResetFocus();
	desktop.cursor().Hide();
}

void RadioButton::Keyboard(int key)
{
	if (key == ' ')
		PushRadioButton();
	else 
		TextBox::Keyboard(key);
}

void RadioButton::LeftButton(int mx, int my)
{
	if (ClientRect().Inside(mx,my))
		PushRadioButton();
}

void RadioButton::PushRadioButton()
{
	int ht = desktop.screen().Height();
	DFWindow **rd = new DFWindow *[ht];
	for (int i = 0; i < ht; i++)
		rd[i] = NULL;
	// ---- build a table of radio buttons at the same x coordiate
	DFWindow *sib = Parent()->First();
	while (sib != NULL)	{
		if (sib->WindowType() == RadioButtonWindow)	{
			if (sib->Left() == Left())	{
				int tp = sib->Top();
				if (tp < ht)
					rd[tp] = sib;
			}
		}
		sib = sib->Next();
	}
    // ----- find the start of the radiobutton group
    i = Top();
    while (i >= 0 && rd[i] != NULL)
        --i;
    // ---- ignore everthing before the group
    while (i >= 0)
        rd[i--] = NULL;
    // ----- find the end of the radiobutton group
    i = Top();
    while (i < ht && rd[i] != NULL)
        i++;
    // ---- ignore everthing past the group
    while (i < ht)
        rd[i++] = NULL;
	// ------ release all the radio buttons in the group
	for (i = 0; i < ht; i++)
		if (rd[i] != NULL)
			((RadioButton *)rd[i])->ReleaseRadioButton();
	delete [] rd;
	// ----- set the chosen radio button
	setting = True;
	(*text)[1] = (char) 7;
	Paint();
}

void RadioButton::ReleaseRadioButton()
{
	setting = False;
	(*text)[1] = ' ';
	Paint();
}






