// ------------- textbox.h

#ifndef TEXTBOX_H
#define TEXTBOX_H

#include "control.h"

const int SHORTCUTCHAR = '~';
const int InitialBufferSize = 1024;

class ScrollBar;

class TextBox : public Control    {
    ScrollBar *hscrollbar;  // horizontal scroll bar
    ScrollBar *vscrollbar;  // vertical scroll bar
    unsigned *TextPointers; // -> list of line offsets
    Bool resetscrollbox;
protected:
    // ---- text buffer
    String *text;           // window text
    unsigned int bufflen;   // length of buffer
    int wlines;             // number of lines of text
    unsigned int textlen;   // text length
    int textwidth;          // width of longest line in textbox
    // ---- text display
    int wtop;               // text line on top of display
    int wleft;              // left position in window viewport
    int BlkBegLine;         // beginning line of marked block
    int BlkBegCol;          // beginning column of marked block
    int BlkEndLine;         // ending line of marked block
    int BlkEndCol;          // ending column of marked block
    int shortcutfg;         // shortcut key color
    char *TextLine(int line)
        { return (char *)(*text) + *(TextPointers+line); }
    int DisplayShortcutField(
        String sc, int x, int y, int fg, int bg);
    void WriteShortcutLine(int lno, int fg, int bg);
    void WriteTextLine(int lno, int fg, int bg);
    void BuildTextPointers();
    void SetScrollBoxes();
    virtual void SetColors();
public:
    TextBox(char *ttl,int lf,int tp,int ht,int wd,DFWindow *par)
                        : Control(ttl, lf, tp, ht, wd, par)
            { OpenWindow(); }
    TextBox(char *ttl, int ht, int wd, DFWindow *par)
                        : Control(ttl, ht, wd, par)
            { OpenWindow(); }
    TextBox(int lf, int tp, int ht, int wd, DFWindow *par)
                        : Control(lf, tp, ht, wd, par)
            { OpenWindow(); }
    TextBox(int ht, int wd, DFWindow *par) : Control(ht,wd,par)
            { OpenWindow(); }
    TextBox(char *ttl)    : Control(ttl)
            { OpenWindow(); }
    virtual ~TextBox()
        { if (windowstate != CLOSED) CloseWindow(); }
    // -------- textbox API messages
    virtual void ScrollUp();
    virtual void ScrollDown();
    virtual void ScrollRight();
    virtual void ScrollLeft();
    virtual void PageUp();
    virtual void PageDown();
    virtual void PageRight();
    virtual void PageLeft();
    virtual void Home();
    virtual void End();
    virtual void OpenWindow();
    virtual void CloseWindow();
    virtual void AddText(char *txt);
    virtual void SetText(char *txt);
    virtual void SetTextLength(unsigned int len);
    virtual void ClearText();
    virtual void Show();
    virtual void Paint();
    virtual void Keyboard(int key);
    String ExtractTextLine(int lno);
    void ClearTextBlock()
        { BlkBegLine=BlkEndLine=BlkBegCol=BlkEndCol=0; }
    void HorizontalPagePosition(int pct);
    void VerticalPagePosition(int pct);
};

#endif

