[LISTING FIVE]

// install.c -- installation program for spreadsheet app
//  compile and link with: icc /Ss /Ti install.c

#define INCL_WINWORKPLACE
#include <os2.h>
int main ( int argc, char *argv[] )
{
    HAB     hab;                    // anchor block
    HOBJECT hobjFolder;             // folder object
    HOBJECT hobjProg;               // program object
    BOOL    fSuccess;               // return from API
  // create an anchor block so we can retrieve errors
    hab = WinInitialize ( 0 );
  // create a folder on the desktop for our program object
    hobjFolder = WinCreateObject ( "WPFolder", "My Folder" 
              , "OBJECTID=<MY_FOLDER>" , "<WP_DESKTOP>" , CO_REPLACEIFEXISTS );
    if ( hobjFolder == NULLHANDLE )
    {
        ULONG   ul;             // error code
        ul = WinGetLastError ( hab );
        printf ("Unable to create folder, error = %x\n", ERRORIDERROR ( ul ) );
    }
  // register our object class for our data files
    fSuccess = WinRegisterObjectClass ( "WPSpread" 
                                       , "c:\\book\\wpsart\\wpspread.dll" );
    if ( fSuccess == FALSE )
    {
        ULONG   ul;             // error code
        ul = WinGetLastError ( hab );
        printf ("Unable to register class, error = %x\n",
                ERRORIDERROR ( ul ) );
    }
  // create a program object for our EXE file
    hobjProg = WinCreateObject ( "WPProgram", "Spreadsheet App"
                    , "EXENAME=c:\\book\\wpsart\\spread.exe;"
                      "ASSOCTYPE=XX Company Spreadsheet,,;"
                      "ASSOCFILTER=*.SPR,," , "<MY_FOLDER>"
                    , CO_REPLACEIFEXISTS );
    if ( hobjProg == NULLHANDLE )
    {
        ULONG   ul;             // error code
        ul = WinGetLastError ( hab );
        printf ("Unable to create program object, error = %x\n",
                ERRORIDERROR ( ul ) );
    }
    WinTerminate ( hab );
}
