// -------------- applicat.h

#ifndef APPLICAT_H
#define APPLICAT_H

#include "menubar.h"
#include "statbar.h"

class Application : public DFWindow    {
    MenuBar *menubar;            // points to menu bar
    StatusBar *statusbar;        // points to status bar
    Bool takingfocus;            // true while taking focus
    virtual void SetColors();
protected:
    // ------------- client window coordinate adjustments
    virtual void AdjustBorders();
public:
    Application(char *ttl, int lf, int tp, int ht, int wd,
                                    MenuBarItem *Menu = NULL)
                : DFWindow(ttl, lf, tp, ht, wd, NULL)
            { OpenWindow(Menu); }
    Application(char *ttl, int ht, int wd,
                                    MenuBarItem *Menu = NULL)
                : DFWindow(ttl, ht, wd, NULL)
            { OpenWindow(Menu); }
    Application(int lf, int tp, int ht, int wd,
                                    MenuBarItem *Menu = NULL)
                : DFWindow(lf, tp, ht, wd, NULL)
            { OpenWindow(Menu); }
    Application(int ht, int wd, MenuBarItem *Menu = NULL)
                : DFWindow(ht, wd, NULL)
            { OpenWindow(Menu); }
    Application(char *ttl, MenuBarItem *Menu = NULL)
                : DFWindow(ttl)
            { OpenWindow(Menu); }
    virtual ~Application()
            { if (windowstate != CLOSED) CloseWindow(); }
    // -------- API messages
    virtual void OpenWindow() { OpenWindow(NULL); }
    void OpenWindow(MenuBarItem *menu);
    virtual void CloseWindow();
    virtual Bool SetFocus();
    virtual void Show();
    virtual void Keyboard(int key);
    virtual void ClockTick();
    void StatusMessage(String& Msg);
};

void DispatchEvents(Application *ApWnd);
void InitializeEvents(void);

#endif


