// ----------- button.h

#ifndef BUTTON_H
#define BUTTON_H

#include "textbox.h"

class PushButton : public TextBox    {
    virtual void SetColors();
    Bool pressed;
    DFWindow *owner;  // window that gets the command
    void (DFWindow::*cmdfunction)();    // selection function
public:
    PushButton(char *lbl, int lf, int tp, DFWindow *par);
    virtual ~PushButton()
        { if (windowstate != CLOSED) CloseWindow(); }
    // -------- API messages
    virtual void OpenWindow();
    virtual void CloseWindow();
    virtual Bool SetFocus();
    virtual void ResetFocus();
    virtual void Paint();
    virtual void Shadow();
    virtual void Keyboard(int key);
    virtual void LeftButton(int mx, int my);
    virtual void ButtonReleased(int mx, int my);
    virtual void MouseMoved(int mx, int my);
    virtual void KeyReleased();
    void PressButton();
    void ReleaseButton();
    void ButtonCommand();
    void SetButtonFunction(DFWindow *wnd,
                    void (DFWindow::*cmdfunc)())
        { owner = wnd; cmdfunction = cmdfunc; }
};

#endif


