
Creation date: Tue Feb 04 16:29:44 1992	decomp.s	page 1


Address	Instruction	Line #	Source line
			1	#include "dsp_type.h"
			1	#define DSP32 1
			2	#if DSP32
			3	#include "dspregs.h"
			1	/* dspregs.h */
			2	/* register file redefinition */
			3	#define  r1e   r1
			4	#define  r2e   r2
			5	#define  r3e   r3
			6	#define  r4e   r4
			7	#define  r5e   r5
			8	#define  r6e   r6
			9	#define  r7e   r7
			10	#define  r8e   r8
			11	#define  r9e   r9
			12	#define  r10e  r10
			13	#define  r11e  r11
			14	#define  r12e  r12
			15	#define  r13e  r13
			16	#define  r14e  r14
			17	#define  r15e  r15
			18	#define  r16e  r16
			19	#define  r17e  r17
			20	#define  r18e  r18
			21	#define  r19e  r19
			22	#define  r20e  r20
			23	#define  r21e  r21
			24	
			25	/* integer and float redefinition */
			26	#define  int24  int
			27	#define  float24  float
			4	#endif
			5	
			6	.global DECOMP
			7	        /*  DECOMP
			8	            perform recursive decomposition on non-terminating data sequence
			9	            registers used: r1 r2 r3 r4 r5 r6 r11 r12 r13 r14 r15 r16
			10	            accumulators used: a0 a1
			11	
			12	            input: r1 - pointer to wavelet high-pass filter coefficients
			13	                   r2 - pointer to wavelet low-pass filter coefficients
			14	                   r6 - pointer to wavelet output data list
			15	                   r11 - jump address for proper filter length
			16	                   r12 - pointer to data pointer array
			17	                   r13 - pointer to stack
			18	                   r14 - return stack register, i.e. "TOP OF STACK"
			19	                   r15 - recursion counter
			20	                   r16 - filter coefficient pointer wrap back index
			21	        */
0000	1ea30197	22	DECOMP:   r3e = *r12++; /* load pointer to approx. input array source */
0004	1ea50190	23	          r5e = *r12;   /* load pointer to approx. output array destination */
0008	002b0000	24	          goto r11;     /* jump to appropriate filter processing for length */
000c	14830008	25	          r4e = r3 + 8; /* set pointer to approx. input array destination */
0010	6003cf87	26	DT6:      a0 = a0 + *r3++ * *r1++; /* pass data through high-pass wavelet */
0014	6003cf87	27	          a0 = a0 + *r3++ * *r1++; /* filter (a0 = 0.0 initially) */
0018	6003cf87	28	DT4:      a0 = a0 + *r3++ * *r1++; /* the destination of the jump depends */
001c	6003cf87	29	          a0 = a0 + *r3++ * *r1++; /* upon the length of the wavelet */
0020	6003cf87	30	DT2:      a0 = a0 + *r3++ * *r1++; /* filter */
0024	002b001c	31	          goto r11 + 28; /* jump to appropriate filter processing for length */
0028	60028d37	32	          *r6++ = a0 = a0 + *r3++r16 * *r1++r16; /* output is detail point */


Creation date: Tue Feb 04 16:29:45 199	decomp.s	page 2


Address	Instruction	Line #	Source line
002c	4425cfa7	33	AT6:      a1 = a1 + (*r4++ = *r3++) * *r2++; /* pass data through low-pass */
0030	4425cfa7	34	          a1 = a1 + (*r4++ = *r3++) * *r2++; /* filter (a1 = 0.0 initially) */
0034	4425cfa7	35	AT4:      a1 = a1 + (*r4++ = *r3++) * *r2++;
0038	4425cfa7	36	          a1 = a1 + (*r4++ = *r3++) * *r2++;
003c	6425cf87	37	AT2:      a1 = a1 + *r3++ * *r2++;
0040	64248f87	38	          a1 = a1 + *r3++ * *r2++r16;
0044	1a910001	39	          r15 = r15 - 1;         /* check the recursion count */
0048	00a00084	40	          if (eq) goto NO_RECUR; /* if true, recursion at bottom of tree */
004c	1be50004	41	          r5e & 0x0004;          /* check for even/odd status */
0050	302000ae	42	          *r5-- = a1 = a1;       /* save approx. data for next level */
0054	00800088	43	          if (ne) goto CLEAN_UP; /* if true, await another data point */
0058	14850008	44	          r4e = r5 + 8;          /* wrap output pointer back */
005c	1fa40197	45	          *r12++ = r4e;          /* save wrapped pointer to approx. O/P */
0060	1fae01b6	46	          *r13-- = r14e;         /* save return address to stack */
0064	34800007	47	          a0 = a0 - a0;          /* clear the accumulators */
0068	11c00000	48	          call DECOMP (r14);     /* recurse down the tree */
006c	30200007	49	          a1 = a0;
			52	#else
0070	15ad0002	53	          r13 = r13 + 2;         /* align stack pointer to return address */
			54	#endif
0074	1eae01b0	55	          r14e = *r13;           /* pop the return address */
0078	00000000	56	          nop;
007c	002e0000	57	          return (r14);
0080	00000000	58	          nop;
			59	
0084	302000b0	60	NO_RECUR: *r6 = a1 = a1;         /* save approx. coeff. as next value */
0088	002e0000	61	CLEAN_UP: return (r14);
008c	1fa50197	62	          *r12++ = r5e;          /* save unwrapped pointer to approx. output */
			63	        /* END OF DECOMP */


d3as:warning:decomp.s line 32: branch dest can't start with CAU reg store inst
d3as:warning:decomp.s line 32: Use output pointer reg only as output pointer in
		 DAU inst at dest after branch instruction



Symbol Table
.file	decomp.s
.bank0	(section 1)	size 0x90
DT2	section 1	defined	value 0x20
DT4	section 1	defined	value 0x18
DT6	section 1	defined	value 0x10
DECOMP	section 1	global	defined	value 0x0
AT2	section 1	defined	value 0x3c
AT4	section 1	defined	value 0x34
AT6	section 1	defined	value 0x2c
CLEAN_UP	section 1	defined	value 0x88
NO_RECUR	section 1	defined	value 0x84
