#include "dsp_type.h"
#if DSP32
#include "dspregs.h"
#endif

.global DECOMP
        /*  DECOMP
            perform recursive decomposition on non-terminating data sequence
            registers used: r1 r2 r3 r4 r5 r6 r11 r12 r13 r14 r15 r16
            accumulators used: a0 a1

            input: r1 - pointer to wavelet high-pass filter coefficients
                   r2 - pointer to wavelet low-pass filter coefficients
                   r6 - pointer to wavelet output data list
                   r11 - jump address for proper filter length
                   r12 - pointer to data pointer array
                   r13 - pointer to stack
                   r14 - return stack register, i.e. "TOP OF STACK"
                   r15 - recursion counter
                   r16 - filter coefficient pointer wrap back index
        */
DECOMP:   r3e = *r12++; /* load pointer to approx. input array source */
          r5e = *r12;   /* load pointer to approx. output array destination */
          goto r11;     /* jump to appropriate filter processing for length */
          r4e = r3 + 8; /* set pointer to approx. input array destination */
DT6:      a0 = a0 + *r3++ * *r1++; /* pass data through high-pass wavelet */
          a0 = a0 + *r3++ * *r1++; /* filter (a0 = 0.0 initially) */
DT4:      a0 = a0 + *r3++ * *r1++; /* the destination of the jump depends */
          a0 = a0 + *r3++ * *r1++; /* upon the length of the wavelet */
DT2:      a0 = a0 + *r3++ * *r1++; /* filter */
          goto r11 + 28; /* jump to appropriate filter processing for length */
          *r6++ = a0 = a0 + *r3++r16 * *r1++r16; /* output is detail point */
AT6:      a1 = a1 + (*r4++ = *r3++) * *r2++; /* pass data through low-pass */
          a1 = a1 + (*r4++ = *r3++) * *r2++; /* filter (a1 = 0.0 initially) */
AT4:      a1 = a1 + (*r4++ = *r3++) * *r2++;
          a1 = a1 + (*r4++ = *r3++) * *r2++;
AT2:      a1 = a1 + *r3++ * *r2++;
          a1 = a1 + *r3++ * *r2++r16;
          r15 = r15 - 1;         /* check the recursion count */
          if (eq) goto NO_RECUR; /* if true, recursion at bottom of tree */
          r5e & 0x0004;          /* check for even/odd status */
          *r5-- = a1 = a1;       /* save approx. data for next level */
          if (ne) goto CLEAN_UP; /* if true, await another data point */
          r4e = r5 + 8;          /* wrap output pointer back */
          *r12++ = r4e;          /* save wrapped pointer to approx. O/P */
          *r13-- = r14e;         /* save return address to stack */
          a0 = a0 - a0;          /* clear the accumulators */
          call DECOMP (r14);     /* recurse down the tree */
          a1 = a0;
#if DSP32C
          r13e = r13 + 4;        /* align stack pointer to return address */
#else
          r13 = r13 + 2;         /* align stack pointer to return address */
#endif
          r14e = *r13;           /* pop the return address */
          nop;
          return (r14);
          nop;

NO_RECUR: *r6 = a1 = a1;         /* save approx. coeff. as next value */
CLEAN_UP: return (r14);
          *r12++ = r5e;          /* save unwrapped pointer to approx. output */
        /* END OF DECOMP */
