
Creation date: Fri Feb 07 09:07:11 1992	drawimag.s	page 1


Address	Instruction	Line #	Source line
			1	#include "dsp_type.h"
			1	#define DSP32 1
			2	#if DSP32
			3	#include "dspregs.h"
			1	/* dspregs.h */
			2	/* register file redefinition */
			3	#define  r1e   r1
			4	#define  r2e   r2
			5	#define  r3e   r3
			6	#define  r4e   r4
			7	#define  r5e   r5
			8	#define  r6e   r6
			9	#define  r7e   r7
			10	#define  r8e   r8
			11	#define  r9e   r9
			12	#define  r10e  r10
			13	#define  r11e  r11
			14	#define  r12e  r12
			15	#define  r13e  r13
			16	#define  r14e  r14
			17	#define  r15e  r15
			18	#define  r16e  r16
			19	#define  r17e  r17
			20	#define  r18e  r18
			21	#define  r19e  r19
			22	#define  r20e  r20
			23	#define  r21e  r21
			24	
			25	/* integer and float redefinition */
			26	#define  int24  int
			27	#define  float24  float
			4	#endif
			5	
			6	.global DRAWIMAG
			7	        /*  DRAWIMAG
			8	            draw image of supplied point and connect to previous point
			9	            registers used: r1 r2 r3 r4 r5 r6 r7 r12 r13 r14
			10	            accumulators used: a0 a1
			11	
			12	            input: r12 - pointer to data pointer array
			13	                   r13 - pointer to stack
			14	                   r14 - return stack register, i.e. "TOP OF STACK"
			15	                   a0 - data point to draw
			16	        */
0000	2099ff87	17	DRAWIMAG: a0 = *r12++ - a0 * *r12++; /* multiply by scalling coefficient */
0004	35380007	18	          a1 = -a0 + *r12;    /* determine if value above upper threshold */
0008	7a803387	19	          a0 = ifalt(*r12++); /* if true, limit data to threshold */
000c	34b80007	20	          a1 = a0 - *r12;     /* determine if value below lower threshold */
0010	7a803387	21	          a0 = ifalt(*r12++); /* if true, limit data to threshold */
0014	79800067	22	          *r12++ = a0 = int(a0); /* convert data to integer format */
0018	00000000	23	          nop;
001c	14ccfffe	24	          r6e = r12 - 2;        /* point to temporary storage */
0020	1ea10197	25	          r1 = *r12++;          /* load the row increment value */
0024	1ea40197	26	          r4 = *r12++;          /* load the row baseline offset value */
0028	1ea20197	27	          r2 = *r12++;          /* load the bit pointer */
002c	1ea30190	28	          r3e = *r12;           /* load the byte column pointer */
0030	1ea600d0	29	          r6 = *r6;             /* read the new byte column pointer offset */
0034	1ae20080	30	          r2 - 0x80;            /* check if first bit of new byte column */
0038	008000a0	31	          if (ne) goto ADD_BAR; /* if true, add new bar to byte column */
003c	00000000	32	          nop;


Creation date: Fri Feb 07 09:07:12 199	drawimag.s	page 2


Address	Instruction	Line #	Source line
			76	#else
0040	182600c0	77	          r6 = r6 * 2;     /* multiply offset by four to account for ... */
0044	182600c0	78	          r6 = r6 * 2;     /* four bytes per instruction in MEMSET */
0048	1ae6005c	79	          r6 - 92;         /* check if datum point is above baseline */
004c	01a00064	80	          if (le) goto ABOVE_BL; /* if true, it is above the baseline */
0050	18a500c0	81	          r5 = -r6;      /* middle counter for draw of bar pixels */
0054	14800000	82	          r4 = 0;        /* top counter for clearing of pixel over bar */
0058	14a500c4	83	          r5 = r5 + 196; /* middle counter for draw of bar pixels */
005c	00200074	84	          goto DRAW_COL; /* go draw the column of pixels */
0060	1a86005c	85	          r6 = r6 - 92;  /* bottom counter for clearing of pixel under bar */
			86	
0064	18a400c0	87	ABOVE_BL: r4 = -r6;      /* top counter for clearing of pixel over bar */
0068	14840064	88	          r4 = r4 + 100; /* top counter for clearing of pixel over bar */
006c	14a60004	89	          r5 = r6 + 4;   /* middle counter for draw of bar pixels */
0070	14c00000	90	          r6 = 0;        /* bottom counter for clearing of pixel under bar */
0074	1fae01b6	91	DRAW_COL: *r13-- = r14;  /* save return address to the stack */
0078	11c4010c	92	          call r4+MEMSET (r14); /* zero the bytes above the bar */
007c	188700e0	93	          r7 = r7 - r7;         /* force the register to zero */
0080	11c5010c	94	          call r5+MEMSET (r14); /* set the bytes of the bar */
0084	14e20000	95	          r7 = r2;              /* MSB of byte is bar, others cleared */
0088	11c6010c	96	          call r6+MEMSET (r14); /* zero the bytes below the bar */
008c	188700e0	97	          r7 = r7 - r7;         /* force the register to zero */
0090	15ad0002	98	          r13 = r13 + 2;        /* point to return address on the stack */
0094	1eae01b0	99	          r14 = *r13;           /* load the return address from the stack */
0098	002000ec	100	NO_BOT:   goto SHIFTBIT; /* go shift the bit pointer and clear up */
009c	1ea30190	101	          r3 = *r12;     /* reload the byte pointer */
			102	
00a0	182600c0	103	ADD_BAR:  r6 = r6 * 2;   /* multiply offset by twelve to account for ... */
00a4	182600c0	104	          r6 = r6 * 2;   /* four bytes per instruction and ... */
00a8	182700c0	105	          r7 = r6 * 2;   /* three instructions per byte in MEM_OR */
00ac	180600e0	106	          r6 = r6 + r7;
00b0	1ae60120	107	          r6 - 288;               /* check if datum below baseline */
00b4	018000c4	108	          if (gt) goto BELOW_BL; /* if true, datum is below baseline */
00b8	1a860120	109	          r6 = r6 - 288; /* calculate length of bar */
00bc	18a600c0	110	          r6 = -r6;      /* datum above baseline length was negative */
00c0	18a10020	111	          r1 = -r1;      /* datum above baseline, increment is decrement */
00c4	1a460120	112	BELOW_BL: r6 = 288 - r6  /* align the counter for proper call */
00c8	18040060	113	          r4 = r4 + r3;  /* add baseline offset to byte column pointer */
00cc	14a40000	114	          r5 = r4;
00d0	18050020	115	          r5 = r5 + r1;  /* move pointer away from the baseline */
00d4	1fae01b6	116	          *r13-- = r14;  /* save return address to the stack */
00d8	14e00000	117	          r7 = 0;        /* zero initial storage value */
00dc	11c60178	118	          call r6+MEM_OR (r14);
00e0	14c70000	119	          r6 = r7;
00e4	15ad0002	120	          r13 = r13 + 2;        /* point to return address on the stack */
00e8	1eae01b0	121	          r14 = *r13;           /* load the return address from the stack */
			122	#endif
			123	
00ec	19820040	124	SHIFTBIT: r2 = r2 >> 1;    /* shift the pixel pointed to right */
00f0	00800100	125	          if (ne) goto NO_WRAP; /* if true, don't wrap the pixel pointer */
00f4	1a8c0002	126	          r12e = r12 - 2;  /* point to bit pointer storage */
00f8	14400080	127	          r2 = 0x0080;     /* new bit mask if pixel wraps */
00fc	14630001	128	          r3e = r3 + 1;    /* increment base to next byte upon wrap */
0100	1fa20197	129	NO_WRAP:  *r12++ = r2;     /* save the next bit pointer */
0104	002e0000	130	          return (r14);
0108	1fa30197	131	          *r12++ = r3e;    /* save the next byte pointer start value */
			132	        /* END OF DRAWIMAG */
			133	
			134	#if DSP32
			135	        /*  MEMSET


Creation date: Fri Feb 07 09:07:12 199	drawimag.s	page 3


Address	Instruction	Line #	Source line
			136	            set column of image bytes to a given value
			137	            registers used: r1 r3 r7 r14
			138	
			139	            input: r1 - postincrement value
			140	                   r3 - byte column pointer
			141	                   r7 - storage value
			142	                   r14 - return stack register, i.e. "TOP OF STACK"
			143	        */
010c	1f670061	144	MEMSET:   *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
0110	1f670061	144
0114	1f670061	144
0118	1f670061	144
011c	1f670061	145	          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
0120	1f670061	145
0124	1f670061	145
0128	1f670061	145
012c	1f670061	146	          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
0130	1f670061	146
0134	1f670061	146
0138	1f670061	146
013c	1f670061	147	          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
0140	1f670061	147
0144	1f670061	147
0148	1f670061	147
014c	1f670061	148	          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
0150	1f670061	148
0154	1f670061	148
0158	1f670061	148
015c	1f670061	149	          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
0160	1f670061	149
0164	1f670061	149
0168	1f670061	149
016c	1f670061	150	          *r3++r1 = r7l;
			151	
0170	002e0000	152	          return (r14);
0174	00000000	153	          nop;
			154	        /* END OF MEMSET */
			155	
			156	        /*  MEM_OR
			157	            logical OR column of image bytes with a given value
			158	            registers used: r1 r4 r5 r6 r7 r14
			159	
			160	            input: r1 - postincrement value
			161	                   r2 - 'OR' value
			162	                   r4 - lagging byte column pointer
			163	                   r5 - leading byte column pointer
			164	                   r14 - return stack register, i.e. "TOP OF STACK"
			165	        */
0178	1e6600a1	166	MEM_OR:   r6l = *r5++r1;  /* load column byte */
017c	1f670081	167	          *r4++r1 = r7l;  /* save initial 'dummy' value */
0180	19460040	168	          r6 = r6 | r2;   /* 'OR' column byte with byte value */
0184	1e6700a1	169	          r7l = *r5++r1;  /* load the next column byte */
0188	1f660081	170	          *r4++r1 = r6l;  /* save the new column byte value */
018c	19470040	171	          r7 = r7 | r2;   /* 'OR' the next column byte with the byte value */
0190	1e6600a1	172	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
0194	1f670081	172
0198	19460040	172
019c	1e6700a1	173	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
01a0	1f660081	173
01a4	19470040	173


Creation date: Fri Feb 07 09:07:12 199	drawimag.s	page 4


Address	Instruction	Line #	Source line
01a8	1e6600a1	174	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
01ac	1f670081	174
01b0	19460040	174
01b4	1e6700a1	175	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
01b8	1f660081	175
01bc	19470040	175
01c0	1e6600a1	176	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
01c4	1f670081	176
01c8	19460040	176
01cc	1e6700a1	177	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
01d0	1f660081	177
01d4	19470040	177
01d8	1e6600a1	178	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
01dc	1f670081	178
01e0	19460040	178
01e4	1e6700a1	179	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
01e8	1f660081	179
01ec	19470040	179
01f0	1e6600a1	180	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
01f4	1f670081	180
01f8	19460040	180
01fc	1e6700a1	181	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
0200	1f660081	181
0204	19470040	181
0208	1e6600a1	182	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
020c	1f670081	182
0210	19460040	182
0214	1e6700a1	183	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
0218	1f660081	183
021c	19470040	183
0220	1e6600a1	184	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
0224	1f670081	184
0228	19460040	184
022c	1e6700a1	185	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
0230	1f660081	185
0234	19470040	185
0238	1e6600a1	186	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
023c	1f670081	186
0240	19460040	186
0244	1e6700a1	187	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
0248	1f660081	187
024c	19470040	187
0250	1e6600a1	188	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
0254	1f670081	188
0258	19460040	188
025c	1e6700a1	189	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
0260	1f660081	189
0264	19470040	189
0268	1e6600a1	190	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
026c	1f670081	190
0270	19460040	190
0274	1e6700a1	191	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
0278	1f660081	191
027c	19470040	191
0280	1e6600a1	192	          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
0284	1f670081	192
0288	19460040	192
028c	1e6700a1	193	          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
0290	1f660081	193
0294	19470040	193


Creation date: Fri Feb 07 09:07:12 199	drawimag.s	page 5


Address	Instruction	Line #	Source line
0298	1e6600a1	194	          r6l = *r5++r1;  *r4++r1 = r7l;
029c	1f670081	194
02a0	002e0000	195	          return (r14);
02a4	00000000	196	          nop;
			197	        /* END OF MEMSET */
			198	#endif


d3as:warning:drawimag.s line 101: branch dest can't start with inst referencing
		 reg being loaded



Symbol Table
.file	drawimag.s
.bank0	(section 1)	size 0x2a8
NO_BOT	section 1	defined	value 0x98
MEMSET	section 1	defined	value 0x10c
SHIFTBIT	section 1	defined	value 0xec
BELOW_BL	section 1	defined	value 0xc4
DRAWIMAG	section 1	global	defined	value 0x0
MEM_OR	section 1	defined	value 0x178
ADD_BAR	section 1	defined	value 0xa0
NO_WRAP	section 1	defined	value 0x100
ABOVE_BL	section 1	defined	value 0x64
DRAW_COL	section 1	defined	value 0x74
