#include "dsp_type.h"
#if DSP32
#include "dspregs.h"
#endif

.global DRAWIMAG
        /*  DRAWIMAG
            draw image of supplied point and connect to previous point
            registers used: r1 r2 r3 r4 r5 r6 r7 r12 r13 r14
            accumulators used: a0 a1

            input: r12 - pointer to data pointer array
                   r13 - pointer to stack
                   r14 - return stack register, i.e. "TOP OF STACK"
                   a0 - data point to draw
        */
DRAWIMAG: a0 = *r12++ - a0 * *r12++; /* multiply by scalling coefficient */
          a1 = -a0 + *r12;    /* determine if value above upper threshold */
          a0 = ifalt(*r12++); /* if true, limit data to threshold */
          a1 = a0 - *r12;     /* determine if value below lower threshold */
          a0 = ifalt(*r12++); /* if true, limit data to threshold */
          *r12++ = a0 = int(a0); /* convert data to integer format */
          nop;
          r6e = r12 - 2;        /* point to temporary storage */
          r1 = *r12++;          /* load the row increment value */
          r4 = *r12++;          /* load the row baseline offset value */
          r2 = *r12++;          /* load the bit pointer */
          r3e = *r12;           /* load the byte column pointer */
          r6 = *r6;             /* read the new byte column pointer offset */
          r2 - 0x80;            /* check if first bit of new byte column */
          if (ne) goto ADD_BAR; /* if true, add new bar to byte column */
          nop;
#if DSP32C
          r6 - 23;               /* check if datum point is above baseline */
          if (le) goto ABOVE_BL; /* if true, it is above the baseline */
          nop;
          r4 = 25;       /* top counter for clearing of pixel over bar */
          r5 = r6 - 24;  /* middle counter for draw of bar pixels */
          goto DRAW_COL; /* go draw the column of pixels */
          r6 = 48 - r6;  /* bottom counter for clearing of pixel under bar */

ABOVE_BL: r4 = r6;      /* top counter for clearing of pixel over bar */
          r5 = r6;
          r5 = 24 - r5; /* middle counter for draw of bar pixels */
          r6 = 25;      /* bottom counter for clearing of pixel under bar */
DRAW_COL: r4 = r4 - 1;  /* check if no top pixels are to be cleared */
          if (lt) goto NO_TOP; /* if true, skip clearing bytes above bar */
          r7 = r7 - r7;        /* force the register to zero */
          do 0, r4;            /* repeat next instruntion r4+1 times */
          *r3++r1 = r7l;       /* zero the bytes above the bar */
NO_TOP:   r5 = r5 - 1;         /* check if no bar pixels are to be set */
          if (lt) goto NO_MID; /* if true, skip setting bytes of bar */
          nop;
          do 0, r5;         /* repeat next instruntion r5+1 times */
          *r3++r1 = r2l;    /* MSB of byte is bar, others cleared */
NO_MID:   r6 = r6 - 1;      /* check if no bottom pixels are to be cleared */
          if (lt) goto NO_BOT; /* if true, skip clearing bytes below bar */
          nop;
          do 0, r6;            /* repeat next instruntion r6+1 times */
          *r3++r1 = r7l;       /* zero the bytes below the bar */
NO_BOT:   goto SHIFTBIT; /* go shift the bit pointer and clear up */
          r3e = *r12;    /* reload the byte pointer */

ADD_BAR:  r6 - 24;              /* check if datum below baseline */
          if (gt) goto BELOW_BL; /* if true, datum is below baseline */
          r6 = r6 - 24;  /* calculate length of bar */
          r6 = -r6;      /* datum above baseline length was negative */
          r1e = -r1;     /* datum above baseline, increment is decrement */
BELOW_BL: r4e = r4 + r3; /* add baseline offset to byte column pointer */
          r5e = r4 + r1; /* move pointer away from the baseline */
          r7 = 0;        /* zero initial storage value */
          do 2, r6;      /* repeat the next 3 instructions r6+1 times */
          r6l = *r5++r1; /* load the byte */
          *r4++r1 = r7l; /* store the byte and move the pointer */
          r7 = r6 | r2;  /* OR byte with bit pointer to set the bit */
#else
          r6 = r6 * 2;     /* multiply offset by four to account for ... */
          r6 = r6 * 2;     /* four bytes per instruction in MEMSET */
          r6 - 92;         /* check if datum point is above baseline */
          if (le) goto ABOVE_BL; /* if true, it is above the baseline */
          r5 = -r6;      /* middle counter for draw of bar pixels */
          r4 = 0;        /* top counter for clearing of pixel over bar */
          r5 = r5 + 196; /* middle counter for draw of bar pixels */
          goto DRAW_COL; /* go draw the column of pixels */
          r6 = r6 - 92;  /* bottom counter for clearing of pixel under bar */

ABOVE_BL: r4 = -r6;      /* top counter for clearing of pixel over bar */
          r4 = r4 + 100; /* top counter for clearing of pixel over bar */
          r5 = r6 + 4;   /* middle counter for draw of bar pixels */
          r6 = 0;        /* bottom counter for clearing of pixel under bar */
DRAW_COL: *r13-- = r14;  /* save return address to the stack */
          call r4+MEMSET (r14); /* zero the bytes above the bar */
          r7 = r7 - r7;         /* force the register to zero */
          call r5+MEMSET (r14); /* set the bytes of the bar */
          r7 = r2;              /* MSB of byte is bar, others cleared */
          call r6+MEMSET (r14); /* zero the bytes below the bar */
          r7 = r7 - r7;         /* force the register to zero */
          r13 = r13 + 2;        /* point to return address on the stack */
          r14 = *r13;           /* load the return address from the stack */
NO_BOT:   goto SHIFTBIT; /* go shift the bit pointer and clear up */
          r3 = *r12;     /* reload the byte pointer */

ADD_BAR:  r6 = r6 * 2;   /* multiply offset by twelve to account for ... */
          r6 = r6 * 2;   /* four bytes per instruction and ... */
          r7 = r6 * 2;   /* three instructions per byte in MEM_OR */
          r6 = r6 + r7;
          r6 - 288;               /* check if datum below baseline */
          if (gt) goto BELOW_BL; /* if true, datum is below baseline */
          r6 = r6 - 288; /* calculate length of bar */
          r6 = -r6;      /* datum above baseline length was negative */
          r1 = -r1;      /* datum above baseline, increment is decrement */
BELOW_BL: r6 = 288 - r6  /* align the counter for proper call */
          r4 = r4 + r3;  /* add baseline offset to byte column pointer */
          r5 = r4;
          r5 = r5 + r1;  /* move pointer away from the baseline */
          *r13-- = r14;  /* save return address to the stack */
          r7 = 0;        /* zero initial storage value */
          call r6+MEM_OR (r14);
          r6 = r7;
          r13 = r13 + 2;        /* point to return address on the stack */
          r14 = *r13;           /* load the return address from the stack */
#endif

SHIFTBIT: r2 = r2 >> 1;    /* shift the pixel pointed to right */
          if (ne) goto NO_WRAP; /* if true, don't wrap the pixel pointer */
          r12e = r12 - 2;  /* point to bit pointer storage */
          r2 = 0x0080;     /* new bit mask if pixel wraps */
          r3e = r3 + 1;    /* increment base to next byte upon wrap */
NO_WRAP:  *r12++ = r2;     /* save the next bit pointer */
          return (r14);
          *r12++ = r3e;    /* save the next byte pointer start value */
        /* END OF DRAWIMAG */

#if DSP32
        /*  MEMSET
            set column of image bytes to a given value
            registers used: r1 r3 r7 r14

            input: r1 - postincrement value
                   r3 - byte column pointer
                   r7 - storage value
                   r14 - return stack register, i.e. "TOP OF STACK"
        */
MEMSET:   *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
          *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;  *r3++r1 = r7l;
          *r3++r1 = r7l;

          return (r14);
          nop;
        /* END OF MEMSET */

        /*  MEM_OR
            logical OR column of image bytes with a given value
            registers used: r1 r4 r5 r6 r7 r14

            input: r1 - postincrement value
                   r2 - 'OR' value
                   r4 - lagging byte column pointer
                   r5 - leading byte column pointer
                   r14 - return stack register, i.e. "TOP OF STACK"
        */
MEM_OR:   r6l = *r5++r1;  /* load column byte */
          *r4++r1 = r7l;  /* save initial 'dummy' value */
          r6 = r6 | r2;   /* 'OR' column byte with byte value */
          r7l = *r5++r1;  /* load the next column byte */
          *r4++r1 = r6l;  /* save the new column byte value */
          r7 = r7 | r2;   /* 'OR' the next column byte with the byte value */
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;  r6 = r6 | r2;
          r7l = *r5++r1;  *r4++r1 = r6l;  r7 = r7 | r2;
          r6l = *r5++r1;  *r4++r1 = r7l;
          return (r14);
          nop;
        /* END OF MEMSET */
#endif
