/* WAVEDATA.S */
#include "dsp_type.h"
#if DSP32
#include "dspregs.h"
#endif

.global WAVEADRS, WAVELVLS, IMAGSHOW, LVLADDRS
.global SIG_DRAW, DRAW_CNT, H_FILTER, L_FILTER
.global RST_DATA, IM0_PTRS, IM1_PTRS, IMAGE_0
.global STACKEND, SIGNALIN, DATA_OUT

.align 4
WAVEADRS: int24 0;       /* jump address for wavelet filter length */
WAVEINDX: int24 0;       /* wrap back index for wavelet filter length */
WAVELVLS: int   6, 1625; /* number of levels, clear loop counter */
IMAGSHOW: int   8, 0;    /* unit interval count, active image pointer */
LVLADDRS: int24 SIGNALIN, APPROX_5; /* data pointer storage for level 5 */

          int24 APPROX_5, APPROX_4; /* data pointer storage for level 4 */

          int24 APPROX_4, APPROX_3; /* data pointer storage for level 3 */

          int24 APPROX_3, APPROX_2; /* data pointer storage for level 2 */

          int24 APPROX_2, APPROX_1; /* data pointer storage for level 1 */

          int24 APPROX_1, 0;        /* data pointer storage for level 0 */

.align 4
SIG_DRAW: float 0.0, 24.0, 48.0, 0.0; /* scaling and offset coefficients */
          int   0, 64;                /* temp storage, row increment */
          int   1536, 0;              /* baseline value, bit pointer */
          int24 0;                    /* byte column pointer */
.align 4
          float 0.0, 24.0, 48.0, 0.0;
          int   0, 32;
          int   768, 0;
          int24 0;
.align 4
          float 0.0, 24.0, 48.0, 0.0;
          int   0, 16;
          int   384, 0;
          int24 0;
.align 4
          float 0.0, 24.0, 48.0, 0.0;
          int   0, 8;
          int   192, 0;
          int24 0;
.align 4
          float 0.0, 24.0, 48.0, 0.0;
          int   0, 4;
          int   96, 0;
          int24 0;
.align 4
          float 0.0, 24.0, 48.0, 0.0;
          int   0, 2;
          int   48, 0;
          int24 0;
.align 4
          float 0.0, 24.0, 48.0, 0.0;
          int   0, 2;
          int   48, 0;
          int24 0;
.align 4
          float 0.0, 24.0, 48.0, 0.0;
          int   0, 2;
          int   48, 0;
          int24 0;

DRAW_CNT: byte 6, 4, 3, 2, 1, 0;

.align 4
H_FILTER: 6*float 0.0; /* highpass wavelet filter storage allocation */

L_FILTER: 6*float 0.0; /* lowpass wavelet filter storage allocation */

/* image pointer reset initialization data */
RST_DATA: int24 0x02; /* position of first pixel in unit interval at reset */
          int24 IM0INITS; /* 00 00 00 00 00 00 00 01 */

          int24 0x01, IM0INIT5; /* 00 00 00 01 */

          int24 0x01, IM0INIT4; /* 00 01 */

          int24 0x01, IM0_LVL3; /* 01 */

          int24 0x10, IM0_LVL2; /* 10 */

          int24 0x40, IM0_LVL1; /* 40 */

          int24 0x80, IM0_LVL0; /* 80 */

          int24 0x80, IM0_LVLA; /* 80 */

/* image pointer switch initialization data */
IM0_PTRS: int24 IM0SIGNL, IM0_LVL5, IM0_LVL4, IM0_LVL3;
          int24 IM0_LVL2, IM0_LVL1, IM0_LVL0, IM0_LVLA;

IM1_PTRS: int24 IM1SIGNL, IM1_LVL5, IM1_LVL4, IM1_LVL3;
          int24 IM1_LVL2, IM1_LVL1, IM1_LVL0, IM1_LVLA;

/* IMAGE 0 storage allocation */
IMAGE_0:
IM0SIGNL: 7*byte 0;
IM0INITS: 3193*byte 0;

IM0_LVL5: 3*byte 0;
IM0INIT5: 1597*byte 0;

IM0_LVL4: byte 0;
IM0INIT4: 799*byte 0;

IM0_LVL3: 400*byte 0;

IM0_LVL2: 200*byte 0;

IM0_LVL1: 100*byte 0;

IM0_LVL0: 100*byte 0;

IM0_LVLA: 100*byte 0;

/* IMAGE 1 storage allocation */
IM1SIGNL: 3200*byte 0;

IM1_LVL5: 1600*byte 0;

IM1_LVL4: 800*byte 0;

IM1_LVL3: 400*byte 0;

IM1_LVL2: 200*byte 0;

IM1_LVL1: 100*byte 0;

IM1_LVL0: 100*byte 0;

IM1_LVLA: 100*byte 0;

.align 2
STACKBSE: 31*int24 0; /* subroutine stack storage allocation */
STACKEND: int24 0;

.rsect ".hi_ram"
SIGNALIN: 6*float 0.0; /* approximation data storage allocation */
APPROX_5: 6*float 0.0;
APPROX_4: 6*float 0.0;
APPROX_3: 6*float 0.0;
APPROX_2: 6*float 0.0;
APPROX_1: 6*float 0.0;
DATA_OUT: 9*float 0.0; /* output data storage allocation */

